--
-- This is file `texnegar-char-table.lua',
-- generated with the docstrip utility.
--
-- The original source files were:
--
-- texnegar.dtx  (with options: `texnegar-char-table-lua')
--
-- Copyright (C) 2020 Hossein Movahhedian
--
-- It may be distributed and/or modified under the LaTeX Project Public License,
-- version 1.3c or higher (your choice). The latest version of
-- this license is at: http://www.latex-project.org/lppl.txt
--
-- texnegar_char_table        = texnegar_char_table or {}
-- local texnegar_char_table  = texnegar_char_table
-- texnegar_char_table.module = {
--     name                   = "texnegar_char_table",
--     version                = "0.1b",
--     date                   = "2020-08-30",
--     description            = "Full implementation of kashida feature in XeLaTex and LuaLaTeX",
--     author                 = "Hossein Movahhedian",
--     copyright              = "Hossein Movahhedian",
--     license                = "LPPL v1.3c"
-- }
--
-- -- ^^A%%  texnegar-lua.dtx -- part of TEXNEGAR <bitbucket.org/dma8hm1334/texnegar>
-- local err, warn, info, log = luatexbase.provides_module(texnegar_char_table.module)
-- texnegar_char_table.log     = log  or (function (s) luatexbase.module_info("texnegar_char_table", s)    end)
-- texnegar_char_table.warning = warn or (function (s) luatexbase.module_warning("texnegar_char_table", s) end)
-- texnegar_char_table.error   = err  or (function (s) luatexbase.module_error("texnegar_char_table", s)   end)

local peCharTableInitial  = {
  [64344] = utf8.char(64344),  -- "ﭘ",  utf8.codepoint("ﭘ") == 64344,  "\u{FB58}", INITIAL FORM PEH
  [64380] = utf8.char(64380),  -- "ﭼ",  utf8.codepoint("ﭼ") == 64380,  "\u{FB7C}", INITIAL FORM TCHEH
  [64400] = utf8.char(64400),  -- "ﮐ",  utf8.codepoint("ﮐ") == 64400,  "\u{FB90}", INITIAL FORM KEHEH
  [64404] = utf8.char(64404),  -- "ﮔ",  utf8.codepoint("ﮔ") == 64404,  "\u{FB94}", INITIAL FORM GAF
  [64510] = utf8.char(64510),  -- "ﯾ",  utf8.codepoint("ﯾ") == 64510,  "\u{FBFE}", INITIAL FORM YEH
  [65169] = utf8.char(65169),  -- "ﺑ",  utf8.codepoint("ﺑ") == 65169,  "\u{FE91}", INITIAL FORM BEH
  [65175] = utf8.char(65175),  -- "ﺗ",  utf8.codepoint("ﺗ") == 65175,  "\u{FE97}", INITIAL FORM TEH
  [65179] = utf8.char(65179),  -- "ﺛ",  utf8.codepoint("ﺛ") == 65179,  "\u{FE9B}", INITIAL FORM THEH
  [65183] = utf8.char(65183),  -- "ﺟ",  utf8.codepoint("ﺟ") == 65183,  "\u{FE9F}", INITIAL FORM JEEM
  [65187] = utf8.char(65187),  -- "ﺣ",  utf8.codepoint("ﺣ") == 65187,  "\u{FEA3}", INITIAL FORM HAH
  [65191] = utf8.char(65191),  -- "ﺧ",  utf8.codepoint("ﺧ") == 65191,  "\u{FEA7}", INITIAL FORM KHAH
  [65203] = utf8.char(65203),  -- "ﺳ",  utf8.codepoint("ﺳ") == 65203,  "\u{FEB3}", INITIAL FORM SEEN
  [65207] = utf8.char(65207),  -- "ﺷ",  utf8.codepoint("ﺷ") == 65207,  "\u{FEB7}", INITIAL FORM SHEEN
  [65211] = utf8.char(65211),  -- "ﺻ",  utf8.codepoint("ﺻ") == 65211,  "\u{FEBB}", INITIAL FORM SAD
  [65215] = utf8.char(65215),  -- "ﺿ",  utf8.codepoint("ﺿ") == 65215,  "\u{FEBF}", INITIAL FORM DAD
  [65219] = utf8.char(65219),  -- "ﻃ",  utf8.codepoint("ﻃ") == 65219,  "\u{FEC3}", INITIAL FORM TAH
  [65223] = utf8.char(65223),  -- "ﻇ",  utf8.codepoint("ﻇ") == 65223,  "\u{FEC7}", INITIAL FORM ZAH
  [65227] = utf8.char(65227),  -- "ﻋ",  utf8.codepoint("ﻋ") == 65227,  "\u{FECB}", INITIAL FORM AIN
  [65231] = utf8.char(65231),  -- "ﻏ",  utf8.codepoint("ﻏ") == 65231,  "\u{FECF}", INITIAL FORM GHAIN
  [65235] = utf8.char(65235),  -- "ﻓ",  utf8.codepoint("ﻓ") == 65235,  "\u{FED3}", INITIAL FORM FEH
  [65239] = utf8.char(65239),  -- "ﻗ",  utf8.codepoint("ﻗ") == 65239,  "\u{FED7}", INITIAL FORM QAF
  [65243] = utf8.char(65243),  -- "ﻛ",  utf8.codepoint("ﻛ") == 65243,  "\u{FEDB}", INITIAL FORM KAF
  [65247] = utf8.char(65247),  -- "ﻟ",  utf8.codepoint("ﻟ") == 65247,  "\u{FEDF}", INITIAL FORM LAM
  [65251] = utf8.char(65251),  -- "ﻣ",  utf8.codepoint("ﻣ") == 65251,  "\u{FEE3}", INITIAL FORM MEEM
  [65255] = utf8.char(65255),  -- "ﻧ",  utf8.codepoint("ﻧ") == 65255,  "\u{FEE7}", INITIAL FORM NOON
  [65259] = utf8.char(65259),  -- "ﻫ",  utf8.codepoint("ﻫ") == 65259,  "\u{FEEB}", INITIAL FORM HEH
  [65267] = utf8.char(65267),  -- "ﻳ",  utf8.codepoint("ﻳ") == 65267,  "\u{FEF3}", INITIAL FORM YEH
}

local peCharTableMedial  = {
  [1600]  = utf8.char(1600),   -- "ـ",  utf8.codepoint("ـ") == 1600,   "\u{0640}", ARABIC TATWEEL
  [64345] = utf8.char(64345),  -- "ﭙ",  utf8.codepoint("ﭙ") == 64345,  "\u{FB59}", MEDIAL FORM PEH
  [64381] = utf8.char(64381),  -- "ﭽ",  utf8.codepoint("ﭽ") == 64381,  "\u{FB7D}", MEDIAL FORM TCHEH
  [64401] = utf8.char(64401),  -- "ﮑ",  utf8.codepoint("ﮑ") == 64401,  "\u{FB91}", MEDIAL FORM KEHEH
  [64405] = utf8.char(64405),  -- "ﮕ",  utf8.codepoint("ﮕ") == 64405,  "\u{FB95}", MEDIAL FORM GAF
  [64425] = utf8.char(64425),  -- "ﮩ",  utf8.codepoint("ﮩ") == 64425,  "\u{FBA9}", MEDIAL FORM HEH GOAL
  [64429] = utf8.char(64429),  -- "ﮭ",  utf8.codepoint("ﮭ") == 64429,  "\u{FBAD}", MEDIAL FORM HEH DOACHESMEE
  [64511] = utf8.char(64511),  -- "ﯿ",  utf8.codepoint("ﯿ") == 64511,  "\u{FBFF}", MEDIAL FORM YEH
  [65170] = utf8.char(65170),  -- "ﺒ",  utf8.codepoint("ﺒ") == 65170,  "\u{FE92}", MEDIAL FORM BEH
  [65176] = utf8.char(65176),  -- "ﺘ",  utf8.codepoint("ﺘ") == 65176,  "\u{FE98}", MEDIAL FORM TEH
  [65180] = utf8.char(65180),  -- "ﺜ",  utf8.codepoint("ﺜ") == 65180,  "\u{FE9C}", MEDIAL FORM THEH
  [65184] = utf8.char(65184),  -- "ﺠ",  utf8.codepoint("ﺠ") == 65184,  "\u{FEA0}", MEDIAL FORM JEEM
  [65188] = utf8.char(65188),  -- "ﺤ",  utf8.codepoint("ﺤ") == 65188,  "\u{FEA4}", MEDIAL FORM HAH
  [65192] = utf8.char(65192),  -- "ﺨ",  utf8.codepoint("ﺨ") == 65192,  "\u{FEA8}", MEDIAL FORM KHAH
  [65204] = utf8.char(65204),  -- "ﺴ",  utf8.codepoint("ﺴ") == 65204,  "\u{FEB4}", MEDIAL FORM SEEN
  [65208] = utf8.char(65208),  -- "ﺸ",  utf8.codepoint("ﺸ") == 65208,  "\u{FEB8}", MEDIAL FORM SHEEN
  [65212] = utf8.char(65212),  -- "ﺼ",  utf8.codepoint("ﺼ") == 65212,  "\u{FEBC}", MEDIAL FORM SAD
  [65216] = utf8.char(65216),  -- "ﻀ",  utf8.codepoint("ﻀ") == 65216,  "\u{FEC0}", MEDIAL FORM DAD
  [65220] = utf8.char(65220),  -- "ﻄ",  utf8.codepoint("ﻄ") == 65220,  "\u{FEC4}", MEDIAL FORM TAH
  [65224] = utf8.char(65224),  -- "ﻈ",  utf8.codepoint("ﻈ") == 65224,  "\u{FEC8}", MEDIAL FORM ZAH
  [65228] = utf8.char(65228),  -- "ﻌ",  utf8.codepoint("ﻌ") == 65228,  "\u{FECC}", MEDIAL FORM AIN
  [65232] = utf8.char(65232),  -- "ﻐ",  utf8.codepoint("ﻐ") == 65232,  "\u{FED0}", MEDIAL FORM GHAIN
  [65236] = utf8.char(65236),  -- "ﻔ",  utf8.codepoint("ﻔ") == 65236,  "\u{FED4}", MEDIAL FORM FEH
  [65240] = utf8.char(65240),  -- "ﻘ",  utf8.codepoint("ﻘ") == 65240,  "\u{FED8}", MEDIAL FORM QAF
  [65244] = utf8.char(65244),  -- "ﻜ",  utf8.codepoint("ﻜ") == 65244,  "\u{FEDC}", MEDIAL FORM KAF
  [65248] = utf8.char(65248),  -- "ﻠ",  utf8.codepoint("ﻠ") == 65248,  "\u{FEE0}", MEDIAL FORM LAM
  [65252] = utf8.char(65252),  -- "ﻤ",  utf8.codepoint("ﻤ") == 65252,  "\u{FEE4}", MEDIAL FORM MEEM
  [65256] = utf8.char(65256),  -- "ﻨ",  utf8.codepoint("ﻨ") == 65256,  "\u{FEE8}", MEDIAL FORM NOON
  [65260] = utf8.char(65260),  -- "ﻬ",  utf8.codepoint("ﻬ") == 65260,  "\u{FEEC}", MEDIAL FORM HEH
  [65268] = utf8.char(65268),  -- "ﻴ",  utf8.codepoint("ﻴ") == 65268,  "\u{FEF4}", MEDIAL FORM YEH
}

local peCharTableFinal  = {
  [64343] = utf8.char(64343),  -- "ﭗ",  utf8.codepoint("ﭗ") == 64343,  "\u{FB57}", FINAL FORM PEH
  [64379] = utf8.char(64379),  -- "ﭻ",  utf8.codepoint("ﭻ") == 64379,  "\u{FB7B}", FINAL FORM TCHEH
  [64395] = utf8.char(64395),  -- "ﮋ",  utf8.codepoint("ﮋ") == 64395,  "\u{FB8B}", FINAL FORM JEH
  [64399] = utf8.char(64399),  -- "ﮏ",  utf8.codepoint("ﮏ") == 64399,  "\u{FB8F}", FINAL FORM KEHEH
  [64403] = utf8.char(64403),  -- "ﮓ",  utf8.codepoint("ﮓ") == 64403,  "\u{FB93}", FINAL FORM GAF
  [64421] = utf8.char(64421),  -- "ﮥ",  utf8.codepoint("ﮥ") == 64421,  "\u{FBA5}", FINAL FORM HEH WITH YEH ABOVE
  [64509] = utf8.char(64509),  -- "ﯽ",  utf8.codepoint("ﯽ") == 64509,  "\u{FBFD}", FINAL FORM YEH
  [65166] = utf8.char(65166),  -- "ﺎ",  utf8.codepoint("ﺎ") == 65166,  "\u{FE8E}", FINAL FORM ALEF
  [65168] = utf8.char(65168),  -- "ﺐ",  utf8.codepoint("ﺐ") == 65168,  "\u{FE90}", FINAL FORM BEH
  [65172] = utf8.char(65172),  -- "ﺔ",  utf8.codepoint("ﺔ") == 65172,  "\u{FE94}", FINAL FORM TEH MARBUTAH
  [65174] = utf8.char(65174),  -- "ﺖ",  utf8.codepoint("ﺖ") == 65174,  "\u{FE96}", FINAL FORM TEH
  [65178] = utf8.char(65178),  -- "ﺚ",  utf8.codepoint("ﺚ") == 65178,  "\u{FE9A}", FINAL FORM THEH
  [65182] = utf8.char(65182),  -- "ﺞ",  utf8.codepoint("ﺞ") == 65182,  "\u{FE9E}", FINAL FORM JEEM
  [65186] = utf8.char(65186),  -- "ﺢ",  utf8.codepoint("ﺢ") == 65186,  "\u{FEA2}", FINAL FORM HAH
  [65190] = utf8.char(65190),  -- "ﺦ",  utf8.codepoint("ﺦ") == 65190,  "\u{FEA6}", FINAL FORM KHAH
  [65194] = utf8.char(65194),  -- "ﺪ",  utf8.codepoint("ﺪ") == 65194,  "\u{FEAA}", FINAL FORM DAL
  [65196] = utf8.char(65196),  -- "ﺬ",  utf8.codepoint("ﺬ") == 65196,  "\u{FEAC}", FINAL FORM THAL
  [65198] = utf8.char(65198),  -- "ﺮ",  utf8.codepoint("ﺮ") == 65198,  "\u{FEAE}", FINAL FORM REH
  [65200] = utf8.char(65200),  -- "ﺰ",  utf8.codepoint("ﺰ") == 65200,  "\u{FEB0}", FINAL FORM ZAIN
  [65202] = utf8.char(65202),  -- "ﺲ",  utf8.codepoint("ﺲ") == 65202,  "\u{FEB2}", FINAL FORM SEEN
  [65206] = utf8.char(65206),  -- "ﺶ",  utf8.codepoint("ﺶ") == 65206,  "\u{FEB6}", FINAL FORM SHEEN
  [65210] = utf8.char(65210),  -- "ﺺ",  utf8.codepoint("ﺺ") == 65210,  "\u{FEBA}", FINAL FORM SAD
  [65214] = utf8.char(65214),  -- "ﺾ",  utf8.codepoint("ﺾ") == 65214,  "\u{FEBE}", FINAL FORM DAD
  [65218] = utf8.char(65218),  -- "ﻂ",  utf8.codepoint("ﻂ") == 65218,  "\u{FEC2}", FINAL FORM TAH
  [65222] = utf8.char(65222),  -- "ﻆ",  utf8.codepoint("ﻆ") == 65222,  "\u{FEC6}", FINAL FORM ZAH
  [65226] = utf8.char(65226),  -- "ﻊ",  utf8.codepoint("ﻊ") == 65226,  "\u{FECA}", FINAL FORM AIN
  [65230] = utf8.char(65230),  -- "ﻎ",  utf8.codepoint("ﻎ") == 65230,  "\u{FECE}", FINAL FORM GHAIN
  [65234] = utf8.char(65234),  -- "ﻒ",  utf8.codepoint("ﻒ") == 65234,  "\u{FED2}", FINAL FORM FEH
  [65238] = utf8.char(65238),  -- "ﻖ",  utf8.codepoint("ﻖ") == 65238,  "\u{FED6}", FINAL FORM QAF
  [65242] = utf8.char(65242),  -- "ﻚ",  utf8.codepoint("ﻚ") == 65242,  "\u{FEDA}", FINAL FORM KAF
  [65246] = utf8.char(65246),  -- "ﻞ",  utf8.codepoint("ﻞ") == 65246,  "\u{FEDE}", FINAL FORM LAM
  [65250] = utf8.char(65250),  -- "ﻢ",  utf8.codepoint("ﻢ") == 65250,  "\u{FEE2}", FINAL FORM MEEM
  [65254] = utf8.char(65254),  -- "ﻦ",  utf8.codepoint("ﻦ") == 65254,  "\u{FEE6}", FINAL FORM NOON
  [65258] = utf8.char(65258),  -- "ﻪ",  utf8.codepoint("ﻪ") == 65258,  "\u{FEEA}", FINAL FORM HEH
  [65262] = utf8.char(65262),  -- "ﻮ",  utf8.codepoint("ﻮ") == 65262,  "\u{FEEE}", FINAL FORM WAW
  [65264] = utf8.char(65264),  -- "ﻰ",  utf8.codepoint("ﻰ") == 65264,  "\u{FEF0}", FINAL FORM ALEF MAKSURAH
  [65266] = utf8.char(65266),  -- "ﻲ",  utf8.codepoint("ﻲ") == 65266,  "\u{FEF2}", FINAL FORM YEH
  [65276] = utf8.char(65276),  -- "ﻼ",  utf8.codepoint("ﻼ") == 65276,  "\u{FEFC}", FINAL FORM LIGATURE LAM WITH ALEF
}

return peCharTableInitial, peCharTableMedial, peCharTableFinal
--
--
-- End of file `texnegar-char-table.lua'.
