/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WsHttpServletRequestWrapper;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.res.StringManager;

@Deprecated
public abstract class WebSocketServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final byte[] WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(B2CConverter.ISO_8859_1);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.websocket");
    private final Queue<MessageDigest> sha1Helpers = new ConcurrentLinkedQueue<MessageDigest>();

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = null;
        List list = Collections.emptyList();
        if (!this.headerContainsToken(httpServletRequest, "upgrade", "websocket")) {
            httpServletResponse.sendError(400);
            return;
        }
        if (!this.headerContainsToken(httpServletRequest, "connection", "upgrade")) {
            httpServletResponse.sendError(400);
            return;
        }
        if (!this.headerContainsToken(httpServletRequest, "sec-websocket-version", "13")) {
            httpServletResponse.setStatus(426);
            httpServletResponse.setHeader("Sec-WebSocket-Version", "13");
            return;
        }
        String string2 = httpServletRequest.getHeader("Sec-WebSocket-Key");
        if (string2 == null) {
            httpServletResponse.sendError(400);
            return;
        }
        String string3 = httpServletRequest.getHeader("Origin");
        if (!this.verifyOrigin(string3)) {
            httpServletResponse.sendError(403);
            return;
        }
        List<String> list2 = this.getTokensFromHeader(httpServletRequest, "Sec-WebSocket-Protocol");
        if (!list2.isEmpty()) {
            string = this.selectSubProtocol(list2);
        }
        httpServletResponse.setHeader("Upgrade", "websocket");
        httpServletResponse.setHeader("Connection", "upgrade");
        httpServletResponse.setHeader("Sec-WebSocket-Accept", this.getWebSocketAccept(string2));
        if (string != null) {
            httpServletResponse.setHeader("Sec-WebSocket-Protocol", string);
        }
        if (!list.isEmpty()) {
            // empty if block
        }
        WsHttpServletRequestWrapper wsHttpServletRequestWrapper = new WsHttpServletRequestWrapper(httpServletRequest);
        StreamInbound streamInbound = this.createWebSocketInbound(string, wsHttpServletRequestWrapper);
        wsHttpServletRequestWrapper.invalidate();
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        while (httpServletRequest2 instanceof ServletRequestWrapper) {
            httpServletRequest2 = ((ServletRequestWrapper)httpServletRequest2).getRequest();
        }
        if (httpServletRequest2 instanceof RequestFacade) {
            ((RequestFacade)httpServletRequest2).doUpgrade(streamInbound);
        } else {
            httpServletResponse.sendError(500, sm.getString("servlet.reqUpgradeFail"));
        }
    }

    private boolean headerContainsToken(HttpServletRequest httpServletRequest, String string, String string2) {
        Enumeration enumeration = httpServletRequest.getHeaders(string);
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string3 = (String)enumeration.nextElement();
            for (String string4 : stringArray = string3.split(",")) {
                if (!string2.equalsIgnoreCase(string4.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getTokensFromHeader(HttpServletRequest httpServletRequest, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = httpServletRequest.getHeaders(string);
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string2 = (String)enumeration.nextElement();
            for (String string3 : stringArray = string2.split(",")) {
                arrayList.add(string3.trim());
            }
        }
        return arrayList;
    }

    private String getWebSocketAccept(String string) throws ServletException {
        MessageDigest messageDigest = this.sha1Helpers.poll();
        if (messageDigest == null) {
            try {
                messageDigest = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ServletException((Throwable)noSuchAlgorithmException);
            }
        }
        messageDigest.reset();
        messageDigest.update(string.getBytes(B2CConverter.ISO_8859_1));
        String string2 = Base64.encodeBase64String((byte[])messageDigest.digest(WS_ACCEPT));
        this.sha1Helpers.add(messageDigest);
        return string2;
    }

    protected boolean verifyOrigin(String string) {
        return true;
    }

    protected String selectSubProtocol(List<String> list) {
        return null;
    }

    protected abstract StreamInbound createWebSocketInbound(String var1, HttpServletRequest var2);
}

