/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.Adapter;
import org.apache.coyote.AsyncStateMachine;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.Processor;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.servlet31.WebConnection;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProtocol<S>
implements ProtocolHandler,
MBeanRegistration {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote");
    private static final AtomicInteger nameCounter = new AtomicInteger(0);
    protected ObjectName rgOname = null;
    protected ObjectName tpOname = null;
    private int nameIndex = 0;
    protected AbstractEndpoint<S> endpoint = null;
    private int maxCookieCount = 200;
    protected Adapter adapter;
    protected int processorCache = 200;
    protected String clientCertProvider = null;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public boolean setProperty(String string, String string2) {
        return this.endpoint.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.endpoint.getProperty(string);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int n) {
        this.processorCache = n;
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String string) {
        this.clientCertProvider = string;
    }

    @Override
    public boolean isAprRequired() {
        return false;
    }

    public int getMaxCookieCount() {
        return this.maxCookieCount;
    }

    public void setMaxCookieCount(int n) {
        this.maxCookieCount = n;
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int n) {
        this.endpoint.setMaxThreads(n);
    }

    public int getMaxConnections() {
        return this.endpoint.getMaxConnections();
    }

    public void setMaxConnections(int n) {
        this.endpoint.setMaxConnections(n);
    }

    public int getMinSpareThreads() {
        return this.endpoint.getMinSpareThreads();
    }

    public void setMinSpareThreads(int n) {
        this.endpoint.setMinSpareThreads(n);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int n) {
        this.endpoint.setThreadPriority(n);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int n) {
        this.endpoint.setBacklog(n);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean bl) {
        this.endpoint.setTcpNoDelay(bl);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int n) {
        this.endpoint.setSoLinger(n);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int n) {
        this.endpoint.setKeepAliveTimeout(n);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress inetAddress) {
        this.endpoint.setAddress(inetAddress);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int n) {
        this.endpoint.setPort(n);
    }

    public int getLocalPort() {
        return this.endpoint.getLocalPort();
    }

    public int getConnectionTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setConnectionTimeout(int n) {
        this.endpoint.setSoTimeout(n);
    }

    public int getSoTimeout() {
        return this.getConnectionTimeout();
    }

    public void setSoTimeout(int n) {
        this.setConnectionTimeout(n);
    }

    public int getMaxHeaderCount() {
        return this.endpoint.getMaxHeaderCount();
    }

    public void setMaxHeaderCount(int n) {
        this.endpoint.setMaxHeaderCount(n);
    }

    public long getConnectionCount() {
        return this.endpoint.getConnectionCount();
    }

    public synchronized int getNameIndex() {
        if (this.nameIndex == 0) {
            this.nameIndex = nameCounter.incrementAndGet();
        }
        return this.nameIndex;
    }

    public String getName() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(this.getNamePrefix());
        stringBuilder.append('-');
        if (this.getAddress() != null) {
            stringBuilder.append(this.getAddress().getHostAddress());
            stringBuilder.append('-');
        }
        if ((n = this.getPort()) == 0) {
            stringBuilder.append("auto-");
            stringBuilder.append(this.getNameIndex());
            n = this.getLocalPort();
            if (n != -1) {
                stringBuilder.append('-');
                stringBuilder.append(n);
            }
        } else {
            stringBuilder.append(n);
        }
        return ObjectName.quote(stringBuilder.toString());
    }

    protected abstract Log getLog();

    protected abstract String getNamePrefix();

    protected abstract String getProtocolName();

    protected abstract AbstractEndpoint.Handler getHandler();

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.oname = objectName;
        this.mserver = mBeanServer;
        this.domain = objectName.getDomain();
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    private ObjectName createObjectName() throws MalformedObjectNameException {
        this.domain = this.adapter.getDomain();
        if (this.domain == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.getDomain());
        stringBuilder.append(":type=ProtocolHandler,port=");
        int n = this.getPort();
        if (n > 0) {
            stringBuilder.append(this.getPort());
        } else {
            stringBuilder.append("auto-");
            stringBuilder.append(this.getNameIndex());
        }
        InetAddress inetAddress = this.getAddress();
        if (inetAddress != null) {
            stringBuilder.append(",address=");
            stringBuilder.append(ObjectName.quote(inetAddress.getHostAddress()));
        }
        return new ObjectName(stringBuilder.toString());
    }

    @Override
    public void init() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.init", new Object[]{this.getName()}));
        }
        if (this.oname == null) {
            this.oname = this.createObjectName();
            if (this.oname != null) {
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
        }
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent(this.endpoint, this.tpOname, null);
            }
            catch (Exception exception) {
                this.getLog().error((Object)sm.getString("abstractProtocolHandler.mbeanRegistrationFailed", new Object[]{this.tpOname, this.getName()}), (Throwable)exception);
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent(this.getHandler().getGlobal(), this.rgOname, null);
        }
        String string = this.getName();
        this.endpoint.setName(string.substring(1, string.length() - 1));
        try {
            this.endpoint.init();
        }
        catch (Exception exception) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.initError", new Object[]{this.getName()}), (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public void start() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.start", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.start();
        }
        catch (Exception exception) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.startError", new Object[]{this.getName()}), (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public void pause() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.pause", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.pause();
        }
        catch (Exception exception) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.pauseError", new Object[]{this.getName()}), (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public void resume() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.resume", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.resume();
        }
        catch (Exception exception) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.resumeError", new Object[]{this.getName()}), (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.stop", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.stop();
        }
        catch (Exception exception) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.stopError", new Object[]{this.getName()}), (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public void destroy() {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.destroy", new Object[]{this.getName()}));
        }
        try {
            this.endpoint.destroy();
        }
        catch (Exception exception) {
            this.getLog().error((Object)sm.getString("abstractProtocolHandler.destroyError", new Object[]{this.getName()}), (Throwable)exception);
        }
        if (this.oname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    protected static class RecycledProcessors<P extends Processor<S>, S>
    extends ConcurrentLinkedQueue<Processor<S>> {
        private static final long serialVersionUID = 1L;
        private transient AbstractConnectionHandler<S, P> handler;
        protected AtomicInteger size = new AtomicInteger(0);

        public RecycledProcessors(AbstractConnectionHandler<S, P> abstractConnectionHandler) {
            this.handler = abstractConnectionHandler;
        }

        @Override
        public boolean offer(Processor<S> processor) {
            int n = this.handler.getProtocol().getProcessorCache();
            boolean bl = n == -1 ? true : this.size.get() < n;
            boolean bl2 = false;
            if (bl && (bl2 = super.offer(processor))) {
                this.size.incrementAndGet();
            }
            if (!bl2) {
                this.handler.unregister(processor);
            }
            return bl2;
        }

        @Override
        public Processor<S> poll() {
            Processor processor = (Processor)super.poll();
            if (processor != null) {
                this.size.decrementAndGet();
            }
            return processor;
        }

        @Override
        public void clear() {
            Object object = this.poll();
            while (object != null) {
                this.handler.unregister((Processor<S>)object);
                object = this.poll();
            }
            super.clear();
            this.size.set(0);
        }
    }

    protected static abstract class AbstractConnectionHandler<S, P extends Processor<S>>
    implements AbstractEndpoint.Handler {
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected final Map<S, Processor<S>> connections = new ConcurrentHashMap<S, Processor<S>>();
        protected RecycledProcessors<P, S> recycledProcessors = new RecycledProcessors(this);

        protected AbstractConnectionHandler() {
        }

        protected abstract Log getLog();

        protected abstract AbstractProtocol<S> getProtocol();

        @Override
        public Object getGlobal() {
            return this.global;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> socketWrapper, SocketStatus socketStatus) {
            if (socketWrapper == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            S s = socketWrapper.getSocket();
            if (s == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            Processor<S> processor = this.connections.get(s);
            if (socketStatus == SocketStatus.DISCONNECT && processor == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            socketWrapper.setAsync(false);
            ContainerThreadMarker.markAsContainerThread();
            try {
                if (processor == null) {
                    processor = this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                this.initSsl(socketWrapper, processor);
                AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                do {
                    Object object;
                    if (socketStatus != SocketStatus.DISCONNECT || processor.isComet()) {
                        if (processor.isAsync() || socketState == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                            socketState = processor.asyncDispatch(socketStatus);
                            if (socketState == AbstractEndpoint.Handler.SocketState.OPEN) {
                                this.getProtocol().endpoint.removeWaitingRequest(socketWrapper);
                                socketState = processor.process(socketWrapper);
                            }
                        } else {
                            socketState = processor.isComet() ? processor.event(socketStatus) : (processor.getUpgradeInbound() != null ? processor.upgradeDispatch() : (processor.isUpgrade() ? processor.upgradeDispatch(socketStatus) : processor.process(socketWrapper)));
                        }
                    }
                    if (processor.isAsync()) {
                        socketState = processor.asyncPostProcess();
                    }
                    if (socketState == AbstractEndpoint.Handler.SocketState.UPGRADING) {
                        object = processor.getHttpUpgradeHandler();
                        this.release(socketWrapper, processor, false, false);
                        processor = this.createUpgradeProcessor(socketWrapper, (HttpUpgradeHandler)object);
                        socketWrapper.setUpgraded(true);
                        this.connections.put(s, processor);
                        object.init((WebConnection)((Object)processor));
                    } else if (socketState == AbstractEndpoint.Handler.SocketState.UPGRADING_TOMCAT) {
                        object = processor.getUpgradeInbound();
                        this.release(socketWrapper, processor, false, false);
                        processor = this.createUpgradeProcessor(socketWrapper, (UpgradeInbound)object);
                        object.onUpgradeComplete();
                    }
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((Object)("Socket: [" + socketWrapper + "], Status in: [" + (Object)((Object)socketStatus) + "], State out: [" + (Object)((Object)socketState) + "]"));
                } while (socketState == AbstractEndpoint.Handler.SocketState.ASYNC_END || socketState == AbstractEndpoint.Handler.SocketState.UPGRADING || socketState == AbstractEndpoint.Handler.SocketState.UPGRADING_TOMCAT);
                if (socketState == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(s, processor);
                    this.longPoll(socketWrapper, processor);
                } else if (socketState == AbstractEndpoint.Handler.SocketState.OPEN) {
                    this.connections.remove(s);
                    this.release(socketWrapper, processor, false, true);
                } else if (socketState == AbstractEndpoint.Handler.SocketState.SENDFILE) {
                    this.connections.put(s, processor);
                } else if (socketState == AbstractEndpoint.Handler.SocketState.UPGRADED) {
                    this.connections.put(s, processor);
                    if (socketStatus != SocketStatus.OPEN_WRITE) {
                        this.longPoll(socketWrapper, processor);
                    }
                } else {
                    this.connections.remove(s);
                    if (processor.isUpgrade()) {
                        processor.getHttpUpgradeHandler().destroy();
                        processor.recycle(true);
                    } else if (!(processor instanceof UpgradeProcessor)) {
                        this.release(socketWrapper, processor, true, false);
                    }
                }
                return socketState;
            }
            catch (SocketException socketException) {
                this.getLog().debug((Object)sm.getString("abstractConnectionHandler.socketexception.debug"), (Throwable)socketException);
            }
            catch (IOException iOException) {
                this.getLog().debug((Object)sm.getString("abstractConnectionHandler.ioexception.debug"), (Throwable)iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.getLog().error((Object)sm.getString("abstractConnectionHandler.oome"), (Throwable)outOfMemoryError);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                this.getLog().error((Object)sm.getString("abstractConnectionHandler.error"), throwable);
            }
            this.connections.remove(s);
            if (!(processor instanceof UpgradeProcessor) && !processor.isUpgrade()) {
                this.release(socketWrapper, processor, true, false);
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        public boolean isAvailable(SocketWrapper<S> socketWrapper) {
            AsyncStateMachine<S> asyncStateMachine;
            Processor<S> processor;
            S s = socketWrapper.getSocket();
            if (s != null && (processor = this.connections.get(s)) != null && (asyncStateMachine = processor.getAsyncStateMachine()) != null) {
                return processor.getAsyncStateMachine().isAvailable();
            }
            return false;
        }

        protected abstract P createProcessor();

        protected abstract void initSsl(SocketWrapper<S> var1, Processor<S> var2);

        protected abstract void longPoll(SocketWrapper<S> var1, Processor<S> var2);

        protected abstract void release(SocketWrapper<S> var1, Processor<S> var2, boolean var3, boolean var4);

        @Deprecated
        protected abstract Processor<S> createUpgradeProcessor(SocketWrapper<S> var1, UpgradeInbound var2) throws IOException;

        protected abstract Processor<S> createUpgradeProcessor(SocketWrapper<S> var1, HttpUpgradeHandler var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(AbstractProcessor<S> abstractProcessor) {
            if (this.getProtocol().getDomain() != null) {
                AbstractConnectionHandler abstractConnectionHandler = this;
                synchronized (abstractConnectionHandler) {
                    try {
                        long l = this.registerCount.incrementAndGet();
                        RequestInfo requestInfo = abstractProcessor.getRequest().getRequestProcessor();
                        requestInfo.setGlobalProcessor(this.global);
                        ObjectName objectName = new ObjectName(this.getProtocol().getDomain() + ":type=RequestProcessor,worker=" + this.getProtocol().getName() + ",name=" + this.getProtocol().getProtocolName() + "Request" + l);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)("Register [" + abstractProcessor + "] as [" + objectName + "]"));
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)requestInfo, objectName, null);
                        requestInfo.setRpName(objectName);
                    }
                    catch (Exception exception) {
                        this.getLog().warn((Object)"Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Processor<S> processor) {
            if (this.getProtocol().getDomain() != null) {
                AbstractConnectionHandler abstractConnectionHandler = this;
                synchronized (abstractConnectionHandler) {
                    try {
                        Request request = processor.getRequest();
                        if (request == null) {
                            return;
                        }
                        RequestInfo requestInfo = request.getRequestProcessor();
                        requestInfo.setGlobalProcessor(null);
                        ObjectName objectName = requestInfo.getRpName();
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)("Unregister " + objectName));
                        }
                        Registry.getRegistry(null, null).unregisterComponent(objectName);
                        requestInfo.setRpName(null);
                    }
                    catch (Exception exception) {
                        this.getLog().warn((Object)"Error unregistering request", (Throwable)exception);
                    }
                }
            }
        }
    }
}

