/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.apache.tomcat.util.http.fileupload.InvalidFileNameException;

public final class Streams {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private Streams() {
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        return Streams.copy(inputStream, outputStream, bl, new byte[8192]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream inputStream, OutputStream outputStream, boolean bl, byte[] byArray) throws IOException {
        OutputStream outputStream2 = outputStream;
        InputStream inputStream2 = inputStream;
        try {
            int n;
            long l = 0L;
            while ((n = inputStream2.read(byArray)) != -1) {
                if (n <= 0) continue;
                l += (long)n;
                if (outputStream2 == null) continue;
                outputStream2.write(byArray, 0, n);
            }
            if (outputStream2 != null) {
                if (bl) {
                    outputStream2.close();
                } else {
                    outputStream2.flush();
                }
                outputStream2 = null;
            }
            inputStream2.close();
            inputStream2 = null;
            long l2 = l;
            return l2;
        }
        finally {
            IOUtils.closeQuietly(inputStream2);
            if (bl) {
                IOUtils.closeQuietly(outputStream2);
            }
        }
    }

    public static String asString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.copy(inputStream, byteArrayOutputStream, true);
        return byteArrayOutputStream.toString();
    }

    public static String asString(InputStream inputStream, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.copy(inputStream, byteArrayOutputStream, true);
        return byteArrayOutputStream.toString(string);
    }

    public static String checkFileName(String string) {
        if (string != null && string.indexOf(0) != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            block3: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\u0000': {
                        stringBuilder.append("\\0");
                        continue block3;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            throw new InvalidFileNameException(string, "Invalid file name: " + stringBuilder);
        }
        return string;
    }
}

