/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.util.ArrayList;
import java.util.List;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.http.mapper.WrapperMappingInfo;
import org.apache.tomcat.util.res.StringManager;

public class MapperListener
extends LifecycleMBeanBase
implements ContainerListener,
LifecycleListener {
    private static final Log log = LogFactory.getLog(MapperListener.class);
    private Mapper mapper = null;
    private Connector connector = null;
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.connector");
    private final String domain;

    public MapperListener(Mapper mapper, Connector connector) {
        this.domain = null;
        this.mapper = mapper;
        this.connector = connector;
    }

    @Deprecated
    public String getConnectorName() {
        return this.connector.toString();
    }

    @Override
    public void startInternal() throws LifecycleException {
        Container[] containerArray;
        this.setState(LifecycleState.STARTING);
        this.findDefaultHost();
        Engine engine = (Engine)this.connector.getService().getContainer();
        this.addListeners(engine);
        for (Container container : containerArray = engine.findChildren()) {
            Host host = (Host)container;
            if (LifecycleState.NEW.equals((Object)host.getState())) continue;
            this.registerHost(host);
        }
    }

    @Override
    public void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        Engine engine = (Engine)this.connector.getService().getContainer();
        this.removeListeners(engine);
    }

    @Override
    protected String getDomainInternal() {
        return this.connector.getDomainInternal();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return this.connector.createObjectNameKeyProperties("Mapper");
    }

    @Override
    public void containerEvent(ContainerEvent containerEvent) {
        if ("addChild".equals(containerEvent.getType())) {
            Container container = (Container)containerEvent.getData();
            this.addListeners(container);
            if (container.getState().isAvailable()) {
                if (container instanceof Host) {
                    this.registerHost((Host)container);
                } else if (container instanceof Context) {
                    this.registerContext((Context)container);
                } else if (container instanceof Wrapper && container.getParent().getState().isAvailable()) {
                    this.registerWrapper((Wrapper)container);
                }
            }
        } else if ("removeChild".equals(containerEvent.getType())) {
            Container container = (Container)containerEvent.getData();
            this.removeListeners(container);
        } else if ("addAlias".equals(containerEvent.getType())) {
            this.mapper.addHostAlias(((Host)containerEvent.getSource()).getName(), containerEvent.getData().toString());
        } else if ("removeAlias".equals(containerEvent.getType())) {
            this.mapper.removeHostAlias(containerEvent.getData().toString());
        } else if ("addMapping".equals(containerEvent.getType())) {
            Wrapper wrapper = (Wrapper)containerEvent.getSource();
            Context context = (Context)wrapper.getParent();
            String string = context.getPath();
            if ("/".equals(string)) {
                string = "";
            }
            String string2 = context.getWebappVersion();
            String string3 = context.getParent().getName();
            String string4 = wrapper.getName();
            String string5 = (String)containerEvent.getData();
            boolean bl = "jsp".equals(string4) && string5.endsWith("/*");
            this.mapper.addWrapper(string3, string, string2, string5, (Object)wrapper, bl, context.isResourceOnlyServlet(string4));
        } else if ("removeMapping".equals(containerEvent.getType())) {
            Wrapper wrapper = (Wrapper)containerEvent.getSource();
            Context context = (Context)wrapper.getParent();
            String string = context.getPath();
            if ("/".equals(string)) {
                string = "";
            }
            String string6 = context.getWebappVersion();
            String string7 = context.getParent().getName();
            String string8 = (String)containerEvent.getData();
            this.mapper.removeWrapper(string7, string, string6, string8);
        } else if ("addWelcomeFile".equals(containerEvent.getType())) {
            Context context = (Context)containerEvent.getSource();
            String string = context.getParent().getName();
            String string9 = context.getPath();
            if ("/".equals(string9)) {
                string9 = "";
            }
            String string10 = (String)containerEvent.getData();
            this.mapper.addWelcomeFile(string, string9, context.getWebappVersion(), string10);
        } else if ("removeWelcomeFile".equals(containerEvent.getType())) {
            Context context = (Context)containerEvent.getSource();
            String string = context.getParent().getName();
            String string11 = context.getPath();
            if ("/".equals(string11)) {
                string11 = "";
            }
            String string12 = (String)containerEvent.getData();
            this.mapper.removeWelcomeFile(string, string11, context.getWebappVersion(), string12);
        } else if ("clearWelcomeFiles".equals(containerEvent.getType())) {
            Context context = (Context)containerEvent.getSource();
            String string = context.getParent().getName();
            String string13 = context.getPath();
            if ("/".equals(string13)) {
                string13 = "";
            }
            this.mapper.clearWelcomeFiles(string, string13, context.getWebappVersion());
        }
    }

    private void findDefaultHost() {
        Engine engine = (Engine)this.connector.getService().getContainer();
        String string = engine.getDefaultHost();
        boolean bl = false;
        if (string != null && string.length() > 0) {
            Container[] containerArray;
            block0: for (Container container : containerArray = engine.findChildren()) {
                String[] stringArray;
                Host host = (Host)container;
                if (string.equalsIgnoreCase(host.getName())) {
                    bl = true;
                    break;
                }
                for (String string2 : stringArray = host.findAliases()) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        if (bl) {
            this.mapper.setDefaultHostName(string);
        } else {
            log.warn((Object)sm.getString("mapperListener.unknownDefaultHost", new Object[]{string, this.connector}));
        }
    }

    private void registerHost(Host host) {
        String[] stringArray = host.findAliases();
        this.mapper.addHost(host.getName(), stringArray, (Object)host);
        for (Container container : host.findChildren()) {
            if (!container.getState().isAvailable()) continue;
            this.registerContext((Context)container);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.registerHost", new Object[]{host.getName(), this.domain, this.connector}));
        }
    }

    private void unregisterHost(Host host) {
        String string = host.getName();
        this.mapper.removeHost(string);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.unregisterHost", new Object[]{string, this.domain, this.connector}));
        }
    }

    private void unregisterWrapper(Wrapper wrapper) {
        String[] stringArray;
        Context context = (Context)wrapper.getParent();
        String string = context.getPath();
        String string2 = wrapper.getName();
        if ("/".equals(string)) {
            string = "";
        }
        String string3 = context.getWebappVersion();
        String string4 = context.getParent().getName();
        for (String string5 : stringArray = wrapper.findMappings()) {
            this.mapper.removeWrapper(string4, string, string3, string5);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.unregisterWrapper", new Object[]{string2, string, this.connector}));
        }
    }

    private void registerContext(Context context) {
        String string = context.getPath();
        if ("/".equals(string)) {
            string = "";
        }
        Container container = context.getParent();
        DirContext dirContext = context.getResources();
        String[] stringArray = context.findWelcomeFiles();
        ArrayList<WrapperMappingInfo> arrayList = new ArrayList<WrapperMappingInfo>();
        for (Container container2 : context.findChildren()) {
            this.prepareWrapperMappingInfo(context, (Wrapper)container2, arrayList);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("mapperListener.registerWrapper", new Object[]{container2.getName(), string, this.connector}));
        }
        this.mapper.addContextVersion(container.getName(), (Object)container, string, context.getWebappVersion(), (Object)context, stringArray, (javax.naming.Context)dirContext, arrayList, context.getMapperContextRootRedirectEnabled(), context.getMapperDirectoryRedirectEnabled());
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.registerContext", new Object[]{string, this.connector}));
        }
    }

    private void unregisterContext(Context context) {
        String string = context.getPath();
        if ("/".equals(string)) {
            string = "";
        }
        String string2 = context.getParent().getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.unregisterContext", new Object[]{string, this.connector}));
        }
        if (context.getPaused()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapperListener.pauseContext", new Object[]{string, this.connector}));
            }
            this.mapper.pauseContextVersion((Object)context, string2, string, context.getWebappVersion());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapperListener.unregisterContext", new Object[]{string, this.connector}));
            }
            this.mapper.removeContextVersion(string2, string, context.getWebappVersion());
        }
    }

    private void registerWrapper(Wrapper wrapper) {
        Context context = (Context)wrapper.getParent();
        String string = context.getPath();
        if ("/".equals(string)) {
            string = "";
        }
        String string2 = context.getWebappVersion();
        String string3 = context.getParent().getName();
        ArrayList<WrapperMappingInfo> arrayList = new ArrayList<WrapperMappingInfo>();
        this.prepareWrapperMappingInfo(context, wrapper, arrayList);
        this.mapper.addWrappers(string3, string, string2, arrayList);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.registerWrapper", new Object[]{wrapper.getName(), string, this.connector}));
        }
    }

    private void prepareWrapperMappingInfo(Context context, Wrapper wrapper, List<WrapperMappingInfo> list) {
        String[] stringArray;
        String string = wrapper.getName();
        boolean bl = context.isResourceOnlyServlet(string);
        for (String string2 : stringArray = wrapper.findMappings()) {
            boolean bl2 = string.equals("jsp") && string2.endsWith("/*");
            list.add(new WrapperMappingInfo(string2, (Object)wrapper, bl2, bl));
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if (lifecycleEvent.getType().equals("after_start")) {
            Object object = lifecycleEvent.getSource();
            if (object instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)object;
                if (wrapper.getParent().getState().isAvailable()) {
                    this.registerWrapper(wrapper);
                }
            } else if (object instanceof Context) {
                Context context = (Context)object;
                if (context.getParent().getState().isAvailable()) {
                    this.registerContext(context);
                }
            } else if (object instanceof Host) {
                this.registerHost((Host)object);
            }
        } else if (lifecycleEvent.getType().equals("before_stop")) {
            Object object = lifecycleEvent.getSource();
            if (object instanceof Wrapper) {
                this.unregisterWrapper((Wrapper)object);
            } else if (object instanceof Context) {
                this.unregisterContext((Context)object);
            } else if (object instanceof Host) {
                this.unregisterHost((Host)object);
            }
        }
    }

    private void addListeners(Container container) {
        container.addContainerListener(this);
        container.addLifecycleListener(this);
        for (Container container2 : container.findChildren()) {
            this.addListeners(container2);
        }
    }

    private void removeListeners(Container container) {
        container.removeContainerListener(this);
        container.removeLifecycleListener(this);
        for (Container container2 : container.findChildren()) {
            this.removeListeners(container2);
        }
    }
}

