/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsFrameBase;
import org.apache.tomcat.websocket.WsSession;

public class WsFrameServer
extends WsFrameBase {
    private final Log log = LogFactory.getLog(WsFrameServer.class);
    private static final StringManager sm = StringManager.getManager(WsFrameServer.class);
    private final AbstractServletInputStream sis;
    private final Object connectionReadLock = new Object();

    public WsFrameServer(AbstractServletInputStream abstractServletInputStream, WsSession wsSession, Transformation transformation) {
        super(wsSession, transformation);
        this.sis = abstractServletInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataAvailable() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"wsFrameServer.onDataAvailable");
        }
        Object object = this.connectionReadLock;
        synchronized (object) {
            while (this.isOpen() && this.sis.isReady()) {
                int n = this.sis.read(this.inputBuffer, this.writePos, this.inputBuffer.length - this.writePos);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("wsFrameServer.bytesRead", new Object[]{Integer.toString(n)}));
                }
                if (n == 0) {
                    return;
                }
                if (n == -1) {
                    throw new EOFException();
                }
                this.writePos += n;
                this.processInputBuffer();
            }
        }
    }

    @Override
    protected boolean isMasked() {
        return true;
    }

    @Override
    protected Transformation getTransformation() {
        return super.getTransformation();
    }

    @Override
    protected Log getLog() {
        return this.log;
    }
}

