/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.AnnotationElementValue;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.ArrayElementValue;
import org.apache.tomcat.util.bcel.classfile.ClassElementValue;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.EnumElementValue;
import org.apache.tomcat.util.bcel.classfile.SimpleElementValue;

public abstract class ElementValue {
    private final int type;
    private final ConstantPool cpool;
    public static final byte STRING = 115;
    public static final byte ENUM_CONSTANT = 101;
    public static final byte CLASS = 99;
    public static final byte ANNOTATION = 64;
    public static final byte ARRAY = 91;
    public static final byte PRIMITIVE_INT = 73;
    public static final byte PRIMITIVE_BYTE = 66;
    public static final byte PRIMITIVE_CHAR = 67;
    public static final byte PRIMITIVE_DOUBLE = 68;
    public static final byte PRIMITIVE_FLOAT = 70;
    public static final byte PRIMITIVE_LONG = 74;
    public static final byte PRIMITIVE_SHORT = 83;
    public static final byte PRIMITIVE_BOOLEAN = 90;

    ElementValue(int n, ConstantPool constantPool) {
        this.type = n;
        this.cpool = constantPool;
    }

    public abstract String stringifyValue();

    public static ElementValue readElementValue(DataInput dataInput, ConstantPool constantPool) throws IOException {
        byte by = dataInput.readByte();
        switch (by) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new SimpleElementValue(by, dataInput.readUnsignedShort(), constantPool);
            }
            case 101: {
                dataInput.readUnsignedShort();
                return new EnumElementValue(101, dataInput.readUnsignedShort(), constantPool);
            }
            case 99: {
                return new ClassElementValue(99, dataInput.readUnsignedShort(), constantPool);
            }
            case 64: {
                return new AnnotationElementValue(64, new AnnotationEntry(dataInput, constantPool), constantPool);
            }
            case 91: {
                int n = dataInput.readUnsignedShort();
                ElementValue[] elementValueArray = new ElementValue[n];
                for (int i = 0; i < n; ++i) {
                    elementValueArray[i] = ElementValue.readElementValue(dataInput, constantPool);
                }
                return new ArrayElementValue(91, elementValueArray, constantPool);
            }
        }
        throw new IllegalArgumentException("Unexpected element value kind in annotation: " + by);
    }

    final ConstantPool getConstantPool() {
        return this.cpool;
    }

    final int getType() {
        return this.type;
    }
}

