/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.StringManager;

public class OrderInterceptor
extends ChannelInterceptorBase {
    protected static final StringManager sm = StringManager.getManager(OrderInterceptor.class);
    private final HashMap<Member, Counter> outcounter = new HashMap();
    private final HashMap<Member, Counter> incounter = new HashMap();
    private final HashMap<Member, MessageOrder> incoming = new HashMap();
    private long expire = 3000L;
    private boolean forwardExpired = true;
    private int maxQueue = Integer.MAX_VALUE;
    final ReentrantReadWriteLock inLock = new ReentrantReadWriteLock(true);
    final ReentrantReadWriteLock outLock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        if (!this.okToProcess(channelMessage.getOptions())) {
            super.sendMessage(memberArray, channelMessage, interceptorPayload);
            return;
        }
        ChannelException channelException = null;
        for (Member member : memberArray) {
            try {
                int n = 0;
                this.outLock.writeLock().lock();
                try {
                    n = this.incCounter(member);
                }
                finally {
                    this.outLock.writeLock().unlock();
                }
                channelMessage.getMessage().append(n);
                try {
                    this.getNext().sendMessage(new Member[]{member}, channelMessage, interceptorPayload);
                }
                finally {
                    channelMessage.getMessage().trim(4);
                }
            }
            catch (ChannelException channelException2) {
                if (channelException == null) {
                    channelException = channelException2;
                }
                channelException.addFaultyMember(channelException2.getFaultyMembers());
            }
        }
        if (channelException != null) {
            throw channelException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (!this.okToProcess(channelMessage.getOptions())) {
            super.messageReceived(channelMessage);
            return;
        }
        int n = XByteBuffer.toInt(channelMessage.getMessage().getBytesDirect(), channelMessage.getMessage().getLength() - 4);
        channelMessage.getMessage().trim(4);
        MessageOrder messageOrder = new MessageOrder(n, (ChannelMessage)channelMessage.deepclone());
        this.inLock.writeLock().lock();
        try {
            if (this.processIncoming(messageOrder)) {
                this.processLeftOvers(channelMessage.getAddress(), false);
            }
        }
        finally {
            this.inLock.writeLock().unlock();
        }
    }

    protected void processLeftOvers(Member member, boolean bl) {
        MessageOrder messageOrder = this.incoming.get(member);
        if (bl) {
            Counter counter = this.getInCounter(member);
            counter.setCounter(Integer.MAX_VALUE);
        }
        if (messageOrder != null) {
            this.processIncoming(messageOrder);
        }
    }

    protected boolean processIncoming(MessageOrder messageOrder) {
        boolean bl;
        boolean bl2 = false;
        Member member = messageOrder.getMessage().getAddress();
        Counter counter = this.getInCounter(member);
        MessageOrder messageOrder2 = this.incoming.get(member);
        if (messageOrder2 != null) {
            messageOrder = MessageOrder.add(messageOrder2, messageOrder);
        }
        while (messageOrder != null && messageOrder.getMsgNr() <= counter.getCounter()) {
            if (messageOrder.getMsgNr() == counter.getCounter()) {
                counter.inc();
            } else if (messageOrder.getMsgNr() > counter.getCounter()) {
                counter.setCounter(messageOrder.getMsgNr());
            }
            super.messageReceived(messageOrder.getMessage());
            messageOrder.setMessage(null);
            messageOrder = messageOrder.next;
        }
        MessageOrder messageOrder3 = messageOrder;
        MessageOrder messageOrder4 = null;
        messageOrder2 = messageOrder;
        boolean bl3 = messageOrder != null ? messageOrder.getCount() >= this.maxQueue : (bl = false);
        while (messageOrder2 != null) {
            if (messageOrder2.isExpired(this.expire) || bl) {
                if (messageOrder2 == messageOrder3) {
                    messageOrder3 = messageOrder2.next;
                }
                counter.setCounter(messageOrder2.getMsgNr() + 1);
                if (this.getForwardExpired()) {
                    super.messageReceived(messageOrder2.getMessage());
                }
                messageOrder2.setMessage(null);
                messageOrder2 = messageOrder2.next;
                if (messageOrder4 != null) {
                    messageOrder4.next = messageOrder2;
                }
                bl2 = true;
                continue;
            }
            messageOrder4 = messageOrder2;
            messageOrder2 = messageOrder2.next;
        }
        if (messageOrder3 == null) {
            this.incoming.remove(member);
        } else {
            this.incoming.put(member, messageOrder3);
        }
        return bl2;
    }

    @Override
    public void memberAdded(Member member) {
        super.memberAdded(member);
    }

    @Override
    public void memberDisappeared(Member member) {
        this.incounter.remove(member);
        this.outcounter.remove(member);
        this.processLeftOvers(member, true);
        super.memberDisappeared(member);
    }

    protected int incCounter(Member member) {
        Counter counter = this.getOutCounter(member);
        return counter.inc();
    }

    protected Counter getInCounter(Member member) {
        Counter counter = this.incounter.get(member);
        if (counter == null) {
            counter = new Counter();
            counter.inc();
            this.incounter.put(member, counter);
        }
        return counter;
    }

    protected Counter getOutCounter(Member member) {
        Counter counter = this.outcounter.get(member);
        if (counter == null) {
            counter = new Counter();
            this.outcounter.put(member, counter);
        }
        return counter;
    }

    public void setExpire(long l) {
        this.expire = l;
    }

    public void setForwardExpired(boolean bl) {
        this.forwardExpired = bl;
    }

    public void setMaxQueue(int n) {
        this.maxQueue = n;
    }

    public long getExpire() {
        return this.expire;
    }

    public boolean getForwardExpired() {
        return this.forwardExpired;
    }

    public int getMaxQueue() {
        return this.maxQueue;
    }

    protected static class MessageOrder {
        private final long received = System.currentTimeMillis();
        private MessageOrder next;
        private final int msgNr;
        private ChannelMessage msg = null;

        public MessageOrder(int n, ChannelMessage channelMessage) {
            this.msgNr = n;
            this.msg = channelMessage;
        }

        public boolean isExpired(long l) {
            return System.currentTimeMillis() - this.received > l;
        }

        public ChannelMessage getMessage() {
            return this.msg;
        }

        public void setMessage(ChannelMessage channelMessage) {
            this.msg = channelMessage;
        }

        public void setNext(MessageOrder messageOrder) {
            this.next = messageOrder;
        }

        public MessageOrder getNext() {
            return this.next;
        }

        public int getCount() {
            int n = 1;
            MessageOrder messageOrder = this.next;
            while (messageOrder != null) {
                ++n;
                messageOrder = messageOrder.next;
            }
            return n;
        }

        public static MessageOrder add(MessageOrder messageOrder, MessageOrder messageOrder2) {
            if (messageOrder == null) {
                return messageOrder2;
            }
            if (messageOrder2 == null) {
                return messageOrder;
            }
            if (messageOrder == messageOrder2) {
                return messageOrder2;
            }
            if (messageOrder.getMsgNr() > messageOrder2.getMsgNr()) {
                messageOrder2.next = messageOrder;
                return messageOrder2;
            }
            MessageOrder messageOrder3 = messageOrder;
            MessageOrder messageOrder4 = null;
            while (messageOrder3.getMsgNr() < messageOrder2.getMsgNr() && messageOrder3.next != null) {
                messageOrder4 = messageOrder3;
                messageOrder3 = messageOrder3.next;
            }
            if (messageOrder3.getMsgNr() < messageOrder2.getMsgNr()) {
                messageOrder2.next = messageOrder3.next;
                messageOrder3.next = messageOrder2;
            } else if (messageOrder3.getMsgNr() > messageOrder2.getMsgNr()) {
                messageOrder4.next = messageOrder2;
                messageOrder2.next = messageOrder3;
            } else {
                throw new ArithmeticException(sm.getString("orderInterceptor.messageAdded.sameCounter"));
            }
            return messageOrder;
        }

        public int getMsgNr() {
            return this.msgNr;
        }
    }

    protected static class Counter {
        private final AtomicInteger value = new AtomicInteger(0);

        protected Counter() {
        }

        public int getCounter() {
            return this.value.get();
        }

        public void setCounter(int n) {
            this.value.set(n);
        }

        public int inc() {
            return this.value.addAndGet(1);
        }
    }
}

