/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.ApplicationBufferHandler;

public class BufferedInputFilter
implements InputFilter,
ApplicationBufferHandler {
    private static final String ENCODING_NAME = "buffered";
    private static final ByteChunk ENCODING = new ByteChunk();
    private ByteBuffer buffered;
    private ByteBuffer tempRead;
    private InputBuffer buffer;
    private boolean hasRead = false;

    public void setLimit(int n) {
        if (this.buffered == null) {
            this.buffered = ByteBuffer.allocate(n);
            this.buffered.flip();
        }
    }

    @Override
    public void setRequest(Request request) {
        try {
            while (this.buffer.doRead(this) >= 0) {
                this.buffered.mark().position(this.buffered.limit()).limit(this.buffered.capacity());
                this.buffered.put(this.tempRead);
                this.buffered.limit(this.buffered.position()).reset();
                this.tempRead = null;
            }
        }
        catch (IOException | BufferOverflowException exception) {
            throw new IllegalStateException("Request body too large for buffer");
        }
    }

    @Override
    public int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
        if (this.isFinished()) {
            return -1;
        }
        applicationBufferHandler.setByteBuffer(this.buffered);
        this.hasRead = true;
        return this.buffered.remaining();
    }

    @Override
    public void setBuffer(InputBuffer inputBuffer) {
        this.buffer = inputBuffer;
    }

    @Override
    public void recycle() {
        if (this.buffered != null) {
            if (this.buffered.capacity() > 65536) {
                this.buffered = null;
            } else {
                this.buffered.position(0).limit(0);
            }
        }
        this.hasRead = false;
        this.buffer = null;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    @Override
    public long end() throws IOException {
        return 0L;
    }

    @Override
    public int available() {
        int n = this.buffered.remaining();
        if (n == 0) {
            return this.buffer.available();
        }
        return n;
    }

    @Override
    public boolean isFinished() {
        return this.hasRead || this.buffered.remaining() <= 0;
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.tempRead = byteBuffer;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.tempRead;
    }

    @Override
    public void expand(int n) {
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(StandardCharsets.ISO_8859_1), 0, ENCODING_NAME.length());
    }
}

