/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.util.LifecycleBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public abstract class LifecycleMBeanBase
extends LifecycleBase
implements JmxEnabled {
    private static final Log log = LogFactory.getLog(LifecycleMBeanBase.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.util");
    private String domain = null;
    private ObjectName oname = null;
    @Deprecated
    protected MBeanServer mserver = null;

    @Override
    protected void initInternal() throws LifecycleException {
        if (this.oname == null) {
            this.mserver = Registry.getRegistry(null, null).getMBeanServer();
            this.oname = this.register(this, this.getObjectNameKeyProperties());
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.unregister(this.oname);
    }

    @Override
    public final void setDomain(String string) {
        this.domain = string;
    }

    @Override
    public final String getDomain() {
        if (this.domain == null) {
            this.domain = this.getDomainInternal();
        }
        if (this.domain == null) {
            this.domain = "Catalina";
        }
        return this.domain;
    }

    protected abstract String getDomainInternal();

    @Override
    public final ObjectName getObjectName() {
        return this.oname;
    }

    protected abstract String getObjectNameKeyProperties();

    protected final ObjectName register(Object object, String string) {
        StringBuilder stringBuilder = new StringBuilder(this.getDomain());
        stringBuilder.append(':');
        stringBuilder.append(string);
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(stringBuilder.toString());
            Registry.getRegistry(null, null).registerComponent(object, objectName, null);
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("lifecycleMBeanBase.registerFail", new Object[]{object, stringBuilder}), (Throwable)exception);
        }
        return objectName;
    }

    protected final void unregister(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.getDomain());
        stringBuilder.append(':');
        stringBuilder.append(string);
        Registry.getRegistry(null, null).unregisterComponent(stringBuilder.toString());
    }

    protected final void unregister(ObjectName objectName) {
        Registry.getRegistry(null, null).unregisterComponent(objectName);
    }

    @Override
    public final void postDeregister() {
    }

    @Override
    public final void postRegister(Boolean bl) {
    }

    @Override
    public final void preDeregister() throws Exception {
    }

    @Override
    public final ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mserver = mBeanServer;
        this.oname = objectName;
        this.domain = objectName.getDomain().intern();
        return this.oname;
    }
}

