/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;

public class ObjectHistogram
extends Tool {
    @Override
    public void run() {
        this.run(System.out, System.err);
    }

    public void run(PrintStream out, PrintStream err) {
        ObjectHeap heap = VM.getVM().getObjectHeap();
        sun.jvm.hotspot.oops.ObjectHistogram histogram = new sun.jvm.hotspot.oops.ObjectHistogram();
        err.println("Iterating over heap. This may take a while...");
        long startTime = System.currentTimeMillis();
        heap.iterate(histogram);
        long endTime = System.currentTimeMillis();
        histogram.printOn(out);
        float secs = (float)(endTime - startTime) / 1000.0f;
        err.println("Heap traversal took " + secs + " seconds.");
    }

    public static void main(String[] args) {
        ObjectHistogram oh = new ObjectHistogram();
        oh.start(args);
        oh.stop();
    }
}

