// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: DebugOptions.java
package org.graalvm.compiler.debug;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class DebugOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AggregatedMetricsFile": {
            return OptionDescriptor.create(
                /*name*/ "AggregatedMetricsFile",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "File to which aggregated metrics are dumped at shutdown. A CSV format is used if the file ends with .csv otherwise a more human readable format is used. If not specified, metrics are dumped to the console.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "AggregatedMetricsFile",
                /*option*/ DebugOptions.AggregatedMetricsFile);
        }
        case "BootstrapInitializeOnly": {
            return OptionDescriptor.create(
                /*name*/ "BootstrapInitializeOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Do not compile anything on bootstrap but just initialize the compiler.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "BootstrapInitializeOnly",
                /*option*/ DebugOptions.BootstrapInitializeOnly);
        }
        case "CanonicalGraphStringsCheckConstants": {
            return OptionDescriptor.create(
                /*name*/ "CanonicalGraphStringsCheckConstants",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exclude virtual nodes when dumping canonical text for graphs.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "CanonicalGraphStringsCheckConstants",
                /*option*/ DebugOptions.CanonicalGraphStringsCheckConstants);
        }
        case "CanonicalGraphStringsExcludeVirtuals": {
            return OptionDescriptor.create(
                /*name*/ "CanonicalGraphStringsExcludeVirtuals",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exclude virtual nodes when dumping canonical text for graphs.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "CanonicalGraphStringsExcludeVirtuals",
                /*option*/ DebugOptions.CanonicalGraphStringsExcludeVirtuals);
        }
        case "CanonicalGraphStringsRemoveIdentities": {
            return OptionDescriptor.create(
                /*name*/ "CanonicalGraphStringsRemoveIdentities",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Attempts to remove object identity hashes when dumping canonical text for graphs.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "CanonicalGraphStringsRemoveIdentities",
                /*option*/ DebugOptions.CanonicalGraphStringsRemoveIdentities);
        }
        case "ClearMetricsAfterBootstrap": {
            return OptionDescriptor.create(
                /*name*/ "ClearMetricsAfterBootstrap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Clear the debug metrics after bootstrap.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "ClearMetricsAfterBootstrap",
                /*option*/ DebugOptions.ClearMetricsAfterBootstrap);
        }
        case "Count": {
            return OptionDescriptor.create(
                /*name*/ "Count",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which counters are enabled. See the Dump option for the pattern syntax. An empty value enables all counters unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Count",
                /*option*/ DebugOptions.Count);
        }
        case "Counters": {
            return OptionDescriptor.create(
                /*name*/ "Counters",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma separated names of counters that are enabled irrespective of the value for Count option. An empty value enables all counters unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Counters",
                /*option*/ DebugOptions.Counters);
        }
        case "DebugStubsAndSnippets": {
            return OptionDescriptor.create(
                /*name*/ "DebugStubsAndSnippets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable debug output for stub code generation and snippet preparation.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DebugStubsAndSnippets",
                /*option*/ DebugOptions.DebugStubsAndSnippets);
        }
        case "DiagnoseDumpLevel": {
            return OptionDescriptor.create(
                /*name*/ "DiagnoseDumpLevel",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specify the DumpLevel if CompilationFailureAction#Diagnose is used.See CompilationFailureAction for details. file:doc-files/CompilationFailureActionHelp.txt",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DiagnoseDumpLevel",
                /*option*/ DebugOptions.DiagnoseDumpLevel);
        }
        case "DisableIntercept": {
            return OptionDescriptor.create(
                /*name*/ "DisableIntercept",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Disable intercepting exceptions in debug scopes.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DisableIntercept",
                /*option*/ DebugOptions.DisableIntercept);
        }
        case "Dump": {
            return OptionDescriptor.create(
                /*name*/ "Dump",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Filter pattern for specifying scopes in which dumping is enabled.",
                /*extraHelp*/ new String[] {
                         "",
                         "A filter is a list of comma-separated terms of the form:",
                         " ",
                         "  <pattern>[:<level>]",
                         " ",
                         "If <pattern> contains a \"*\" or \"?\" character, it is interpreted as a glob pattern.",
                         "Otherwise, it is interpreted as a substring. If <pattern> is empty, it",
                         "matches every scope. If :<level> is omitted, it defaults to 1. The term",
                         "~<pattern> is a shorthand for <pattern>:0 to disable a debug facility for a pattern.",
                         "",
                         "The default log level is 0 (disabled). Terms with an empty pattern set",
                         "the default log level to the specified value. The last",
                         "matching term with a non-empty pattern selects the level specified. If",
                         "no term matches, the log level is the default level. A filter with no",
                         "terms matches every scope with a log level of 1.",
                         "",
                         "Examples of debug filters:",
                         "--------- ",
                         "  (empty string)",
                         "",
                         "  Matches any scope with level 1.",
                         "--------- ",
                         "  :1",
                         "",
                         "  Matches any scope with level 1.",
                         "--------- ",
                         "  *",
                         "",
                         "  Matches any scope with level 1.",
                         "--------- ",
                         "  CodeGen,CodeInstall",
                         "",
                         "  Matches scopes containing \"CodeGen\" or \"CodeInstall\", both with level 1.",
                         "--------- ",
                         "  CodeGen:2,CodeInstall:1",
                         "",
                         "  Matches scopes containing \"CodeGen\" with level 2, or \"CodeInstall\" with level 1.",
                         "---------",
                         "  Outer:2,Inner:0}",
                         "",
                         "  Matches scopes containing \"Outer\" with log level 2, or \"Inner\" with log level 0. If the scope",
                         "  name contains both patterns then the log level will be 0. This is useful for silencing subscopes.",
                         "---------",
                         "  :1,Dead:2",
                         "",
                         "  Matches scopes containing \"Dead\" with level 2, and all other scopes with level 1.",
                         "--------- ",
                         "  Dead:0,:1",
                         "",
                         "  Matches all scopes with level 1, except those containing \"Dead\".   Note that the location of",
                         "  the :1 doesn't matter since it's specifying the default log level so it's the same as",
                         "  specifying :1,Dead:0.",
                         "--------- ",
                         "  Code*",
                         "",
                         "  Matches scopes starting with \"Code\" with level 1.",
                         "--------- ",
                         "  Code,~Dead",
                         "",
                         "  Matches scopes containing \"Code\" but not \"Dead\", with level 1.",
                              },
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Dump",
                /*option*/ DebugOptions.Dump);
        }
        case "DumpOnError": {
            return OptionDescriptor.create(
                /*name*/ "DumpOnError",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Send compiler IR to dump handlers on error.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DumpOnError",
                /*option*/ DebugOptions.DumpOnError);
        }
        case "DumpOnPhaseChange": {
            return OptionDescriptor.create(
                /*name*/ "DumpOnPhaseChange",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Dump a before and after graph if the named phase changes the graph.%nThe argument is substring matched against the simple name of the phase class",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DumpOnPhaseChange",
                /*option*/ DebugOptions.DumpOnPhaseChange);
        }
        case "DumpPath": {
            return OptionDescriptor.create(
                /*name*/ "DumpPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "The directory where various Graal dump files are written.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DumpPath",
                /*option*/ DebugOptions.DumpPath);
        }
        case "DumpingErrorsAreFatal": {
            return OptionDescriptor.create(
                /*name*/ "DumpingErrorsAreFatal",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Treat any exceptions during dumping as fatal.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DumpingErrorsAreFatal",
                /*option*/ DebugOptions.DumpingErrorsAreFatal);
        }
        case "InterceptBailout": {
            return OptionDescriptor.create(
                /*name*/ "InterceptBailout",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Intercept also bailout exceptions",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "InterceptBailout",
                /*option*/ DebugOptions.InterceptBailout);
        }
        case "ListMetrics": {
            return OptionDescriptor.create(
                /*name*/ "ListMetrics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Lists on the console at VM shutdown the metric names available to the Timers, Counters and MemUseTrackers options. Note that this only lists the metrics that were initialized during the VM execution and so will not include metrics for compiler code that is not executed.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "ListMetrics",
                /*option*/ DebugOptions.ListMetrics);
        }
        case "Log": {
            return OptionDescriptor.create(
                /*name*/ "Log",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which logging is enabled. See the Dump option for the pattern syntax.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Log",
                /*option*/ DebugOptions.Log);
        }
        case "LogVerbose": {
            return OptionDescriptor.create(
                /*name*/ "LogVerbose",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable more verbose log output when available",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "LogVerbose",
                /*option*/ DebugOptions.LogVerbose);
        }
        case "MemUseTrackers": {
            return OptionDescriptor.create(
                /*name*/ "MemUseTrackers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma separated names of memory usage trackers that are enabled irrespective of the value for TrackMemUse option. An empty value enables all memory usage trackers unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "MemUseTrackers",
                /*option*/ DebugOptions.MemUseTrackers);
        }
        case "MethodFilter": {
            return OptionDescriptor.create(
                /*name*/ "MethodFilter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for matching methods. The syntax for a pattern is:",
                /*extraHelp*/ new String[] {
                         "",
                         "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .",
                         "  SourcePattern = [ \"~\" ] [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .",
                         "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .",
                         "  Class = { package \".\" } class .",
                         "",
                         "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.",
                         "The \"~\" prefix negates the pattern.",
                         "",
                         "Positive patterns are joined by an \"or\" operator: \"A,B\" matches anything",
                         "matched by \"A\" or \"B\". Negative patterns are joined by \"and not\": \"~A,~B\"",
                         "matches anything not matched by \"A\" and not matched by \"B\". \"A,~B,~C,D\"",
                         "matches anything matched by \"A\" or \"D\" and not matched by \"B\" and not",
                         "matched by \"C\".",
                         "",
                         "A set of patterns containing negative patterns but no positive ones contains",
                         "an implicit positive \"*\" pattern: \"~A,~B\" is equivalent to \"*,~A,~B\".",
                         "",
                         "Examples of method filters:",
                         "---------",
                         "  *",
                         "",
                         "  Matches all methods in all classes.",
                         "---------",
                         "  canonical(CanonicalizerTool;LogicNode;LogicNode)",
                         "",
                         "  Matches all methods named \"canonical\", with the first parameter of type",
                         "  \"CanonicalizerTool\", and the second and third parameters of type",
                         "  \"LogicNode\".",
                         "  The packages of the parameter types are irrelevant.",
                         "---------",
                         "  arraycopy(Object;;;;)",
                         "",
                         "  Matches all methods named \"arraycopy\", with the first parameter",
                         "  of type \"Object\", and four more parameters of any type. The",
                         "  packages of the parameter types are irrelevant.",
                         "---------",
                         "  org.graalvm.compiler.nodes.PhiNode.*",
                         "",
                         "  Matches all methods in the class \"org.graalvm.compiler.nodes.PhiNode\".",
                         "---------",
                         "  org.graalvm.compiler.nodes.*.canonical",
                         "",
                         "  Matches all methods named \"canonical\" in classes in the package",
                         "  \"org.graalvm.compiler.nodes\".",
                         "---------",
                         "  arraycopy,toString",
                         "",
                         "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts",
                         "  as an \"or\" operator.",
                         "---------",
                         "  java.util.*.*.,~java.util.*Array*.*",
                         "  java.util.*.*.,~*Array*.*",
                         "",
                         "  These patterns are equivalent and match all methods in the package",
                         "  \"java.util\" except for classes that have \"Array\" in their name.",
                         "---------",
                         "  ~java.util.*.*",
                         "",
                         "  Matches all methods in all classes in all packages except for anything in",
                         "  the \"java.util\" package.",
                              },
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "MethodFilter",
                /*option*/ DebugOptions.MethodFilter);
        }
        case "MethodFilterRootOnly": {
            return OptionDescriptor.create(
                /*name*/ "MethodFilterRootOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Only check MethodFilter against the root method in the context if true, otherwise check all methods",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "MethodFilterRootOnly",
                /*option*/ DebugOptions.MethodFilterRootOnly);
        }
        case "MetricsFile": {
            return OptionDescriptor.create(
                /*name*/ "MetricsFile",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "File to which metrics are dumped per compilation.",
                /*extraHelp*/ new String[] {
                         "A CSV format is used if the file ends with .csv otherwise a more",
                         "human readable format is used. The fields in the CSV format are:",
                         "           compilable - method being compiled",
                         "  compilable_identity - identity hash code of compilable",
                         "       compilation_nr - where this compilation lies in the ordered",
                         "                        sequence of all compilations identified by",
                         "                        compilable_identity",
                         "       compilation_id - runtime issued identifier for the compilation",
                         "          metric_name - name of metric",
                         "         metric_value - value of metric",
                              },
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "MetricsFile",
                /*option*/ DebugOptions.MetricsFile);
        }
        case "PrintBackendCFG": {
            return OptionDescriptor.create(
                /*name*/ "PrintBackendCFG",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable dumping LIR, register allocation and code generation info to the C1Visualizer.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintBackendCFG",
                /*option*/ DebugOptions.PrintBackendCFG);
        }
        case "PrintBlockMapping": {
            return OptionDescriptor.create(
                /*name*/ "PrintBlockMapping",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable dumping CFG built during initial BciBlockMapping",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintBlockMapping",
                /*option*/ DebugOptions.PrintBlockMapping);
        }
        case "PrintCFG": {
            return OptionDescriptor.create(
                /*name*/ "PrintCFG",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable dumping to the C1Visualizer. Enabling this option implies PrintBackendCFG.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintCFG",
                /*option*/ DebugOptions.PrintCFG);
        }
        case "PrintCanonicalGraphStringFlavor": {
            return OptionDescriptor.create(
                /*name*/ "PrintCanonicalGraphStringFlavor",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Choose format used when dumping canonical text for graphs: 0 gives a scheduled graph (better for spotting changes involving the schedule) while 1 gives a CFG containing expressions rooted at fixed nodes (better for spotting small structure differences)",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintCanonicalGraphStringFlavor",
                /*option*/ DebugOptions.PrintCanonicalGraphStringFlavor);
        }
        case "PrintCanonicalGraphStrings": {
            return OptionDescriptor.create(
                /*name*/ "PrintCanonicalGraphStrings",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable dumping canonical text from for graphs.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintCanonicalGraphStrings",
                /*option*/ DebugOptions.PrintCanonicalGraphStrings);
        }
        case "PrintGraph": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraph",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ org.graalvm.compiler.debug.DebugOptions.PrintGraphTarget.class,
                /*help*/ "Where IdealGraphVisualizer graph dumps triggered by Dump or DumpOnError should be written.",
                /*extraHelp*/ new String[] {
                         "The accepted values are:",
                         "      File - Dump IGV graphs to the local file system (see DumpPath).",
                         "   Network - Dump IGV graphs to the network destination specified by PrintGraphHost and PrintGraphPort.",
                         "             If a network connection cannot be opened, dumping falls back to file dumping. ",
                         "   Disable - Do not dump IGV graphs.",
                              },
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraph",
                /*option*/ DebugOptions.PrintGraph);
        }
        case "PrintGraphFile": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraphFile",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Setting to true sets PrintGraph=file, setting to false sets PrintGraph=network",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraphFile",
                /*option*/ DebugOptions.PrintGraphFile);
        }
        case "PrintGraphHost": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraphHost",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Host part of the address to which graphs are dumped.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraphHost",
                /*option*/ DebugOptions.PrintGraphHost);
        }
        case "PrintGraphPort": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraphPort",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Port part of the address to which graphs are dumped in binary format.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraphPort",
                /*option*/ DebugOptions.PrintGraphPort);
        }
        case "PrintGraphWithSchedule": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraphWithSchedule",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Schedule graphs as they are dumped.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraphWithSchedule",
                /*option*/ DebugOptions.PrintGraphWithSchedule);
        }
        case "ShowDumpFiles": {
            return OptionDescriptor.create(
                /*name*/ "ShowDumpFiles",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the name of each dump file path as it's created.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "ShowDumpFiles",
                /*option*/ DebugOptions.ShowDumpFiles);
        }
        case "Time": {
            return OptionDescriptor.create(
                /*name*/ "Time",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which timing is enabled. See the Dump option for the pattern syntax. An empty value enables all timers unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Time",
                /*option*/ DebugOptions.Time);
        }
        case "Timers": {
            return OptionDescriptor.create(
                /*name*/ "Timers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma separated names of timers that are enabled irrespective of the value for Time option. An empty value enables all timers unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Timers",
                /*option*/ DebugOptions.Timers);
        }
        case "TrackMemUse": {
            return OptionDescriptor.create(
                /*name*/ "TrackMemUse",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which memory use tracking is enabled. See the Dump option for the pattern syntax. An empty value enables all memory use trackers unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "TrackMemUse",
                /*option*/ DebugOptions.TrackMemUse);
        }
        case "Verify": {
            return OptionDescriptor.create(
                /*name*/ "Verify",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which logging is enabled. See the Dump option for the pattern syntax.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Verify",
                /*option*/ DebugOptions.Verify);
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 39;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AggregatedMetricsFile");
                    case 1: return get("BootstrapInitializeOnly");
                    case 2: return get("CanonicalGraphStringsCheckConstants");
                    case 3: return get("CanonicalGraphStringsExcludeVirtuals");
                    case 4: return get("CanonicalGraphStringsRemoveIdentities");
                    case 5: return get("ClearMetricsAfterBootstrap");
                    case 6: return get("Count");
                    case 7: return get("Counters");
                    case 8: return get("DebugStubsAndSnippets");
                    case 9: return get("DiagnoseDumpLevel");
                    case 10: return get("DisableIntercept");
                    case 11: return get("Dump");
                    case 12: return get("DumpOnError");
                    case 13: return get("DumpOnPhaseChange");
                    case 14: return get("DumpPath");
                    case 15: return get("DumpingErrorsAreFatal");
                    case 16: return get("InterceptBailout");
                    case 17: return get("ListMetrics");
                    case 18: return get("Log");
                    case 19: return get("LogVerbose");
                    case 20: return get("MemUseTrackers");
                    case 21: return get("MethodFilter");
                    case 22: return get("MethodFilterRootOnly");
                    case 23: return get("MetricsFile");
                    case 24: return get("PrintBackendCFG");
                    case 25: return get("PrintBlockMapping");
                    case 26: return get("PrintCFG");
                    case 27: return get("PrintCanonicalGraphStringFlavor");
                    case 28: return get("PrintCanonicalGraphStrings");
                    case 29: return get("PrintGraph");
                    case 30: return get("PrintGraphFile");
                    case 31: return get("PrintGraphHost");
                    case 32: return get("PrintGraphPort");
                    case 33: return get("PrintGraphWithSchedule");
                    case 34: return get("ShowDumpFiles");
                    case 35: return get("Time");
                    case 36: return get("Timers");
                    case 37: return get("TrackMemUse");
                    case 38: return get("Verify");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
