/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MailSessionFactory
implements ObjectFactory {
    protected static final String factoryType = "jakarta.mail.Session";

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        Reference reference = (Reference)object;
        if (!reference.getClassName().equals(factoryType)) {
            return null;
        }
        return AccessController.doPrivileged(() -> {
            String string;
            RefAddr refAddr;
            Properties properties = new Properties();
            properties.put("mail.transport.protocol", "smtp");
            properties.put("mail.smtp.host", "localhost");
            String string2 = null;
            Enumeration<RefAddr> enumeration = reference.getAll();
            while (enumeration.hasMoreElements()) {
                refAddr = enumeration.nextElement();
                if ("factory".equals(refAddr.getType())) continue;
                if ("password".equals(refAddr.getType())) {
                    string2 = (String)refAddr.getContent();
                    continue;
                }
                properties.put(refAddr.getType(), refAddr.getContent());
            }
            refAddr = null;
            if (string2 != null) {
                string = properties.getProperty("mail.smtp.user");
                if (string == null) {
                    string = properties.getProperty("mail.user");
                }
                if (string != null) {
                    final PasswordAuthentication passwordAuthentication = new PasswordAuthentication(string, string2);
                    refAddr = new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return passwordAuthentication;
                        }
                    };
                }
            }
            string = Session.getInstance((Properties)properties, (Authenticator)refAddr);
            return string;
        });
    }
}

