/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Server;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.Diagnostics;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class ManagerServlet
extends HttpServlet
implements ContainerServlet {
    private static final long serialVersionUID = 1L;
    protected static final boolean LAST_ACCESS_AT_START;
    protected File configBase = null;
    protected transient Context context = null;
    protected int debug = 1;
    protected File deployed = null;
    protected File versioned = null;
    @Deprecated
    protected File contextDescriptors = null;
    protected transient Host host = null;
    @Deprecated
    protected File appBase = null;
    protected transient MBeanServer mBeanServer = null;
    protected ObjectName oname = null;
    protected transient javax.naming.Context global = null;
    protected static final StringManager sm;
    protected transient Wrapper wrapper = null;

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.host = null;
            this.oname = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.host = (Host)this.context.getParent();
            Engine engine = (Engine)this.host.getParent();
            String string = engine.getName() + ":type=Deployer,host=" + this.host.getName();
            try {
                this.oname = new ObjectName(string);
            }
            catch (Exception exception) {
                this.log(sm.getString("managerServlet.objectNameFail", new Object[]{string}), exception);
            }
        }
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager", (Enumeration)httpServletRequest.getLocales());
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        String string2 = httpServletRequest.getParameter("config");
        String string3 = httpServletRequest.getParameter("path");
        ContextName contextName = null;
        if (string3 != null) {
            contextName = new ContextName(string3, httpServletRequest.getParameter("version"));
        }
        String string4 = httpServletRequest.getParameter("type");
        String string5 = httpServletRequest.getParameter("war");
        String string6 = httpServletRequest.getParameter("tag");
        boolean bl = false;
        if (httpServletRequest.getParameter("update") != null && httpServletRequest.getParameter("update").equals("true")) {
            bl = true;
        }
        boolean bl2 = false;
        if ("true".equals(httpServletRequest.getParameter("statusLine"))) {
            bl2 = true;
        }
        httpServletResponse.setContentType("text/plain; charset=utf-8");
        httpServletResponse.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (string == null) {
            printWriter.println(stringManager.getString("managerServlet.noCommand"));
        } else if (string.equals("/deploy")) {
            if (string5 != null || string2 != null) {
                this.deploy(printWriter, string2, contextName, string5, bl, stringManager);
            } else if (string6 != null) {
                this.deploy(printWriter, contextName, string6, stringManager);
            } else {
                printWriter.println(stringManager.getString("managerServlet.invalidCommand", new Object[]{string}));
            }
        } else if (string.equals("/list")) {
            this.list(printWriter, stringManager);
        } else if (string.equals("/reload")) {
            this.reload(printWriter, contextName, stringManager);
        } else if (string.equals("/resources")) {
            this.resources(printWriter, string4, stringManager);
        } else if (string.equals("/save")) {
            this.save(printWriter, string3, stringManager);
        } else if (string.equals("/serverinfo")) {
            this.serverinfo(printWriter, stringManager);
        } else if (string.equals("/sessions")) {
            this.expireSessions(printWriter, contextName, httpServletRequest, stringManager);
        } else if (string.equals("/expire")) {
            this.expireSessions(printWriter, contextName, httpServletRequest, stringManager);
        } else if (string.equals("/start")) {
            this.start(printWriter, contextName, stringManager);
        } else if (string.equals("/stop")) {
            this.stop(printWriter, contextName, stringManager);
        } else if (string.equals("/undeploy")) {
            this.undeploy(printWriter, contextName, stringManager);
        } else if (string.equals("/findleaks")) {
            this.findleaks(bl2, printWriter, stringManager);
        } else if (string.equals("/vminfo")) {
            this.vmInfo(printWriter, stringManager, httpServletRequest.getLocales());
        } else if (string.equals("/threaddump")) {
            this.threadDump(printWriter, stringManager, httpServletRequest.getLocales());
        } else {
            printWriter.println(stringManager.getString("managerServlet.unknownCommand", new Object[]{string}));
        }
        printWriter.flush();
        printWriter.close();
    }

    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager", (Enumeration)httpServletRequest.getLocales());
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        String string2 = httpServletRequest.getParameter("path");
        ContextName contextName = null;
        if (string2 != null) {
            contextName = new ContextName(string2, httpServletRequest.getParameter("version"));
        }
        String string3 = httpServletRequest.getParameter("tag");
        boolean bl = false;
        if (httpServletRequest.getParameter("update") != null && httpServletRequest.getParameter("update").equals("true")) {
            bl = true;
        }
        httpServletResponse.setContentType("text/plain;charset=utf-8");
        httpServletResponse.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (string == null) {
            printWriter.println(stringManager.getString("managerServlet.noCommand"));
        } else if (string.equals("/deploy")) {
            this.deploy(printWriter, contextName, string3, bl, httpServletRequest, stringManager);
        } else {
            printWriter.println(stringManager.getString("managerServlet.unknownCommand", new Object[]{string}));
        }
        printWriter.flush();
        printWriter.close();
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("managerServlet.noWrapper"));
        }
        String string = null;
        try {
            string = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        Server server = ((Engine)this.host.getParent()).getService().getServer();
        if (server != null) {
            this.global = server.getGlobalNamingContext();
        }
        this.versioned = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        String string2 = ((Host)this.context.getParent()).getAppBase();
        this.deployed = new File(string2);
        if (!this.deployed.isAbsolute()) {
            this.deployed = new File(System.getProperty("catalina.base"), string2);
        }
        this.configBase = new File(System.getProperty("catalina.base"), "conf");
        Context context = null;
        Context context2 = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                context = container;
            }
            if (!(container instanceof Engine)) continue;
            context2 = container;
        }
        if (context2 != null) {
            this.configBase = new File(this.configBase, context2.getName());
        }
        if (context != null) {
            this.configBase = new File(this.configBase, context.getName());
        }
        if (this.debug >= 1) {
            this.log("init: Associated with Deployer '" + this.oname + "'");
            if (this.global != null) {
                this.log("init: Global resources are available");
            }
        }
    }

    protected void findleaks(boolean bl, PrintWriter printWriter, StringManager stringManager) {
        if (!(this.host instanceof StandardHost)) {
            printWriter.println(stringManager.getString("managerServlet.findleaksFail"));
            return;
        }
        String[] stringArray = ((StandardHost)this.host).findReloadedContextMemoryLeaks();
        if (stringArray.length > 0) {
            if (bl) {
                printWriter.println(stringManager.getString("managerServlet.findleaksList"));
            }
            for (String string : stringArray) {
                if ("".equals(string)) {
                    string = "/";
                }
                printWriter.println(string);
            }
        } else if (bl) {
            printWriter.println(stringManager.getString("managerServlet.findleaksNone"));
        }
    }

    protected void vmInfo(PrintWriter printWriter, StringManager stringManager, Enumeration<Locale> enumeration) {
        printWriter.println(stringManager.getString("managerServlet.vminfo"));
        printWriter.print(Diagnostics.getVMInfo(enumeration));
    }

    protected void threadDump(PrintWriter printWriter, StringManager stringManager, Enumeration<Locale> enumeration) {
        printWriter.println(stringManager.getString("managerServlet.threaddump"));
        printWriter.print(Diagnostics.getThreadDump(enumeration));
    }

    protected synchronized void save(PrintWriter printWriter, String string, StringManager stringManager) {
        Server server = ((Engine)this.host.getParent()).getService().getServer();
        if (!(server instanceof StandardServer)) {
            printWriter.println(stringManager.getString("managerServlet.saveFail", new Object[]{server}));
            return;
        }
        if (string == null || string.length() == 0 || !string.startsWith("/")) {
            try {
                ((StandardServer)server).storeConfig();
                printWriter.println(stringManager.getString("managerServlet.saved"));
            }
            catch (Exception exception) {
                this.log("managerServlet.storeConfig", exception);
                printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{exception.toString()}));
            }
        } else {
            Context context;
            String string2 = string;
            if (string.equals("/")) {
                string2 = "";
            }
            if ((context = (Context)this.host.findChild(string2)) == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{string}));
                return;
            }
            try {
                ((StandardServer)server).storeContext(context);
                printWriter.println(stringManager.getString("managerServlet.savedContext", new Object[]{string}));
            }
            catch (Exception exception) {
                this.log("managerServlet.save[" + string + "]", exception);
                printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{exception.toString()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deploy(PrintWriter printWriter, ContextName contextName, String string, boolean bl, HttpServletRequest httpServletRequest, StringManager stringManager) {
        String string2;
        String string3;
        block22: {
            File file;
            if (this.debug >= 1) {
                this.log("deploy: Deploying web application '" + contextName + "'");
            }
            if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
                return;
            }
            string3 = contextName.getName();
            String string4 = contextName.getBaseName();
            string2 = contextName.getDisplayName();
            Context context = (Context)this.host.findChild(string3);
            if (context != null && !bl) {
                printWriter.println(stringManager.getString("managerServlet.alreadyContext", new Object[]{string2}));
                return;
            }
            File file2 = new File(this.deployed, string4 + ".war");
            if (string == null) {
                if (bl) {
                    file = new File(file2.getAbsolutePath() + ".tmp");
                    if (file.exists() && !file.delete()) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
                    }
                } else {
                    file = file2;
                }
            } else {
                File file3 = new File(this.versioned, string);
                if (!file3.mkdirs() && !file3.isDirectory()) {
                    printWriter.println(stringManager.getString("managerServlet.mkdirFail", new Object[]{file3}));
                    return;
                }
                file = new File(file3, string4 + ".war");
            }
            if (this.debug >= 2) {
                this.log("Uploading WAR file to " + file);
            }
            try {
                if (this.isServiced(string3)) {
                    printWriter.println(stringManager.getString("managerServlet.inService", new Object[]{string2}));
                    break block22;
                }
                this.addServiced(string3);
                try {
                    this.uploadWar(printWriter, httpServletRequest, file, stringManager);
                    if (bl && string == null) {
                        if (file2.exists() && !file2.delete()) {
                            printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file2}));
                            return;
                        }
                        if (!file.renameTo(file2)) {
                            printWriter.println(stringManager.getString("managerServlet.renameFail", new Object[]{file, file2}));
                            return;
                        }
                    }
                    if (string != null) {
                        ManagerServlet.copy(file, file2);
                    }
                    this.check(string3);
                }
                finally {
                    this.removeServiced(string3);
                }
            }
            catch (Exception exception) {
                this.log("managerServlet.check[" + string2 + "]", exception);
                printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{exception.toString()}));
                return;
            }
        }
        this.writeDeployResult(printWriter, stringManager, string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter printWriter, ContextName contextName, String string, StringManager stringManager) {
        String string2;
        String string3;
        block9: {
            if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
                return;
            }
            String string4 = contextName.getBaseName();
            string3 = contextName.getName();
            string2 = contextName.getDisplayName();
            File file = new File(new File(this.versioned, string), string4 + ".war");
            File file2 = new File(this.deployed, string4 + ".war");
            try {
                if (this.isServiced(string3)) {
                    printWriter.println(stringManager.getString("managerServlet.inService", new Object[]{string2}));
                    break block9;
                }
                this.addServiced(string3);
                try {
                    if (!file2.delete()) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file2}));
                        return;
                    }
                    ManagerServlet.copy(file, file2);
                    this.check(string3);
                }
                finally {
                    this.removeServiced(string3);
                }
            }
            catch (Exception exception) {
                this.log("managerServlet.check[" + string2 + "]", exception);
                printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{exception.toString()}));
                return;
            }
        }
        this.writeDeployResult(printWriter, stringManager, string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter printWriter, String string, ContextName contextName, String string2, boolean bl, StringManager stringManager) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (this.debug >= 1) {
            if (string != null && string.length() > 0) {
                if (string2 != null) {
                    this.log("install: Installing context configuration at '" + string + "' from '" + string2 + "'");
                } else {
                    this.log("install: Installing context configuration at '" + string + "'");
                }
            } else if (contextName != null) {
                this.log("install: Installing web application '" + contextName + "' from '" + string2 + "'");
            } else {
                this.log("install: Installing web application from '" + string2 + "'");
            }
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string3 = contextName.getName();
        String string4 = contextName.getBaseName();
        String string5 = contextName.getDisplayName();
        Context context = (Context)this.host.findChild(string3);
        if (context != null && !bl) {
            printWriter.println(stringManager.getString("managerServlet.alreadyContext", new Object[]{string5}));
            return;
        }
        if (string != null && string.startsWith("file:")) {
            string = string.substring("file:".length());
        }
        if (string2 != null && string2.startsWith("file:")) {
            string2 = string2.substring("file:".length());
        }
        try {
            if (this.isServiced(string3)) {
                printWriter.println(stringManager.getString("managerServlet.inService", new Object[]{string5}));
            } else {
                this.addServiced(string3);
                try {
                    File file;
                    if (string != null) {
                        if (!this.configBase.mkdirs() && !this.configBase.isDirectory()) {
                            printWriter.println(stringManager.getString("managerServlet.mkdirFail", new Object[]{this.configBase}));
                            return;
                        }
                        file = new File(this.configBase, string4 + ".xml");
                        if (file.isFile() && !file.delete()) {
                            printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
                            return;
                        }
                        ManagerServlet.copy(new File(string), file);
                    }
                    if (string2 != null) {
                        file = string2.endsWith(".war") ? new File(this.deployed, string4 + ".war") : new File(this.deployed, string4);
                        if (file.exists() && !ExpandWar.delete(file)) {
                            printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
                            return;
                        }
                        ManagerServlet.copy(new File(string2), file);
                    }
                    this.check(string3);
                }
                finally {
                    this.removeServiced(string3);
                }
            }
            this.writeDeployResult(printWriter, stringManager, string3, string5);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log("ManagerServlet.install[" + string5 + "]", throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    private void writeDeployResult(PrintWriter printWriter, StringManager stringManager, String string, String string2) {
        Context context = (Context)this.host.findChild(string);
        if (context != null && context.getConfigured() && context.getState().isAvailable()) {
            printWriter.println(stringManager.getString("managerServlet.deployed", new Object[]{string2}));
        } else if (context != null && !context.getState().isAvailable()) {
            printWriter.println(stringManager.getString("managerServlet.deployedButNotStarted", new Object[]{string2}));
        } else {
            printWriter.println(stringManager.getString("managerServlet.deployFailed", new Object[]{string2}));
        }
    }

    protected void list(PrintWriter printWriter, StringManager stringManager) {
        Container[] containerArray;
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.host.getName() + "'");
        }
        printWriter.println(stringManager.getString("managerServlet.listed", new Object[]{this.host.getName()}));
        for (Container container : containerArray = this.host.findChildren()) {
            Context context = (Context)container;
            if (context == null) continue;
            String string = context.getPath();
            if (string.equals("")) {
                string = "/";
            }
            List<String> list = null;
            list = context.getState().isAvailable() ? Arrays.asList(string, "running", "" + context.getManager().findSessions().length, context.getDocBase()) : Arrays.asList(string, "stopped", "0", context.getDocBase());
            printWriter.println(StringUtils.join(list, (char)':'));
        }
    }

    protected void reload(PrintWriter printWriter, ContextName contextName, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application '" + contextName + "'");
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        try {
            Context context = (Context)this.host.findChild(contextName.getName());
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(contextName.getDisplayName())}));
                return;
            }
            if (context.getName().equals(this.context.getName())) {
                printWriter.println(stringManager.getString("managerServlet.noSelf"));
                return;
            }
            context.reload();
            printWriter.println(stringManager.getString("managerServlet.reloaded", new Object[]{contextName.getDisplayName()}));
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log("ManagerServlet.reload[" + contextName.getDisplayName() + "]", throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected void resources(PrintWriter printWriter, String string, StringManager stringManager) {
        if (this.debug >= 1) {
            if (string != null) {
                this.log("resources:  Listing resources of type " + string);
            } else {
                this.log("resources:  Listing resources of all types");
            }
        }
        if (this.global == null) {
            printWriter.println(stringManager.getString("managerServlet.noGlobal"));
            return;
        }
        if (string != null) {
            printWriter.println(stringManager.getString("managerServlet.resourcesType", new Object[]{string}));
        } else {
            printWriter.println(stringManager.getString("managerServlet.resourcesAll"));
        }
        this.printResources(printWriter, "", this.global, string, stringManager);
    }

    @Deprecated
    protected void printResources(PrintWriter printWriter, String string, javax.naming.Context context, String string2, Class<?> clazz, StringManager stringManager) {
        this.printResources(printWriter, string, context, string2, stringManager);
    }

    protected void printResources(PrintWriter printWriter, String string, javax.naming.Context context, String string2, StringManager stringManager) {
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
            while (namingEnumeration.hasMore()) {
                Binding binding = namingEnumeration.next();
                Object object = binding.getObject();
                if (object instanceof javax.naming.Context) {
                    this.printResources(printWriter, string + binding.getName() + "/", (javax.naming.Context)object, string2, stringManager);
                    continue;
                }
                if (string2 != null && (object == null || !IntrospectionUtils.isInstance(object.getClass(), (String)string2))) continue;
                printWriter.print(string + binding.getName());
                printWriter.print(':');
                printWriter.print(binding.getClassName());
                printWriter.println();
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log("ManagerServlet.resources[" + string2 + "]", throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected void serverinfo(PrintWriter printWriter, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("serverinfo");
        }
        try {
            printWriter.println(stringManager.getString("managerServlet.serverInfo", new Object[]{ServerInfo.getServerInfo(), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor")}));
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.getServletContext().log("ManagerServlet.serverinfo", throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected void sessions(PrintWriter printWriter, ContextName contextName, int n, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("sessions: Session information for web application '" + contextName + "'");
            if (n >= 0) {
                this.log("sessions: Session expiration for " + n + " minutes '" + contextName + "'");
            }
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string = contextName.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(contextName.getName());
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(string)}));
                return;
            }
            Manager manager = context.getManager();
            if (manager == null) {
                printWriter.println(stringManager.getString("managerServlet.noManager", new Object[]{RequestUtil.filter(string)}));
                return;
            }
            int n2 = 60;
            int n3 = 1;
            int n4 = context.getSessionTimeout();
            if (n4 > 0) {
                n3 = n4 / n2;
                if (n3 * n2 < n4) {
                    ++n3;
                }
                if (0 == n3) {
                    n3 = 1;
                }
                if (n3 * (n2 = n4 / n3) < n4) {
                    ++n2;
                }
            }
            printWriter.println(stringManager.getString("managerServlet.sessions", new Object[]{string}));
            printWriter.println(stringManager.getString("managerServlet.sessiondefaultmax", new Object[]{"" + n4}));
            Session[] sessionArray = manager.findSessions();
            int[] nArray = new int[n2 + 1];
            int n5 = 0;
            int n6 = 0;
            long l = System.currentTimeMillis();
            for (Session session : sessionArray) {
                int n7 = LAST_ACCESS_AT_START ? (int)((l - session.getLastAccessedTimeInternal()) / 1000L) : (int)((l - session.getThisAccessedTimeInternal()) / 1000L);
                if (n >= 0 && n7 >= n * 60) {
                    session.expire();
                    ++n6;
                }
                if ((n7 = n7 / 60 / n3) < 0) {
                    ++n5;
                    continue;
                }
                if (n7 >= n2) {
                    int n8 = n2;
                    nArray[n8] = nArray[n8] + 1;
                    continue;
                }
                int n9 = n7;
                nArray[n9] = nArray[n9] + 1;
            }
            if (nArray[0] > 0) {
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout", new Object[]{"<" + n3, "" + nArray[0]}));
            }
            for (int i = 1; i < n2; ++i) {
                if (nArray[i] <= 0) continue;
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout", new Object[]{"" + i * n3 + " - <" + (i + 1) * n3, "" + nArray[i]}));
            }
            if (nArray[n2] > 0) {
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout", new Object[]{">=" + n2 * n3, "" + nArray[n2]}));
            }
            if (n5 > 0) {
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout.unlimited", new Object[]{"" + n5}));
            }
            if (n >= 0) {
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout.expired", new Object[]{">" + n, "" + n6}));
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log("ManagerServlet.sessions[" + string + "]", throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    @Deprecated
    protected void sessions(PrintWriter printWriter, ContextName contextName, StringManager stringManager) {
        this.sessions(printWriter, contextName, -1, stringManager);
    }

    protected void expireSessions(PrintWriter printWriter, ContextName contextName, HttpServletRequest httpServletRequest, StringManager stringManager) {
        int n = -1;
        String string = httpServletRequest.getParameter("idle");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("Could not parse idle parameter to an int: " + string);
            }
        }
        this.sessions(printWriter, contextName, n, stringManager);
    }

    protected void start(PrintWriter printWriter, ContextName contextName, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("start: Starting web application '" + contextName + "'");
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string = contextName.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(contextName.getName());
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(string)}));
                return;
            }
            context.start();
            if (context.getState().isAvailable()) {
                printWriter.println(stringManager.getString("managerServlet.started", new Object[]{string}));
            } else {
                printWriter.println(stringManager.getString("managerServlet.startFailed", new Object[]{string}));
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.getServletContext().log(sm.getString("managerServlet.startFailed", new Object[]{string}), throwable);
            printWriter.println(stringManager.getString("managerServlet.startFailed", new Object[]{string}));
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected void stop(PrintWriter printWriter, ContextName contextName, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application '" + contextName + "'");
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string = contextName.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(contextName.getName());
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(string)}));
                return;
            }
            if (context.getName().equals(this.context.getName())) {
                printWriter.println(stringManager.getString("managerServlet.noSelf"));
                return;
            }
            context.stop();
            printWriter.println(stringManager.getString("managerServlet.stopped", new Object[]{string}));
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log("ManagerServlet.stop[" + string + "]", throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeploy(PrintWriter printWriter, ContextName contextName, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("undeploy: Undeploying web application at '" + contextName + "'");
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string = contextName.getName();
        String string2 = contextName.getBaseName();
        String string3 = contextName.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(string);
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(string3)}));
                return;
            }
            if (!this.isDeployed(string)) {
                printWriter.println(stringManager.getString("managerServlet.notDeployed", new Object[]{RequestUtil.filter(string3)}));
                return;
            }
            if (this.isServiced(string)) {
                printWriter.println(stringManager.getString("managerServlet.inService", new Object[]{string3}));
            } else {
                this.addServiced(string);
                try {
                    context.stop();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                try {
                    File file = new File(this.deployed, string2 + ".war");
                    File file2 = new File(this.deployed, string2);
                    File file3 = new File(this.configBase, string2 + ".xml");
                    if (file.exists() && !file.delete()) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
                        return;
                    }
                    if (file2.exists() && !this.undeployDir(file2)) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file2}));
                        return;
                    }
                    if (file3.exists() && !file3.delete()) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file3}));
                        return;
                    }
                    this.check(string);
                }
                finally {
                    this.removeServiced(string);
                }
            }
            printWriter.println(stringManager.getString("managerServlet.undeployed", new Object[]{string3}));
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log("ManagerServlet.undeploy[" + string3 + "]", throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    @Deprecated
    protected File getAppBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected boolean isDeployed(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        Boolean bl = (Boolean)this.mBeanServer.invoke(this.oname, "isDeployed", objectArray, stringArray);
        return bl;
    }

    protected void check(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "check", objectArray, stringArray);
    }

    protected boolean isServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        Boolean bl = (Boolean)this.mBeanServer.invoke(this.oname, "isServiced", objectArray, stringArray);
        return bl;
    }

    protected void addServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "addServiced", objectArray, stringArray);
    }

    protected void removeServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "removeServiced", objectArray, stringArray);
    }

    protected boolean undeployDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (!(file2.isDirectory() ? !this.undeployDir(file2) : !file2.delete())) continue;
            return false;
        }
        return file.delete();
    }

    protected void uploadWar(PrintWriter printWriter, HttpServletRequest httpServletRequest, File file, StringManager stringManager) throws IOException {
        if (file.exists() && !file.delete()) {
            String string = stringManager.getString("managerServlet.deleteFail", new Object[]{file});
            throw new IOException(string);
        }
        ServletInputStream servletInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            servletInputStream = httpServletRequest.getInputStream();
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file), 1024);
            byte[] byArray = new byte[1024];
            while ((n = servletInputStream.read(byArray)) >= 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            ((BufferedOutputStream)filterOutputStream).flush();
            filterOutputStream.close();
            filterOutputStream = null;
            servletInputStream.close();
            servletInputStream = null;
        }
        catch (IOException iOException) {
            if (file.exists() && !file.delete()) {
                printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
            }
            throw iOException;
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                filterOutputStream = null;
            }
            if (servletInputStream != null) {
                try {
                    servletInputStream.close();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                servletInputStream = null;
            }
        }
    }

    @Deprecated
    protected StringManager getStringManager(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getLocales();
        while (enumeration.hasMoreElements()) {
            Locale locale = (Locale)enumeration.nextElement();
            StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager", (Locale)locale);
            if (!stringManager.getLocale().equals(locale)) continue;
            return stringManager;
        }
        return sm;
    }

    protected static boolean validateContextName(ContextName contextName, PrintWriter printWriter, StringManager stringManager) {
        if (contextName != null && (contextName.getPath().startsWith("/") || contextName.getPath().equals(""))) {
            return true;
        }
        String string = null;
        if (contextName != null) {
            string = RequestUtil.filter(contextName.getPath());
        }
        printWriter.println(stringManager.getString("managerServlet.invalidPath", new Object[]{string}));
        return false;
    }

    public static boolean copy(File file, File file2) {
        boolean bl = false;
        try {
            if (file != null && !file.getCanonicalPath().equals(file2.getCanonicalPath())) {
                bl = ManagerServlet.copyInternal(file, file2, new byte[4096]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyInternal(File file, File file2, byte[] byArray) {
        boolean bl = true;
        String[] stringArray = null;
        if (file.isDirectory()) {
            stringArray = file.list();
            bl = file2.mkdir();
        } else {
            stringArray = new String[]{""};
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        block17: for (int i = 0; i < stringArray.length && bl; ++i) {
            File file3 = new File(file, stringArray[i]);
            File file4 = new File(file2, stringArray[i]);
            if (file3.isDirectory()) {
                bl = ManagerServlet.copyInternal(file3, file4, byArray);
                continue;
            }
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(file3);
                fileOutputStream = new FileOutputStream(file4);
                int n = 0;
                while (true) {
                    if ((n = fileInputStream.read(byArray)) == -1) {
                        continue block17;
                    }
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl = false;
                continue;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    static {
        String string = System.getProperty("org.apache.catalina.session.StandardSession.LAST_ACCESS_AT_START");
        LAST_ACCESS_AT_START = string == null ? Globals.STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(string);
        sm = StringManager.getManager((String)"org.apache.catalina.manager");
    }
}

