/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.SessionTrackingMode;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.SessionConfig;
import org.apache.catalina.util.URLEncoder;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.res.StringManager;

public class CoyoteAdapter
implements Adapter {
    private static final Log log = LogFactory.getLog(CoyoteAdapter.class);
    private static final String POWERED_BY = "Servlet/4.0 JSP/2.3 (" + ServerInfo.getServerInfo() + " Java/" + System.getProperty("java.vm.vendor") + "/" + System.getProperty("java.runtime.version") + ")";
    private static final EnumSet<SessionTrackingMode> SSL_ONLY = EnumSet.of(SessionTrackingMode.SSL);
    public static final int ADAPTER_NOTES = 1;
    protected static final boolean ALLOW_BACKSLASH = Boolean.parseBoolean(System.getProperty("org.apache.catalina.connector.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    private static final ThreadLocal<String> THREAD_NAME = ThreadLocal.withInitial(() -> Thread.currentThread().getName());
    private final Connector connector;
    protected static final StringManager sm = StringManager.getManager(CoyoteAdapter.class);

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean asyncDispatch(org.apache.coyote.Request var1_1, org.apache.coyote.Response var2_2, SocketEvent var3_3) throws Exception {
        var4_4 = (Request)var1_1.getNote(1);
        var5_5 = (Response)var2_2.getNote(1);
        if (var4_4 == null) {
            throw new IllegalStateException(CoyoteAdapter.sm.getString("coyoteAdapter.nullRequest"));
        }
        var6_6 = true;
        var7_7 = var4_4.getAsyncContextInternal();
        var1_1.getRequestProcessor().setWorkerThreadName(CoyoteAdapter.THREAD_NAME.get());
        try {
            if (!var4_4.isAsync()) {
                var5_5.setSuspended(false);
            }
            if (var3_3 == SocketEvent.TIMEOUT) {
                if (!var7_7.timeout()) {
                    var7_7.setErrorState(null, false);
                }
            } else if (var3_3 == SocketEvent.ERROR) {
                var6_6 = false;
                var8_8 = (Throwable)var1_1.getAttribute("javax.servlet.error.exception");
                var9_14 = var4_4.getContext();
                var10_15 = null;
                try {
                    var10_15 = var9_14.bind(false, null);
                    if (var1_1.getReadListener() != null) {
                        var1_1.getReadListener().onError((Throwable)var8_8);
                    }
                    if (var2_2.getWriteListener() != null) {
                        var2_2.getWriteListener().onError((Throwable)var8_8);
                    }
                    var2_2.action(ActionCode.CLOSE_NOW, (Object)var8_8);
                    var7_7.setErrorState((Throwable)var8_8, true);
                }
                finally {
                    var9_14.unbind(false, (ClassLoader)var10_15);
                }
            }
            if (!var4_4.isAsyncDispatching() && var4_4.isAsync()) {
                var8_8 = var2_2.getWriteListener();
                var9_14 = var1_1.getReadListener();
                if (var8_8 != null && var3_3 == SocketEvent.OPEN_WRITE) {
                    var10_15 = var4_4.getContext();
                    var11_19 = null;
                    try {
                        var11_19 = var10_15.bind(false, null);
                        var2_2.onWritePossible();
                        if (var4_4.isFinished() && var1_1.sendAllDataReadEvent() && var9_14 != null) {
                            var9_14.onAllDataRead();
                        }
                        if (!var5_5.getCoyoteResponse().isExceptionPresent()) ** GOTO lbl76
                        throw var5_5.getCoyoteResponse().getErrorException();
                    }
                    catch (Throwable var12_21) {
                        ExceptionUtils.handleThrowable((Throwable)var12_21);
                        var8_8.onError(var12_21);
                        var2_2.action(ActionCode.CLOSE_NOW, (Object)var12_21);
                        var7_7.setErrorState(var12_21, true);
                    }
                    finally {
                        var10_15.unbind(false, var11_19);
                    }
                } else if (var9_14 != null && var3_3 == SocketEvent.OPEN_READ) {
                    var10_15 = var4_4.getContext();
                    var11_20 = null;
                    try {
                        var11_20 = var10_15.bind(false, null);
                        if (!var4_4.isFinished()) {
                            var9_14.onDataAvailable();
                        }
                        if (var4_4.isFinished() && var1_1.sendAllDataReadEvent()) {
                            var9_14.onAllDataRead();
                        }
                        if (var4_4.getCoyoteRequest().isExceptionPresent()) {
                            throw var4_4.getCoyoteRequest().getErrorException();
                        }
                    }
                    catch (Throwable var12_22) {
                        ExceptionUtils.handleThrowable((Throwable)var12_22);
                        var9_14.onError(var12_22);
                        var2_2.action(ActionCode.CLOSE_NOW, (Object)var12_22);
                        var7_7.setErrorState(var12_22, true);
                    }
                    finally {
                        var10_15.unbind(false, var11_20);
                    }
                }
            }
            if (!var4_4.isAsyncDispatching() && var4_4.isAsync() && var5_5.isErrorReportRequired()) {
                this.connector.getService().getContainer().getPipeline().getFirst().invoke(var4_4, var5_5);
            }
            if (var4_4.isAsyncDispatching()) {
                this.connector.getService().getContainer().getPipeline().getFirst().invoke(var4_4, var5_5);
                var8_8 = (Throwable)var4_4.getAttribute("javax.servlet.error.exception");
                if (var8_8 != null) {
                    var7_7.setErrorState((Throwable)var8_8, true);
                }
            }
            if (!var4_4.isAsync()) {
                var4_4.finishRequest();
                var5_5.finishResponse();
            }
            var8_8 = new AtomicBoolean(false);
            var2_2.action(ActionCode.IS_ERROR, (Object)var8_8);
            if (var8_8.get()) {
                if (var4_4.isAsyncCompleting()) {
                    var2_2.action(ActionCode.ASYNC_POST_PROCESS, null);
                }
                var6_6 = false;
            }
        }
        catch (IOException var8_10) {
            var6_6 = false;
        }
        catch (Throwable var8_12) {
            ExceptionUtils.handleThrowable((Throwable)var8_12);
            var6_6 = false;
            CoyoteAdapter.log.error((Object)CoyoteAdapter.sm.getString("coyoteAdapter.asyncDispatch"), var8_12);
        }
        finally {
            if (!var6_6) {
                var2_2.setStatus(500);
            }
            if (!var6_6 || !var4_4.isAsync()) {
                var8_11 = 0L;
                if (var1_1.getStartTime() != -1L) {
                    var8_11 = System.currentTimeMillis() - var1_1.getStartTime();
                }
                if ((var10_16 = var4_4.getContext()) != null) {
                    var10_16.logAccess(var4_4, var5_5, var8_11, false);
                } else {
                    this.log(var1_1, var2_2, var8_11);
                }
            }
            var1_1.getRequestProcessor().setWorkerThreadName(null);
            if (!var6_6 || !var4_4.isAsync()) {
                this.updateWrapperErrorCount(var4_4, var5_5);
                var4_4.recycle();
                var5_5.recycle();
            }
        }
        return var6_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(org.apache.coyote.Request request, org.apache.coyote.Response response) throws Exception {
        block24: {
            Object object;
            Object object2;
            Request request2 = (Request)request.getNote(1);
            Response response2 = (Response)response.getNote(1);
            if (request2 == null) {
                request2 = this.connector.createRequest();
                request2.setCoyoteRequest(request);
                response2 = this.connector.createResponse();
                response2.setCoyoteResponse(response);
                request2.setResponse(response2);
                response2.setRequest(request2);
                request.setNote(1, (Object)request2);
                response.setNote(1, (Object)response2);
                request.getParameters().setQueryStringCharset(this.connector.getURICharset());
            }
            if (this.connector.getXpoweredBy()) {
                response2.addHeader("X-Powered-By", POWERED_BY);
            }
            boolean bl = false;
            boolean bl2 = false;
            request.getRequestProcessor().setWorkerThreadName(THREAD_NAME.get());
            try {
                bl2 = this.postParseRequest(request, request2, response, response2);
                if (bl2) {
                    request2.setAsyncSupported(this.connector.getService().getContainer().getPipeline().isAsyncSupported());
                    this.connector.getService().getContainer().getPipeline().getFirst().invoke(request2, response2);
                }
                if (request2.isAsync()) {
                    bl = true;
                    object2 = request.getReadListener();
                    if (object2 != null && request2.isFinished()) {
                        object = null;
                        try {
                            object = request2.getContext().bind(false, null);
                            if (request.sendAllDataReadEvent()) {
                                request.getReadListener().onAllDataRead();
                            }
                        }
                        finally {
                            request2.getContext().unbind(false, (ClassLoader)object);
                        }
                    }
                    object = (Throwable)request2.getAttribute("javax.servlet.error.exception");
                    if (!request2.isAsyncCompleting() && object != null) {
                        request2.getAsyncContextInternal().setErrorState((Throwable)object, true);
                    }
                    break block24;
                }
                request2.finishRequest();
                response2.finishResponse();
            }
            catch (IOException iOException) {
            }
            finally {
                object2 = new AtomicBoolean(false);
                response.action(ActionCode.IS_ERROR, object2);
                if (request2.isAsyncCompleting() && ((AtomicBoolean)object2).get()) {
                    response.action(ActionCode.ASYNC_POST_PROCESS, null);
                    bl = false;
                }
                if (!bl && bl2) {
                    object = request2.getContext();
                    Host host = request2.getHost();
                    long l = System.currentTimeMillis() - request.getStartTime();
                    if (object != null) {
                        object.logAccess(request2, response2, l, false);
                    } else if (response2.isError()) {
                        if (host != null) {
                            host.logAccess(request2, response2, l, false);
                        } else {
                            this.connector.getService().getContainer().logAccess(request2, response2, l, false);
                        }
                    }
                }
                request.getRequestProcessor().setWorkerThreadName(null);
                if (!bl) {
                    this.updateWrapperErrorCount(request2, response2);
                    request2.recycle();
                    response2.recycle();
                }
            }
        }
    }

    private void updateWrapperErrorCount(Request request, Response response) {
        Wrapper wrapper;
        if (response.isError() && (wrapper = request.getWrapper()) != null) {
            wrapper.incrementErrorCount();
        }
    }

    public boolean prepare(org.apache.coyote.Request request, org.apache.coyote.Response response) throws IOException, ServletException {
        Request request2 = (Request)request.getNote(1);
        Response response2 = (Response)response.getNote(1);
        return this.postParseRequest(request, request2, response, response2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(org.apache.coyote.Request request, org.apache.coyote.Response response, long l) {
        Request request2 = (Request)request.getNote(1);
        Response response2 = (Response)response.getNote(1);
        if (request2 == null) {
            request2 = this.connector.createRequest();
            request2.setCoyoteRequest(request);
            response2 = this.connector.createResponse();
            response2.setCoyoteResponse(response);
            request2.setResponse(response2);
            response2.setRequest(request2);
            request.setNote(1, (Object)request2);
            response.setNote(1, (Object)response2);
            request.getParameters().setQueryStringCharset(this.connector.getURICharset());
        }
        try {
            boolean bl = false;
            Context context = request2.mappingData.context;
            Host host = request2.mappingData.host;
            if (context != null) {
                bl = true;
                context.logAccess(request2, response2, l, true);
            } else if (host != null) {
                bl = true;
                host.logAccess(request2, response2, l, true);
            }
            if (!bl) {
                this.connector.getService().getContainer().logAccess(request2, response2, l, true);
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("coyoteAdapter.accesslogFail"), throwable);
        }
        finally {
            this.updateWrapperErrorCount(request2, response2);
            request2.recycle();
            response2.recycle();
        }
    }

    public void checkRecycled(org.apache.coyote.Request request, org.apache.coyote.Response response) {
        Request request2 = (Request)request.getNote(1);
        Response response2 = (Response)response.getNote(1);
        String string = null;
        if (request2 != null && request2.getHost() != null) {
            string = "coyoteAdapter.checkRecycled.request";
        } else if (response2 != null && response2.getContentWritten() != 0L) {
            string = "coyoteAdapter.checkRecycled.response";
        }
        if (string != null) {
            this.log(request, response, 0L);
            if (this.connector.getState().isAvailable()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString(string), (Throwable)new RecycleRequiredException());
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString(string), (Throwable)new RecycleRequiredException());
            }
        }
    }

    public String getDomain() {
        return this.connector.getDomain();
    }

    protected boolean postParseRequest(org.apache.coyote.Request request, Request request2, org.apache.coyote.Response response, Response response2) throws IOException, ServletException {
        Object object;
        Context[] contextArray;
        Object object2;
        CharChunk charChunk;
        MessageBytes messageBytes;
        if (request.scheme().isNull()) {
            request.scheme().setString(this.connector.getScheme());
            request2.setSecure(this.connector.getSecure());
        } else {
            request2.setSecure(request.scheme().equals("https"));
        }
        String string = this.connector.getProxyName();
        int n = this.connector.getProxyPort();
        if (n != 0) {
            request.setServerPort(n);
        } else if (request.getServerPort() == -1) {
            if (request.scheme().equals("https")) {
                request.setServerPort(443);
            } else {
                request.setServerPort(80);
            }
        }
        if (string != null) {
            request.serverName().setString(string);
        }
        if ((messageBytes = request.requestURI()).equals("*")) {
            if (request.method().equalsIgnoreCase("OPTIONS")) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("GET, HEAD, POST, PUT, DELETE, OPTIONS");
                if (this.connector.getAllowTrace()) {
                    stringBuilder.append(", TRACE");
                }
                response.setHeader("Allow", stringBuilder.toString());
                this.connector.getService().getContainer().logAccess(request2, response2, 0L, true);
                return false;
            }
            response2.sendError(400, "Invalid URI");
        }
        MessageBytes messageBytes2 = request.decodedURI();
        if (messageBytes.getType() == 2) {
            messageBytes2.duplicate(messageBytes);
            this.parsePathParameters(request, request2);
            try {
                request.getURLDecoder().convert(messageBytes2.getByteChunk(), this.connector.getEncodedSolidusHandlingInternal());
            }
            catch (IOException iOException) {
                response2.sendError(400, "Invalid URI: " + iOException.getMessage());
            }
            if (CoyoteAdapter.normalize(request.decodedURI())) {
                this.convertURI(messageBytes2, request2);
                if (!CoyoteAdapter.checkNormalize(request.decodedURI())) {
                    response2.sendError(400, "Invalid URI");
                }
            } else {
                response2.sendError(400, "Invalid URI");
            }
        } else {
            messageBytes2.toChars();
            charChunk = messageBytes2.getCharChunk();
            int n2 = charChunk.indexOf(';');
            if (n2 > 0) {
                messageBytes2.setChars(charChunk.getBuffer(), charChunk.getStart(), n2);
            }
        }
        if (this.connector.getUseIPVHosts()) {
            charChunk = request.localName();
            if (charChunk.isNull()) {
                response.action(ActionCode.REQ_LOCAL_NAME_ATTRIBUTE, null);
            }
        } else {
            charChunk = request.serverName();
        }
        String string2 = null;
        Object object3 = null;
        boolean bl = true;
        if (response2.isError()) {
            messageBytes2.recycle();
        }
        while (bl) {
            this.connector.getService().getMapper().map((MessageBytes)charChunk, messageBytes2, string2, request2.getMappingData());
            if (request2.getContext() == null) {
                return true;
            }
            if (request2.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.URL) && (object2 = request2.getPathParameter(SessionConfig.getSessionUriParamName(request2.getContext()))) != null) {
                request2.setRequestedSessionId((String)object2);
                request2.setRequestedSessionURL(true);
            }
            try {
                this.parseSessionCookiesId(request2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!response2.isError()) {
                    response2.setError();
                    response2.sendError(400);
                }
                return true;
            }
            this.parseSessionSslId(request2);
            object2 = request2.getRequestedSessionId();
            bl = false;
            if (string2 == null || request2.getContext() != object3) {
                string2 = null;
                object3 = null;
                contextArray = request2.getMappingData().contexts;
                if (contextArray != null && object2 != null) {
                    for (int i = contextArray.length; i > 0; --i) {
                        object = contextArray[i - 1];
                        if (object.getManager().findSession((String)object2) == null) continue;
                        if (object.equals(request2.getMappingData().context)) break;
                        string2 = object.getWebappVersion();
                        object3 = object;
                        request2.getMappingData().recycle();
                        bl = true;
                        request2.recycleSessionInfo();
                        request2.recycleCookieInfo(true);
                        break;
                    }
                }
            }
            if (bl || !request2.getContext().getPaused()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            request2.getMappingData().recycle();
            bl = true;
        }
        object2 = request2.getMappingData().redirectPath;
        if (!object2.isNull()) {
            contextArray = URLEncoder.DEFAULT.encode(object2.toString(), StandardCharsets.UTF_8);
            String string3 = request2.getQueryString();
            if (request2.isRequestedSessionIdFromURL()) {
                contextArray = (String)contextArray + ";" + SessionConfig.getSessionUriParamName(request2.getContext()) + "=" + request2.getRequestedSessionId();
            }
            if (string3 != null) {
                contextArray = (String)contextArray + "?" + string3;
            }
            response2.sendRedirect((String)contextArray);
            request2.getContext().logAccess(request2, response2, 0L, true);
            return false;
        }
        if (!this.connector.getAllowTrace() && request.method().equalsIgnoreCase("TRACE")) {
            contextArray = request2.getWrapper();
            String string4 = null;
            if (contextArray != null && (object = contextArray.getServletMethods()) != null) {
                for (String string5 : object) {
                    if ("TRACE".equals(string5)) continue;
                    string4 = string4 == null ? string5 : string4 + ", " + string5;
                }
            }
            if (string4 != null) {
                response.addHeader("Allow", string4);
            }
            response2.sendError(405, "TRACE method is not allowed");
            return true;
        }
        this.doConnectorAuthenticationAuthorization(request, request2);
        return true;
    }

    private void doConnectorAuthenticationAuthorization(org.apache.coyote.Request request, Request request2) {
        Object object;
        String string = request.getRemoteUser().toString();
        if (string != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("coyoteAdapter.authenticate", new Object[]{string}));
            }
            if (request.getRemoteUserNeedsAuthorization()) {
                object = request2.getContext().getAuthenticator();
                if (!(object instanceof AuthenticatorBase)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("coyoteAdapter.authorize", new Object[]{string}));
                    }
                    request2.setUserPrincipal(request2.getContext().getRealm().authenticate(string));
                }
            } else {
                request2.setUserPrincipal(new CoyotePrincipal(string));
            }
        }
        if ((object = request.getAuthType().toString()) != null) {
            request2.setAuthType((String)object);
        }
    }

    protected void parsePathParameters(org.apache.coyote.Request request, Request request2) {
        request.decodedURI().toBytes();
        ByteChunk byteChunk = request.decodedURI().getByteChunk();
        int n = byteChunk.indexOf(';', 0);
        if (n == -1) {
            return;
        }
        Charset charset = this.connector.getURICharset();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"uriBC", byteChunk.toString()}));
            log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"semicolon", String.valueOf(n)}));
            log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"enc", charset.name()}));
        }
        while (n > -1) {
            int n2;
            int n3 = byteChunk.getStart();
            int n4 = byteChunk.getEnd();
            int n5 = n + 1;
            int n6 = ByteChunk.findBytes((byte[])byteChunk.getBuffer(), (int)(n3 + n5), (int)n4, (byte[])new byte[]{59, 47});
            String string = null;
            if (n6 >= 0) {
                if (charset != null) {
                    string = new String(byteChunk.getBuffer(), n3 + n5, n6 - n5, charset);
                }
                byte[] byArray = byteChunk.getBuffer();
                for (int i = 0; i < n4 - n3 - n6; ++i) {
                    byArray[n3 + n + i] = byArray[n3 + i + n6];
                }
                byteChunk.setBytes(byArray, n3, n4 - n3 - n6 + n);
            } else {
                if (charset != null) {
                    string = new String(byteChunk.getBuffer(), n3 + n5, n4 - n3 - n5, charset);
                }
                byteChunk.setEnd(n3 + n);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"pathParamStart", String.valueOf(n5)}));
                log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"pathParamEnd", String.valueOf(n6)}));
                log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"pv", string}));
            }
            if (string != null && (n2 = string.indexOf(61)) > -1) {
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                request2.addPathParameter(string2, string3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"equals", String.valueOf(n2)}));
                    log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"name", string2}));
                    log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"value", string3}));
                }
            }
            n = byteChunk.indexOf(';', n);
        }
    }

    protected void parseSessionSslId(Request request) {
        String string;
        if (request.getRequestedSessionId() == null && SSL_ONLY.equals(request.getServletContext().getEffectiveSessionTrackingModes()) && request.connector.secure && (string = (String)request.getAttribute("javax.servlet.request.ssl_session_id")) != null) {
            request.setRequestedSessionId(string);
            request.setRequestedSessionSSL(true);
        }
    }

    protected void parseSessionCookiesId(Request request) {
        Context context = request.getMappingData().context;
        if (context != null && !context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            return;
        }
        ServerCookies serverCookies = request.getServerCookies();
        int n = serverCookies.getCookieCount();
        if (n <= 0) {
            return;
        }
        String string = SessionConfig.getSessionCookieName(context);
        for (int i = 0; i < n; ++i) {
            ServerCookie serverCookie = serverCookies.getCookie(i);
            if (!serverCookie.getName().equals(string)) continue;
            if (!request.isRequestedSessionIdFromCookie()) {
                this.convertMB(serverCookie.getValue());
                request.setRequestedSessionId(serverCookie.getValue().toString());
                request.setRequestedSessionCookie(true);
                request.setRequestedSessionURL(false);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(" Requested cookie session id is " + request.getRequestedSessionId()));
                continue;
            }
            if (request.isRequestedSessionIdValid()) continue;
            this.convertMB(serverCookie.getValue());
            request.setRequestedSessionId(serverCookie.getValue().toString());
        }
    }

    protected void convertURI(MessageBytes messageBytes, Request request) throws IOException {
        ByteChunk byteChunk = messageBytes.getByteChunk();
        int n = byteChunk.getLength();
        CharChunk charChunk = messageBytes.getCharChunk();
        charChunk.allocate(n, -1);
        Charset charset = this.connector.getURICharset();
        B2CConverter b2CConverter = request.getURIConverter();
        if (b2CConverter == null) {
            b2CConverter = new B2CConverter(charset, true);
            request.setURIConverter(b2CConverter);
        } else {
            b2CConverter.recycle();
        }
        try {
            b2CConverter.convert(byteChunk, charChunk, true);
            messageBytes.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
        }
        catch (IOException iOException) {
            request.getResponse().sendError(400);
        }
    }

    protected void convertMB(MessageBytes messageBytes) {
        if (messageBytes.getType() != 2) {
            return;
        }
        ByteChunk byteChunk = messageBytes.getByteChunk();
        CharChunk charChunk = messageBytes.getCharChunk();
        int n = byteChunk.getLength();
        charChunk.allocate(n, -1);
        byte[] byArray = byteChunk.getBuffer();
        char[] cArray = charChunk.getBuffer();
        int n2 = byteChunk.getStart();
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(byArray[i + n2] & 0xFF);
        }
        messageBytes.setChars(cArray, 0, n);
    }

    public static boolean normalize(MessageBytes messageBytes) {
        int n;
        ByteChunk byteChunk = messageBytes.getByteChunk();
        byte[] byArray = byteChunk.getBytes();
        int n2 = byteChunk.getStart();
        if (n2 == (n = byteChunk.getEnd())) {
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        if (byArray[n2] != 47 && byArray[n2] != 92) {
            return false;
        }
        for (n3 = n2; n3 < n; ++n3) {
            if (byArray[n3] == 92) {
                if (ALLOW_BACKSLASH) {
                    byArray[n3] = 47;
                    continue;
                }
                return false;
            }
            if (byArray[n3] != 0) continue;
            return false;
        }
        for (n3 = n2; n3 < n - 1; ++n3) {
            if (byArray[n3] != 47) continue;
            while (n3 + 1 < n && byArray[n3 + 1] == 47) {
                CoyoteAdapter.copyBytes(byArray, n3, n3 + 1, n - n3 - 1);
                --n;
            }
        }
        if (n - n2 >= 2 && byArray[n - 1] == 46 && (byArray[n - 2] == 47 || byArray[n - 2] == 46 && byArray[n - 3] == 47)) {
            byArray[n] = 47;
            ++n;
        }
        byteChunk.setEnd(n);
        n4 = 0;
        while ((n4 = byteChunk.indexOf("/./", 0, 3, n4)) >= 0) {
            CoyoteAdapter.copyBytes(byArray, n2 + n4, n2 + n4 + 2, n - n2 - n4 - 2);
            byteChunk.setEnd(n -= 2);
        }
        n4 = 0;
        while ((n4 = byteChunk.indexOf("/../", 0, 4, n4)) >= 0) {
            if (n4 == 0) {
                return false;
            }
            int n5 = -1;
            for (n3 = n2 + n4 - 1; n3 >= 0 && n5 < 0; --n3) {
                if (byArray[n3] != 47) continue;
                n5 = n3;
            }
            CoyoteAdapter.copyBytes(byArray, n2 + n5, n2 + n4 + 3, n - n2 - n4 - 3);
            n = n + n5 - n4 - 3;
            byteChunk.setEnd(n);
            n4 = n5;
        }
        return true;
    }

    @Deprecated
    public static boolean checkNormalize(MessageBytes messageBytes) {
        CharChunk charChunk = messageBytes.getCharChunk();
        char[] cArray = charChunk.getChars();
        int n = charChunk.getStart();
        int n2 = charChunk.getEnd();
        int n3 = 0;
        for (n3 = n; n3 < n2; ++n3) {
            if (cArray[n3] == '\\') {
                return false;
            }
            if (cArray[n3] != '\u0000') continue;
            return false;
        }
        for (n3 = n; n3 < n2 - 1; ++n3) {
            if (cArray[n3] != '/' || cArray[n3 + 1] != '/') continue;
            return false;
        }
        if (n2 - n >= 2 && cArray[n2 - 1] == '.' && (cArray[n2 - 2] == '/' || cArray[n2 - 2] == '.' && cArray[n2 - 3] == '/')) {
            return false;
        }
        if (charChunk.indexOf("/./", 0, 3, 0) >= 0) {
            return false;
        }
        return charChunk.indexOf("/../", 0, 4, 0) < 0;
    }

    protected static void copyBytes(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n2, byArray, n, n3);
    }

    private static class RecycleRequiredException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private RecycleRequiredException() {
        }
    }
}

