/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.profiler.Bundle;
import com.sun.tools.visualvm.profiler.ProfilingResultsSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.jdbc.LiveJDBCView;
import org.netbeans.lib.profiler.ui.jdbc.LiveJDBCViewUpdater;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

class JDBCLivePanel
extends ProfilingResultsSupport.ResultsView {
    private ProfilerToolbar toolbar;
    private LiveJDBCView jdbcView;
    private LiveJDBCViewUpdater updater;
    private ProfilingResultsSupport.ResultsResetter resetter;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private JLabel pdLabel;
    private JButton pdSnapshotButton;
    private JButton pdResetResultsButton;
    private boolean popupPause;

    JDBCLivePanel(Application application) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.initUI(application);
        this.add((Component)this.toolbar.getComponent(), "North");
        this.add((Component)this.jdbcView, "Center");
    }

    void refreshResults() {
        this.refreshResults(false);
    }

    void resetResults() {
        if (this.lrDeltasButton != null) {
            this.lrDeltasButton.setSelected(false);
            this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        }
        if (this.jdbcView != null) {
            this.jdbcView.resetData();
            this.jdbcView.setDiffView(false);
        }
    }

    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
    }

    private void refreshResults(final boolean forceRefresh) {
        RESULTS_PROCESSOR.post(new Runnable(){

            public void run() {
                block5: {
                    try {
                        if (JDBCLivePanel.this.updater != null) {
                            if (forceRefresh) {
                                JDBCLivePanel.this.updater.setForceRefresh(true);
                            }
                            JDBCLivePanel.this.updater.update();
                        }
                    }
                    catch (Throwable t) {
                        if (JDBCLivePanel.this.updater != null) {
                            JDBCLivePanel.this.updater.cleanup();
                            JDBCLivePanel.this.updater = null;
                        }
                        if (JDBCLivePanel.this.resetter == null) break block5;
                        JDBCLivePanel.this.resetter.unregisterView(JDBCLivePanel.this);
                        JDBCLivePanel.this.resetter = null;
                    }
                }
            }
        });
    }

    private void initUI(Application application) {
        assert (SwingUtilities.isEventDispatchThread());
        this.jdbcView = new LiveJDBCView(null){

            protected boolean showSourceSupported() {
                return GoToSource.isAvailable();
            }

            protected boolean profileMethodSupported() {
                return false;
            }

            protected boolean profileClassSupported() {
                return false;
            }

            protected void showSource(ClientUtils.SourceCodeSelection value) {
                Lookup.Provider project = null;
                String className = value.getClassName();
                String methodName = value.getMethodName();
                String methodSig = value.getMethodSignature();
                GoToSource.openSource(project, (String)className, (String)methodName, (String)methodSig);
            }

            protected void selectForProfiling(ClientUtils.SourceCodeSelection value) {
            }

            protected void popupShowing() {
                if (JDBCLivePanel.this.lrPauseButton.isEnabled() && !JDBCLivePanel.this.lrRefreshButton.isEnabled()) {
                    JDBCLivePanel.this.popupPause = true;
                    JDBCLivePanel.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (JDBCLivePanel.this.lrPauseButton.isEnabled() && JDBCLivePanel.this.popupPause) {
                    JDBCLivePanel.this.popupPause = false;
                    JDBCLivePanel.this.lrPauseButton.setSelected(false);
                }
            }

            protected ProfilerClient getProfilerClient() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            protected void showSQLQuery(String query, String htmlQuery) {
                HTMLTextArea area = new HTMLTextArea(htmlQuery);
                JScrollPane areaScroll = new JScrollPane((Component)area);
                areaScroll.setPreferredSize(new Dimension(500, 250));
                JLabel label = new JLabel(Bundle.JDBCLivePanel_SqlQueryLabel(), 10);
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                label.setLabelFor((Component)area);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)label, "North");
                panel.add((Component)areaScroll, "Center");
                panel.setBorder(BorderFactory.createEmptyBorder(12, 10, 0, 10));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)panel, Bundle.JDBCLivePanel_SqlQueryCaption(), false, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null));
            }
        };
        this.jdbcView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileMethods.HelpCtx");
        this.jdbcView.putClientProperty((Object)"profiled_application", (Object)application);
        this.updater = new LiveJDBCViewUpdater(this.jdbcView, Profiler.getDefault().getTargetAppRunner().getProfilerClient());
        this.resetter = ProfilingResultsSupport.ResultsResetter.registerView(this);
        this.lrLabel = new GrayLabel(Bundle.MethodsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                JDBCLivePanel.this.updater.setPaused(paused);
                JDBCLivePanel.this.lrRefreshButton.setEnabled(paused && !JDBCLivePanel.this.popupPause);
                if (!paused) {
                    JDBCLivePanel.this.refreshResults(true);
                }
            }
        };
        this.lrPauseButton.setToolTipText(Bundle.MethodsFeatureUI_pauseResults());
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            protected void fireActionPerformed(ActionEvent e) {
                JDBCLivePanel.this.refreshResults(true);
            }
        };
        this.lrRefreshButton.setToolTipText(Bundle.MethodsFeatureUI_updateResults());
        this.lrRefreshButton.setEnabled(false);
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            protected void fireActionPerformed(ActionEvent e) {
                if (!JDBCLivePanel.this.jdbcView.setDiffView(this.isSelected())) {
                    this.setSelected(false);
                }
                this.setToolTipText(this.isSelected() ? Bundle.MethodsFeatureUI_showAbsolute() : Bundle.MethodsFeatureUI_showDeltas());
            }
        };
        this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        this.pdLabel = new GrayLabel(Bundle.MethodsFeatureUI_profilingData());
        this.pdSnapshotButton = new JButton((Action)TakeSnapshotAction.getInstance());
        this.pdSnapshotButton.setText(Bundle.MethodsFeatureUI_snapshot());
        this.pdResetResultsButton = new JButton((Action)ResetResultsAction.getInstance());
        this.pdResetResultsButton.setHideActionText(true);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.pdLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.pdSnapshotButton);
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)this.pdResetResultsButton);
    }

    private void refreshToolbar(final int state) {
        if (this.toolbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean running = state == 4;
                    JDBCLivePanel.this.lrPauseButton.setEnabled(running);
                    JDBCLivePanel.this.lrRefreshButton.setEnabled(!JDBCLivePanel.this.popupPause && running && JDBCLivePanel.this.lrPauseButton.isSelected());
                    JDBCLivePanel.this.lrDeltasButton.setEnabled(running);
                }
            });
        }
    }
}

