/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.plaf.basic.BasicMonthViewUI;
import org.jdesktop.swingx.plaf.basic.CalendarState;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class SubstanceMonthViewUI
extends BasicMonthViewUI
implements TransitionAwareUI {
    protected Set lafWidgets;
    protected DayRolloverFadeListener substanceFadeRolloverListener;
    protected DateId rolloverDateId;
    protected Set<DateId> selectedDates;
    protected DateSelectionListener substanceFadeSelectionListener;
    private StateTransitionMultiTracker<DateId> dayStateTransitionMultiTracker = new StateTransitionMultiTracker();
    private StateTransitionMultiTracker<MonthId> monthStateTransitionMultiTracker = new StateTransitionMultiTracker();

    protected void __org__pushingpixels__substance__swingx__SubstanceMonthViewUI__installComponents() {
        super.installComponents();
    }

    protected void installComponents() {
        this.__org__pushingpixels__substance__swingx__SubstanceMonthViewUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__pushingpixels__substance__swingx__SubstanceMonthViewUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceMonthViewUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__swingx__SubstanceMonthViewUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__swingx__SubstanceMonthViewUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void installListeners() {
        this.__org__pushingpixels__substance__swingx__SubstanceMonthViewUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void installDefaults() {
        this.__org__pushingpixels__substance__swingx__SubstanceMonthViewUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceMonthViewUI__uninstallComponents() {
        super.uninstallComponents();
    }

    protected void uninstallComponents() {
        this.__org__pushingpixels__substance__swingx__SubstanceMonthViewUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__swingx__SubstanceMonthViewUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__swingx__SubstanceMonthViewUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceMonthViewUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceMonthViewUI();
    }

    public SubstanceMonthViewUI() {
        this.selectedDates = new HashSet<DateId>();
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceMonthViewUI__installDefaults() {
        super.installDefaults();
        BasicLookAndFeel.installColors((JComponent)this.monthView, "JXMonthView.background", "JXMonthView.foreground");
        Calendar cal = this.monthView.getCalendar();
        if (cal != null) {
            for (Date selected : this.getSelection()) {
                cal.setTime(selected);
                int day = cal.get(5);
                int month = cal.get(2);
                int year = cal.get(1);
                this.selectedDates.add(new DateId(day, month, year));
            }
        }
    }

    protected void installDelegate() {
        super.installDelegate();
        this.monthDownImage = SubstanceImageCreator.getArrowIcon((int)this.monthView.getFont().getSize(), (int)7, (SubstanceColorScheme)SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.MARK, (ComponentState)ComponentState.ENABLED));
        this.monthUpImage = SubstanceImageCreator.getArrowIcon((int)this.monthView.getFont().getSize(), (int)3, (SubstanceColorScheme)SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.MARK, (ComponentState)ComponentState.ENABLED));
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceMonthViewUI__installListeners() {
        super.installListeners();
        this.substanceFadeRolloverListener = new DayRolloverFadeListener();
        this.monthView.addMouseMotionListener((MouseMotionListener)this.substanceFadeRolloverListener);
        this.monthView.addMouseListener((MouseListener)this.substanceFadeRolloverListener);
        this.substanceFadeSelectionListener = new DateSelectionListener(){

            public void valueChanged(DateSelectionEvent ev) {
                boolean hasSelectionAnimations = !LafWidgetUtilities.hasNoAnimations((Component)SubstanceMonthViewUI.this.monthView, (AnimationFacet)AnimationFacet.SELECTION);
                Calendar cal = SubstanceMonthViewUI.this.monthView.getCalendar();
                DateSelectionModel selectionModel = SubstanceMonthViewUI.this.monthView.getSelectionModel();
                Iterator<DateId> selIt = SubstanceMonthViewUI.this.selectedDates.iterator();
                while (selIt.hasNext()) {
                    DateId currSelected = selIt.next();
                    cal.set(5, currSelected.day);
                    cal.set(2, currSelected.month);
                    cal.set(1, currSelected.year);
                    if (selectionModel.isSelected(cal.getTime())) continue;
                    if (hasSelectionAnimations) {
                        StateTransitionTracker tracker = SubstanceMonthViewUI.this.getDayTracker(currSelected, SubstanceMonthViewUI.this.getDayState(currSelected.day, currSelected.month, currSelected.year).isFacetActive(ComponentStateFacet.ROLLOVER), true);
                        tracker.getModel().setSelected(false);
                    }
                    selIt.remove();
                }
                for (Date newlySelected : selectionModel.getSelection()) {
                    cal.setTime(newlySelected);
                    DateId newlySelectedDate = new DateId(cal.get(5), cal.get(2), cal.get(1));
                    if (SubstanceMonthViewUI.this.selectedDates.contains(newlySelectedDate)) continue;
                    if (hasSelectionAnimations) {
                        StateTransitionTracker tracker = SubstanceMonthViewUI.this.getDayTracker(newlySelectedDate, SubstanceMonthViewUI.this.getDayState(newlySelectedDate.day, newlySelectedDate.month, newlySelectedDate.year).isFacetActive(ComponentStateFacet.ROLLOVER), false);
                        tracker.getModel().setSelected(true);
                    }
                    SubstanceMonthViewUI.this.selectedDates.add(newlySelectedDate);
                }
            }
        };
        this.monthView.getSelectionModel().addDateSelectionListener(this.substanceFadeSelectionListener);
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceMonthViewUI__uninstallListeners() {
        this.monthView.getSelectionModel().removeDateSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeSelectionListener = null;
        this.monthView.removeMouseListener((MouseListener)this.substanceFadeRolloverListener);
        this.monthView.removeMouseMotionListener((MouseMotionListener)this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        super.uninstallListeners();
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceMonthViewUI__uninstallDefaults() {
        this.selectedDates.clear();
        super.uninstallDefaults();
    }

    public boolean isInside(MouseEvent me) {
        return true;
    }

    public StateTransitionTracker getTransitionTracker() {
        return null;
    }

    private ComponentState getDayState(int dayIndex, int monthIndex, int yearIndex) {
        DateId dateId = new DateId(dayIndex, monthIndex, yearIndex);
        boolean isEnabled = this.monthView.isEnabled();
        StateTransitionTracker tracker = this.dayStateTransitionMultiTracker.getTracker((Comparable)dateId);
        if (tracker == null) {
            boolean isRollover = dateId.equals(this.rolloverDateId);
            boolean isSelected = this.selectedDates.contains(dateId);
            return ComponentState.getState((boolean)isEnabled, (boolean)isRollover, (boolean)isSelected);
        }
        ComponentState fromTracker = tracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState((boolean)isEnabled, (boolean)fromTracker.isFacetActive(ComponentStateFacet.ROLLOVER), (boolean)fromTracker.isFacetActive(ComponentStateFacet.SELECTION));
    }

    private ComponentState getMonthState(int monthIndex, int yearIndex) {
        MonthId monthId = new MonthId(monthIndex, yearIndex);
        boolean isEnabled = this.monthView.isEnabled();
        StateTransitionTracker tracker = this.monthStateTransitionMultiTracker.getTracker((Comparable)monthId);
        if (tracker == null) {
            boolean isRollover = this.rolloverDateId != null && this.rolloverDateId.month == monthIndex && this.rolloverDateId.year == yearIndex;
            return ComponentState.getState((boolean)isEnabled, (boolean)isRollover, (boolean)false);
        }
        ComponentState fromTracker = tracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState((boolean)isEnabled, (boolean)fromTracker.isFacetActive(ComponentStateFacet.ROLLOVER), (boolean)fromTracker.isFacetActive(ComponentStateFacet.SELECTION));
    }

    public void resetRolloverIndex() {
        this.rolloverDateId = null;
    }

    protected BasicMonthViewUI.RenderingHandler createRenderingHandler() {
        return new SubstanceRenderingHandler();
    }

    protected void paintMonthHeader(Graphics g, Calendar calendar) {
        ComponentState currState;
        Rectangle page = this.getMonthHeaderBounds(calendar.getTime(), false);
        int month = calendar.get(2);
        int year = calendar.get(1);
        Graphics2D g2d = (Graphics2D)g.create();
        ComponentState componentState = this.monthView.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        float fillAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.monthView, (ComponentState)componentState);
        g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.monthView, (float)fillAlpha, (Graphics)g));
        SubstanceColorScheme bgFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)componentState);
        SubstanceColorScheme bgBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)componentState);
        HighlightPainterUtils.paintHighlight((Graphics)g2d, null, (Component)this.monthView, (Rectangle)page, (float)0.5f, null, (SubstanceColorScheme)bgFillScheme, (SubstanceColorScheme)bgBorderScheme);
        g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.monthView, (Graphics)g));
        StateTransitionTracker monthTracker = this.monthStateTransitionMultiTracker.getTracker((Comparable)new MonthId(month, year));
        StateTransitionTracker.ModelStateInfo modelStateInfo = monthTracker == null ? null : monthTracker.getModelStateInfo();
        Map activeStates = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState componentState2 = currState = modelStateInfo == null ? this.getMonthState(month, year) : modelStateInfo.getCurrModelState();
        if (activeStates == null) {
            SubstanceColorScheme currFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
            SubstanceColorScheme currBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)currState);
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.monthView, (float)SubstanceColorSchemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)currState), (Graphics)g));
            HighlightPainterUtils.paintHighlight((Graphics)g2d, null, (Component)this.monthView, (Rectangle)page, (float)0.5f, null, (SubstanceColorScheme)currFillScheme, (SubstanceColorScheme)currBorderScheme);
        } else {
            for (Map.Entry activeEntry : activeStates.entrySet()) {
                float contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                if (contribution == 0.0f) continue;
                ComponentState activeState = (ComponentState)activeEntry.getKey();
                SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)activeState);
                SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)activeState);
                g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.monthView, (float)(SubstanceColorSchemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)activeState) * contribution), (Graphics)g));
                HighlightPainterUtils.paintHighlight((Graphics)g2d, null, (Component)this.monthView, (Rectangle)page, (float)0.5f, null, (SubstanceColorScheme)fillScheme, (SubstanceColorScheme)borderScheme);
            }
        }
        g2d.dispose();
        super.paintMonthHeader(g, calendar);
    }

    protected void paintDayOfMonth(Graphics g, Rectangle bounds, Calendar calendar, CalendarState state) {
        if (state == CalendarState.IN_MONTH || state == CalendarState.TODAY) {
            ComponentState currState;
            StateTransitionTracker dayTracker;
            Graphics2D graphics = (Graphics2D)g.create();
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            if (this.isToday(calendar.getTime())) {
                graphics.setColor(this.monthView.getTodayBackground());
                graphics.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
            StateTransitionTracker.ModelStateInfo modelStateInfo = (dayTracker = this.dayStateTransitionMultiTracker.getTracker((Comparable)new DateId(day, month, year))) == null ? null : dayTracker.getModelStateInfo();
            Map activeStates = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
            ComponentState componentState = currState = modelStateInfo == null ? this.getDayState(day, month, year) : modelStateInfo.getCurrModelState();
            if (activeStates == null) {
                SubstanceColorScheme currFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
                SubstanceColorScheme currBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)currState);
                graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.monthView, (float)SubstanceColorSchemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)currState), (Graphics)g));
                HighlightPainterUtils.paintHighlight((Graphics)graphics, null, (Component)this.monthView, (Rectangle)bounds, (float)0.5f, null, (SubstanceColorScheme)currFillScheme, (SubstanceColorScheme)currBorderScheme);
            } else {
                for (Map.Entry activeEntry : activeStates.entrySet()) {
                    float contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                    if (contribution == 0.0f) continue;
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)activeState);
                    SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)activeState);
                    graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.monthView, (float)(SubstanceColorSchemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)activeState) * contribution), (Graphics)g));
                    HighlightPainterUtils.paintHighlight((Graphics)graphics, null, (Component)this.monthView, (Rectangle)bounds, (float)0.5f, null, (SubstanceColorScheme)fillScheme, (SubstanceColorScheme)borderScheme);
                }
            }
            graphics.dispose();
        }
        super.paintDayOfMonth(g, bounds, calendar, state);
    }

    public void __org__pushingpixels__substance__swingx__SubstanceMonthViewUI__update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.update((Graphics)g, (Component)this.monthView, (boolean)false);
        this.paint(g, c);
    }

    private static SubstanceColorScheme getColorSchemeForState(JXMonthView monthView, ComponentState state) {
        if (state == ComponentState.ENABLED) {
            return SubstanceColorSchemeUtilities.getColorScheme((Component)monthView, (ComponentState)state);
        }
        return SubstanceColorSchemeUtilities.getColorScheme((Component)monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)state);
    }

    private StateTransitionTracker getDayTracker(final DateId dateId, boolean initialRollover, boolean initialSelected) {
        StateTransitionTracker tracker = this.dayStateTransitionMultiTracker.getTracker((Comparable)dateId);
        if (tracker == null) {
            DefaultButtonModel model = new DefaultButtonModel();
            model.setSelected(initialSelected);
            model.setRollover(initialRollover);
            tracker = new StateTransitionTracker((JComponent)this.monthView, (ButtonModel)model);
            tracker.registerModelListeners();
            tracker.setRepaintCallback(new StateTransitionTracker.RepaintCallback(){

                public TimelineCallback getRepaintCallback() {
                    return new DayRepaintCallback(SubstanceMonthViewUI.this.monthView, dateId.day, dateId.month, dateId.year);
                }
            });
            this.dayStateTransitionMultiTracker.addTracker((Comparable)dateId, tracker);
        }
        return tracker;
    }

    private StateTransitionTracker getMonthTracker(final MonthId monthId, boolean initialRollover, boolean initialSelected) {
        StateTransitionTracker tracker = this.monthStateTransitionMultiTracker.getTracker((Comparable)monthId);
        if (tracker == null) {
            DefaultButtonModel model = new DefaultButtonModel();
            model.setSelected(initialSelected);
            model.setRollover(initialRollover);
            tracker = new StateTransitionTracker((JComponent)this.monthView, (ButtonModel)model);
            tracker.registerModelListeners();
            tracker.setRepaintCallback(new StateTransitionTracker.RepaintCallback(){

                public TimelineCallback getRepaintCallback() {
                    return new MonthRepaintCallback(SubstanceMonthViewUI.this.monthView, monthId.month, monthId.year);
                }
            });
            this.monthStateTransitionMultiTracker.addTracker((Comparable)monthId, tracker);
        }
        return tracker;
    }

    protected class SubstanceRenderingHandler
    extends BasicMonthViewUI.RenderingHandler {
        protected SubstanceRenderingHandler() {
        }

        public JComponent prepareRenderingComponent(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
            JComponent result = super.prepareRenderingComponent(monthView, calendar, dayState);
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            if (dayState == CalendarState.IN_MONTH || dayState == CalendarState.TODAY) {
                Color customFgColor = result.getForeground();
                boolean isForegroundUiResource = customFgColor instanceof UIResource;
                Color fgColor = customFgColor;
                if (isForegroundUiResource) {
                    if (monthView.isEnabled()) {
                        StateTransitionTracker dayTracker = SubstanceMonthViewUI.this.dayStateTransitionMultiTracker.getTracker((Comparable)new DateId(day, month, year));
                        StateTransitionTracker.ModelStateInfo modelStateInfo = dayTracker == null ? null : dayTracker.getModelStateInfo();
                        Map activeStates = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
                        ComponentState currState = modelStateInfo == null ? SubstanceMonthViewUI.this.getDayState(day, month, year) : modelStateInfo.getCurrModelState();
                        SubstanceColorScheme colorScheme = SubstanceMonthViewUI.getColorSchemeForState(monthView, currState);
                        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                            fgColor = colorScheme.getForegroundColor();
                        } else {
                            float aggrRed = 0.0f;
                            float aggrGreen = 0.0f;
                            float aggrBlue = 0.0f;
                            for (Map.Entry activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                                ComponentState activeState = (ComponentState)activeEntry.getKey();
                                SubstanceColorScheme scheme = SubstanceMonthViewUI.getColorSchemeForState(monthView, activeState);
                                Color schemeFg = scheme.getForegroundColor();
                                float contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                                aggrRed += (float)schemeFg.getRed() * contribution;
                                aggrGreen += (float)schemeFg.getGreen() * contribution;
                                aggrBlue += (float)schemeFg.getBlue() * contribution;
                            }
                            fgColor = new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
                        }
                    } else {
                        float textAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)monthView, (ComponentState)ComponentState.DISABLED_UNSELECTED);
                        fgColor = SubstanceTextUtilities.getForegroundColor((JComponent)monthView, (String)" ", (ComponentState)ComponentState.DISABLED_UNSELECTED, (float)textAlpha);
                    }
                }
                result.setForeground(fgColor);
            }
            if (dayState == CalendarState.TITLE) {
                StateTransitionTracker monthTracker = SubstanceMonthViewUI.this.monthStateTransitionMultiTracker.getTracker((Comparable)new MonthId(month, year));
                StateTransitionTracker.ModelStateInfo modelStateInfo = monthTracker == null ? null : monthTracker.getModelStateInfo();
                Map activeStates = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
                ComponentState currState = modelStateInfo == null ? SubstanceMonthViewUI.this.getMonthState(month, year) : modelStateInfo.getCurrModelState();
                SubstanceColorScheme colorScheme = SubstanceMonthViewUI.getColorSchemeForState(monthView, currState);
                Color fgColor = null;
                if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                    fgColor = colorScheme.getForegroundColor();
                } else {
                    float aggrRed = 0.0f;
                    float aggrGreen = 0.0f;
                    float aggrBlue = 0.0f;
                    for (Map.Entry activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState activeState = (ComponentState)activeEntry.getKey();
                        SubstanceColorScheme scheme = SubstanceMonthViewUI.getColorSchemeForState(monthView, activeState);
                        Color schemeFg = scheme.getForegroundColor();
                        float contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                        aggrRed += (float)schemeFg.getRed() * contribution;
                        aggrGreen += (float)schemeFg.getGreen() * contribution;
                        aggrBlue += (float)schemeFg.getBlue() * contribution;
                    }
                    fgColor = new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
                }
                result.setForeground(fgColor);
            }
            if (dayState == CalendarState.LEADING || dayState == CalendarState.TRAILING) {
                float textAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)monthView, (ComponentState)ComponentState.DISABLED_UNSELECTED);
                result.setForeground(SubstanceTextUtilities.getForegroundColor((JComponent)monthView, (String)" ", (ComponentState)ComponentState.DISABLED_UNSELECTED, (float)textAlpha));
            }
            if (dayState == CalendarState.TITLE) {
                result.setBorder(this.getTitleBorder());
            }
            result.setOpaque(false);
            return result;
        }

        private Border getTitleBorder() {
            if (SubstanceMonthViewUI.this.monthView.isTraversable()) {
                IconBorder up = new IconBorder(SubstanceMonthViewUI.this.monthUpImage, 3, SubstanceMonthViewUI.this.monthView.getBoxPaddingX());
                IconBorder down = new IconBorder(SubstanceMonthViewUI.this.monthDownImage, 7, SubstanceMonthViewUI.this.monthView.getBoxPaddingX());
                CompoundBorder compound = BorderFactory.createCompoundBorder((Border)up, (Border)down);
                Border empty = BorderFactory.createEmptyBorder(2 * SubstanceMonthViewUI.this.monthView.getBoxPaddingY(), 0, 2 * SubstanceMonthViewUI.this.monthView.getBoxPaddingY(), 0);
                return BorderFactory.createCompoundBorder(compound, empty);
            }
            return BorderFactory.createEmptyBorder(SubstanceMonthViewUI.this.monthView.getBoxPaddingY(), SubstanceMonthViewUI.this.monthView.getBoxPaddingX(), SubstanceMonthViewUI.this.monthView.getBoxPaddingY(), SubstanceMonthViewUI.this.monthView.getBoxPaddingX());
        }
    }

    protected class DayRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JXMonthView monthView;
        protected int dayIndex;
        protected int monthIndex;
        protected int yearIndex;

        public DayRepaintCallback(JXMonthView monthView, int dayIndex, int monthIndex, int yearIndex) {
            this.monthView = monthView;
            this.dayIndex = dayIndex;
            this.monthIndex = monthIndex;
            this.yearIndex = yearIndex;
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DayRepaintCallback.this.monthView != SubstanceMonthViewUI.this.monthView) {
                        return;
                    }
                    Calendar cal = DayRepaintCallback.this.monthView.getCalendar();
                    cal.set(5, DayRepaintCallback.this.dayIndex);
                    cal.set(2, DayRepaintCallback.this.monthIndex);
                    cal.set(1, DayRepaintCallback.this.yearIndex);
                    Rectangle dayBounds = SubstanceMonthViewUI.this.getDayBounds(cal.getTime());
                    if (dayBounds != null) {
                        DayRepaintCallback.this.monthView.repaint(dayBounds);
                    }
                }
            });
        }
    }

    protected class MonthRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JXMonthView monthView;
        protected int monthIndex;
        protected int yearIndex;

        public MonthRepaintCallback(JXMonthView monthView, int monthIndex, int yearIndex) {
            this.monthView = monthView;
            this.monthIndex = monthIndex;
            this.yearIndex = yearIndex;
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MonthRepaintCallback.this.monthView != SubstanceMonthViewUI.this.monthView) {
                        return;
                    }
                    Calendar cal = MonthRepaintCallback.this.monthView.getCalendar();
                    cal.set(2, MonthRepaintCallback.this.monthIndex);
                    cal.set(1, MonthRepaintCallback.this.yearIndex);
                    Rectangle monthBounds = SubstanceMonthViewUI.this.getMonthBounds(cal.getTime());
                    if (monthBounds != null) {
                        MonthRepaintCallback.this.monthView.repaint(monthBounds);
                    }
                }
            });
        }
    }

    private class DayRolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private DayRolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.fadeOutDay();
            this.fadeOutMonth();
            SubstanceMonthViewUI.this.resetRolloverIndex();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!SubstanceMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SubstanceMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            boolean fadeAllowed = AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView);
            if (!fadeAllowed) {
                this.fadeOutDay();
                this.fadeOutMonth();
                SubstanceMonthViewUI.this.resetRolloverIndex();
                return;
            }
            Date matchingDay = SubstanceMonthViewUI.this.monthView.getDayAtLocation(e.getX(), e.getY());
            if (matchingDay == null) {
                this.fadeOutDay();
                this.fadeOutMonth();
                SubstanceMonthViewUI.this.resetRolloverIndex();
            } else {
                Rectangle monthBounds = SubstanceMonthViewUI.this.getMonthBounds(matchingDay);
                if (monthBounds == null || !monthBounds.contains(e.getPoint())) {
                    this.fadeOutDay();
                    this.fadeOutMonth();
                    SubstanceMonthViewUI.this.resetRolloverIndex();
                } else {
                    boolean isDifferentMonth;
                    Calendar cal = SubstanceMonthViewUI.this.monthView.getCalendar();
                    cal.setTime(matchingDay);
                    int roIndexDay = cal.get(5);
                    int roIndexMonth = cal.get(2);
                    int roIndexYear = cal.get(1);
                    DateId dateId = new DateId(roIndexDay, roIndexMonth, roIndexYear);
                    if (dateId.equals(SubstanceMonthViewUI.this.rolloverDateId)) {
                        return;
                    }
                    this.fadeOutDay();
                    boolean bl = isDifferentMonth = SubstanceMonthViewUI.this.rolloverDateId == null || SubstanceMonthViewUI.this.rolloverDateId.month != roIndexMonth || SubstanceMonthViewUI.this.rolloverDateId.year != roIndexYear;
                    if (isDifferentMonth) {
                        this.fadeOutMonth();
                    }
                    SubstanceMonthViewUI.this.rolloverDateId = dateId;
                    StateTransitionTracker dayTracker = SubstanceMonthViewUI.this.getDayTracker(dateId, false, SubstanceMonthViewUI.this.getDayState(roIndexDay, roIndexMonth, roIndexYear).isFacetActive(ComponentStateFacet.SELECTION));
                    dayTracker.getModel().setRollover(true);
                    if (isDifferentMonth) {
                        StateTransitionTracker monthTracker = SubstanceMonthViewUI.this.getMonthTracker(new MonthId(roIndexMonth, roIndexYear), false, SubstanceMonthViewUI.this.getMonthState(roIndexMonth, roIndexYear).isFacetActive(ComponentStateFacet.SELECTION));
                        monthTracker.getModel().setRollover(true);
                    }
                }
            }
        }

        private void fadeOutDay() {
            if (SubstanceMonthViewUI.this.rolloverDateId == null) {
                return;
            }
            StateTransitionTracker tracker = SubstanceMonthViewUI.this.getDayTracker(SubstanceMonthViewUI.this.rolloverDateId, true, SubstanceMonthViewUI.this.getDayState(SubstanceMonthViewUI.this.rolloverDateId.day, SubstanceMonthViewUI.this.rolloverDateId.month, SubstanceMonthViewUI.this.rolloverDateId.year).isFacetActive(ComponentStateFacet.SELECTION));
            tracker.getModel().setRollover(false);
        }

        private void fadeOutMonth() {
            if (SubstanceMonthViewUI.this.rolloverDateId == null) {
                return;
            }
            StateTransitionTracker tracker = SubstanceMonthViewUI.this.getMonthTracker(new MonthId(SubstanceMonthViewUI.this.rolloverDateId.month, SubstanceMonthViewUI.this.rolloverDateId.year), true, SubstanceMonthViewUI.this.getMonthState(SubstanceMonthViewUI.this.rolloverDateId.month, SubstanceMonthViewUI.this.rolloverDateId.year).isFacetActive(ComponentStateFacet.SELECTION));
            tracker.getModel().setRollover(false);
        }
    }

    static class MonthId
    implements Comparable<MonthId> {
        protected int month;
        protected int year;

        public MonthId(int month, int year) {
            this.month = month;
            this.year = year;
        }

        @Override
        public int compareTo(MonthId o) {
            if (this.month == o.month && this.year == o.year) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MonthId) {
                return this.compareTo((MonthId)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            return (this.month ^ this.month >>> 32) & (this.year ^ this.year >>> 32);
        }

        public String toString() {
            return "Month " + this.month + ", Year " + this.year;
        }
    }

    static class DateId
    implements Comparable<DateId> {
        protected int day;
        protected int month;
        protected int year;

        public DateId(int day, int month, int year) {
            this.day = day;
            this.month = month;
            this.year = year;
        }

        @Override
        public int compareTo(DateId o) {
            if (this.day == o.day && this.month == o.month && this.year == o.year) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DateId) {
                return this.compareTo((DateId)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            return (this.day ^ this.day >>> 32) & (this.month ^ this.month >>> 32) & (this.year ^ this.year >>> 32);
        }

        public String toString() {
            return "Day " + this.day + ", Month " + this.month + ", Year " + this.year;
        }
    }
}

