/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.search.AbstractSearchable;

public class TreeSearchable
extends AbstractSearchable {
    protected JXTree tree;

    public TreeSearchable(JXTree tree) {
        this.tree = tree;
    }

    protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
        AbstractSearchable.SearchResult searchResult = null;
        if (backwards) {
            for (int index = startRow; index >= 0 && searchResult == null; --index) {
                searchResult = this.findMatchAt(pattern, index);
            }
        } else {
            for (int index = startRow; index < this.getSize() && searchResult == null; ++index) {
                searchResult = this.findMatchAt(pattern, index);
            }
        }
        this.updateState(searchResult);
    }

    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
        return this.findMatchAt(pattern, row);
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row) {
        Matcher matcher;
        String text = this.tree.getStringAt(row);
        if (text != null && text.length() > 0 && (matcher = pattern.matcher(text)).find()) {
            return this.createSearchResult(matcher, row, 0);
        }
        return null;
    }

    protected int getSize() {
        return this.tree.getRowCount();
    }

    public JXTree getTarget() {
        return this.tree;
    }

    protected void moveMatchMarker() {
        if (this.markByHighlighter()) {
            this.moveMatchByHighlighter();
        } else {
            this.moveMatchBySelection();
        }
    }

    protected void moveMatchBySelection() {
        if (!this.hasMatch()) {
            return;
        }
        this.tree.setSelectionRow(this.lastSearchResult.foundRow);
        this.tree.scrollRowToVisible(this.lastSearchResult.foundRow);
    }

    protected void moveMatchByHighlighter() {
        AbstractHighlighter searchHL = this.getConfiguredMatchHighlighter();
        if (!this.hasMatch()) {
            return;
        }
        this.ensureInsertedSearchHighlighters(searchHL);
        this.tree.scrollRowToVisible(this.lastSearchResult.foundRow);
    }

    protected void removeHighlighter(Highlighter searchHighlighter) {
        this.tree.removeHighlighter(searchHighlighter);
    }

    protected Highlighter[] getHighlighters() {
        return this.tree.getHighlighters();
    }

    protected void addHighlighter(Highlighter highlighter) {
        this.tree.addHighlighter(highlighter);
    }
}

