/*
 * Decompiled with CFR 0.152.
 */
package esmska;

import esmska.CommandLineParser;
import esmska.Context;
import esmska.data.Config;
import esmska.data.CountryPrefix;
import esmska.gui.ExceptionDialog;
import esmska.gui.InitWizardDialog;
import esmska.gui.MainFrame;
import esmska.gui.ThemeManager;
import esmska.persistence.PersistenceManager;
import esmska.transfer.ProxyManager;
import esmska.update.LegacyUpdater;
import esmska.update.Statistics;
import esmska.utils.L10N;
import esmska.utils.LogSupport;
import esmska.utils.RuntimeUtils;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang.ArrayUtils;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static String configPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String programVersion;
        Config config;
        String dataVersion;
        CommandLineParser clp;
        LogSupport.init();
        LogSupport.storeRecords(true);
        Thread.setDefaultUncaughtExceptionHandler(ExceptionDialog.getExceptionHandler());
        System.setProperty("sun.awt.exception.handler", ExceptionDialog.AwtHandler.class.getName());
        if (!RuntimeUtils.isSupportedJava()) {
            logger.warning("You are probably running the program on an unsupported Java version! Program might not work correctly with it! The tested Java versions are: Oracle Java 6 and 7, OpenJDK 6 and 7, Apple Java 6 and 7.");
        }
        if (!(clp = new CommandLineParser()).parseArgs(args)) {
            System.exit(1);
        }
        logger.log(Level.FINE, "Esmska {0} starting...", Config.getLatestVersion());
        logger.log(Level.FINER, "System info: {0}", RuntimeUtils.getSystemInfo());
        configPath = clp.getConfigPath();
        if (clp.isPortable() && configPath == null) {
            logger.fine("Entering portable mode");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (Exception ex) {
                            logger.log(Level.WARNING, "Could not set system Look and Feel", ex);
                        }
                        JFileChooser chooser = new JFileChooser();
                        chooser.setFileSelectionMode(1);
                        chooser.setApproveButtonText(l10n.getString("Select"));
                        chooser.setDialogTitle(l10n.getString("Main.choose_config_files"));
                        chooser.setFileHidingEnabled(false);
                        chooser.setMultiSelectionEnabled(false);
                        int result = chooser.showOpenDialog(null);
                        if (result == 0) {
                            configPath = chooser.getSelectedFile().getPath();
                            logger.log(Level.CONFIG, "New config path: {0}", configPath);
                        }
                    }
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Can't display file chooser for portable mode", e);
            }
        }
        try {
            if (configPath != null) {
                PersistenceManager.setCustomDirs(configPath, configPath);
            }
            PersistenceManager.instantiate();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not create program dir or read config files", ex);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, new JLabel(MessageFormat.format(l10n.getString("Main.cant_read_config"), PersistenceManager.getConfigDir().getAbsolutePath(), PersistenceManager.getDataDir().getAbsolutePath())), null, 0);
                    }
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Can't display error message", e);
            }
            finally {
                System.exit(5);
            }
        }
        PersistenceManager pm = Context.persistenceManager;
        try {
            pm.backupConfigFiles();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not back up configuration", ex);
        }
        File logFile = pm.getLogFile();
        try {
            LogSupport.initFileHandler(logFile);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not start logging into " + logFile.getAbsolutePath(), ex);
        }
        finally {
            LogSupport.storeRecords(false);
        }
        try {
            pm.loadConfig();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not load config file", ex);
        }
        try {
            pm.loadContacts();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not load contacts file", ex);
        }
        try {
            pm.loadQueue();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not load queue file", ex);
        }
        try {
            pm.loadHistory();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not load history file", ex);
        }
        try {
            pm.loadKeyring();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not load keyring file", ex);
        }
        if (Config.getInstance().isDebugMode()) {
            LogSupport.enableHttpClientLogging();
            LogSupport.getEsmskaLogger().setLevel(Level.ALL);
        }
        if (!pm.isFirstInstance()) {
            logger.warning("Esmska is already running. Quitting.");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String quitOption = l10n.getString("Quit");
                        Object[] options = new String[]{quitOption};
                        JOptionPane.showOptionDialog(null, l10n.getString("Main.already_running"), null, -1, 2, null, options, quitOption);
                    }
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Can't display error message", e);
            }
            finally {
                System.exit(15);
            }
        }
        if (Config.compareProgramVersions(dataVersion = (config = Config.getInstance()).getVersion(), programVersion = Config.getLatestVersion()) > 0) {
            logger.log(Level.WARNING, "Configuration files are newer ({0}) then current program version ({1})! Data corruption may occur!", new Object[]{dataVersion, programVersion});
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String runOption = l10n.getString("Main.run_anyway");
                        String quitOption = l10n.getString("Quit");
                        Object[] options = new String[]{runOption, quitOption};
                        options = RuntimeUtils.sortDialogOptions(options);
                        int result = JOptionPane.showOptionDialog(null, new JLabel(MessageFormat.format(l10n.getString("Main.configsNewer"), dataVersion, programVersion)), null, -1, 2, null, options, quitOption);
                        if (result != ArrayUtils.indexOf(options, runOption)) {
                            System.exit(0);
                        }
                    }
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Can't display error message", e);
            }
        }
        if (config.isFirstRun()) {
            logger.fine("First run, doing initialization...");
            config.setCountryPrefix(CountryPrefix.getCountryPrefix(Locale.getDefault().getCountry()));
            config.setLookAndFeel(ThemeManager.suggestBestLAF());
            InitWizardDialog dialog = new InitWizardDialog(null, true);
            dialog.setVisible(true);
        }
        if (!config.isFirstRun()) {
            try {
                LegacyUpdater.update();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Updating to a newer version failed", ex);
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        ThemeManager.setLaF();
                    }
                    catch (Throwable ex) {
                        logger.log(Level.WARNING, "Could not set Look and Feel", ex);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Setting LaF interrupted", e);
        }
        if (config.isUseProxy()) {
            ProxyManager.setProxy(config.getHttpProxy(), config.getHttpsProxy(), config.getSocksProxy());
        }
        if (!Config.isStableVersion()) {
            config.setAnnounceUnstableUpdates(true);
        }
        Statistics.refreshUUID();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.instantiate();
                Context.mainFrame.startAndShow();
            }
        });
    }
}

