/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.Context;
import esmska.data.Config;
import esmska.data.Icons;
import esmska.gui.ClipboardPopupMenu;
import esmska.gui.JHtmlLabel;
import esmska.gui.MainFrame;
import esmska.gui.ThemeManager;
import esmska.utils.L10N;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;

public class ExceptionDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(ExceptionDialog.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final EsmskaExceptionHandler exceptionHandler = new EsmskaExceptionHandler();
    private static ExceptionDialog instance;
    private String logFilePath = "--";
    private JButton closeButton;
    private JButton copyButton;
    private JLabel detailsLabel;
    private JTextArea detailsTextArea;
    private JHtmlLabel errorLabel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    private ExceptionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        if (Context.persistenceManager != null) {
            this.logFilePath = Context.persistenceManager.getLogFile().getAbsolutePath();
        }
        this.initComponents();
        this.closeButton.requestFocusInWindow();
        this.getRootPane().setDefaultButton(this.closeButton);
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(Icons.get("error-16.png").getImage());
        images.add(Icons.get("error-22.png").getImage());
        images.add(Icons.get("error-32.png").getImage());
        images.add(Icons.get("error-48.png").getImage());
        this.setIconImages(images);
        String command = "close";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.closeButtonActionPerformed(e);
            }
        });
        if (!Config.getInstance().getLookAndFeel().equals((Object)ThemeManager.LAF.SUBSTANCE)) {
            ClipboardPopupMenu.register(this.detailsTextArea);
        }
        this.setLocationRelativeTo(this.getParent());
    }

    public static ExceptionDialog getInstance() {
        if (instance == null) {
            MainFrame parent = Context.mainFrame != null ? Context.mainFrame : null;
            instance = new ExceptionDialog((Frame)parent, true);
        }
        return instance;
    }

    public static Thread.UncaughtExceptionHandler getExceptionHandler() {
        return exceptionHandler;
    }

    public void setExceptionText(String traceback) {
        this.detailsTextArea.setText(traceback);
        this.detailsTextArea.setCaretPosition(0);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.closeButton = new JButton();
        this.jPanel1 = new JPanel();
        this.detailsLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.detailsTextArea = new JTextArea();
        this.copyButton = new JButton();
        this.errorLabel = new JHtmlLabel();
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/error-48.png")));
        this.jLabel1.setVerticalAlignment(1);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/close-22.png")));
        Mnemonics.setLocalizedText(this.closeButton, l10n.getString("Close_"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.detailsLabel.setFont(this.detailsLabel.getFont().deriveFont(this.detailsLabel.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText(this.detailsLabel, l10n.getString("ExceptionDialog.detailsLabel.text"));
        this.detailsTextArea.setEditable(false);
        this.detailsTextArea.setLineWrap(true);
        this.detailsTextArea.setTabSize(2);
        this.detailsTextArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.detailsTextArea);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.detailsLabel).addContainerGap(461, Short.MAX_VALUE)).addComponent(this.jScrollPane1));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.detailsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 171, Short.MAX_VALUE)));
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/copy-22.png")));
        Mnemonics.setLocalizedText(this.copyButton, l10n.getString("CopyToClipboard_"));
        this.copyButton.setToolTipText(l10n.getString("ExceptionDialog.copyButton.toolTipText"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionDialog.this.copyButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.errorLabel, MessageFormat.format(l10n.getString("UncaughtExceptionDialog.errorLabel"), "http://code.google.com/p/esmska/wiki/Issues", this.logFilePath));
        this.errorLabel.setVerticalAlignment(1);
        this.errorLabel.setVerticalTextPosition(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.errorLabel, -1, 450, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.copyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 265, Short.MAX_VALUE).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.errorLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.copyButton)).addContainerGap()));
        this.pack();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        try {
            logger.fine("Copying logs to clipboard");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection text = new StringSelection(this.detailsTextArea.getText());
            clipboard.setContents(text, null);
        }
        catch (IllegalStateException ex) {
            logger.log(Level.WARNING, "System clipboard not available", ex);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static class AwtHandler {
        public void handle(Throwable t) {
            exceptionHandler.uncaughtException(Thread.currentThread(), t);
        }
    }

    private static class EsmskaExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private static boolean dialogAlreadyShown = false;

        private EsmskaExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, final Throwable e) {
            StringWriter stringWr = new StringWriter();
            PrintWriter wr = new PrintWriter(stringWr);
            e.printStackTrace(wr);
            wr.close();
            final String traceback = stringWr.toString();
            logger.severe("Uncaught exception detected: " + traceback);
            if (SwingUtilities.isEventDispatchThread()) {
                this.displayDialog(e, traceback);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            EsmskaExceptionHandler.this.displayDialog(e, traceback);
                        }
                    });
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Could not show exception dialog", ex);
                }
            }
            if ("main".equals(Thread.currentThread().getName())) {
                logger.severe("Encountered uncaught exception at the main thread, exiting application...");
                System.exit(4);
            }
        }

        private boolean isRelatedToEsmska(Throwable e) {
            for (StackTraceElement ste : e.getStackTrace()) {
                if (!ste.getClassName().contains("esmska.")) continue;
                return true;
            }
            return false;
        }

        private void displayDialog(Throwable e, String traceback) {
            if (!this.isRelatedToEsmska(e)) {
                logger.fine("Exception not related to Esmska, not showing exception dialog...");
                return;
            }
            if (dialogAlreadyShown) {
                logger.fine("Exception dialog already shown once, skipping this time.");
                return;
            }
            dialogAlreadyShown = true;
            logger.fine("Showing exception dialog...");
            ExceptionDialog dialog = ExceptionDialog.getInstance();
            dialog.setExceptionText(traceback);
            dialog.setVisible(true);
        }
    }
}

