/*
 * Decompiled with CFR 0.152.
 */
package esmska.integration;

import esmska.data.Queue;
import esmska.data.SMS;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import esmska.integration.ActionBean;
import esmska.integration.WindowsIntegration;
import esmska.utils.RuntimeUtils;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import org.apache.commons.lang.StringUtils;

public class IntegrationAdapter {
    private static final Logger logger = Logger.getLogger(IntegrationAdapter.class.getName());
    private static IntegrationAdapter instance = null;
    protected ActionBean bean;

    protected IntegrationAdapter() {
    }

    public static IntegrationAdapter getInstance() {
        if (instance != null) {
            return instance;
        }
        switch (RuntimeUtils.detectOS()) {
            case MAC_OS_X: {
                try {
                    instance = (IntegrationAdapter)Class.forName("esmska.integration.mac.MacIntegration").newInstance();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Cannot set up integration for Mac OS X. Was the program compiled without Mac support?", e);
                    instance = new IntegrationAdapter();
                }
                break;
            }
            case WINDOWS: {
                instance = new WindowsIntegration();
                break;
            }
            default: {
                instance = new IntegrationAdapter();
            }
        }
        instance.initialize();
        instance.startUp();
        return instance;
    }

    protected void initialize() {
    }

    public void setActionBean(ActionBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException("Action bean must not be null.");
        }
        this.bean = bean;
    }

    public void setSMSCount(Integer count) {
    }

    public String getProgramDirName(String defaultProgramDirName) {
        return defaultProgramDirName;
    }

    public File getConfigDir(File defaultConfigDir) {
        String confDir = System.getenv("XDG_CONFIG_HOME");
        if (StringUtils.isNotEmpty(confDir)) {
            return new File(confDir);
        }
        return defaultConfigDir;
    }

    public File getDataDir(File defaultDataDir) {
        String datDir = System.getenv("XDG_DATA_HOME");
        if (StringUtils.isNotEmpty(datDir)) {
            return new File(datDir);
        }
        return defaultDataDir;
    }

    public File getGatewayDir(File defaultDir) {
        return defaultDir;
    }

    public File getLogFile(File defaultLogFile) {
        return defaultLogFile;
    }

    public void activateGUI() {
    }

    public void registerModalSheet(JDialog dialog) {
    }

    public boolean isModalSheetVisible() {
        return false;
    }

    private void startUp() {
        this.setSMSCount(Queue.getInstance().size());
        Queue.getInstance().addValuedListener(new ValuedListener<Queue.Events, SMS>(){

            @Override
            public void eventOccured(ValuedEvent<Queue.Events, SMS> e) {
                switch (e.getEvent()) {
                    case QUEUE_CLEARED: 
                    case SMS_ADDED: 
                    case SMS_REMOVED: {
                        IntegrationAdapter.this.setSMSCount(Queue.getInstance().size());
                    }
                }
            }
        });
    }
}

