/*
 * Decompiled with CFR 0.152.
 */
package esmska.update;

import com.csvreader.CsvReader;
import esmska.Context;
import esmska.data.Config;
import esmska.data.CountryPrefix;
import esmska.data.Keyring;
import esmska.data.Signature;
import esmska.data.Signatures;
import esmska.data.Tuple;
import esmska.persistence.ContinuousSaveManager;
import esmska.persistence.PersistenceManager;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;

public class LegacyUpdater {
    private static final Logger logger = Logger.getLogger(LegacyUpdater.class.getName());

    public static void update() throws Exception {
        ArrayList<String> newLines;
        List lines;
        Object queueFile;
        Field queueFileField;
        String version = Config.getInstance().getVersion();
        if (StringUtils.isEmpty(version)) {
            return;
        }
        if (ObjectUtils.equals(version, Config.getLatestVersion())) {
            return;
        }
        logger.log(Level.INFO, "Updating from legacy version {0} to current version {1}", new Object[]{version, Config.getLatestVersion()});
        if (Config.compareProgramVersions(version, "0.8.0") < 0 && StringUtils.isEmpty(Config.getInstance().getCountryPrefix())) {
            Config.getInstance().setCountryPrefix(CountryPrefix.getCountryPrefix(Locale.getDefault().getCountry()));
        }
        if (Config.compareProgramVersions(version, "0.16.0") <= 0) {
            logger.fine("Updating keyring file to newer encryption...");
            try {
                byte[] passphrase = new byte[]{-53, -103, 123, -53, -119, -12, -27, -82, 3, -115, 119, -101, 86, 92, 92, 28};
                SecretKeySpec keySpec = new SecretKeySpec(passphrase, "AES");
                String CIPHER_TRANSFORMATION = "AES/ECB/PKCS5Padding";
                Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
                cipher.init(2, keySpec);
                Field keyringFileField = PersistenceManager.class.getDeclaredField("keyringFile");
                keyringFileField.setAccessible(true);
                File keyringFile = (File)keyringFileField.get(null);
                ContinuousSaveManager.disableKeyring();
                Keyring keyring = Keyring.getInstance();
                keyring.clearKeys();
                CsvReader reader = new CsvReader(keyringFile.getPath(), ',', Charset.forName("UTF-8"));
                reader.setUseComments(true);
                while (reader.readRecord()) {
                    String gatewayName = reader.get(0);
                    String login = reader.get(1);
                    String password = reader.get(2);
                    byte[] ciphertext = Base64.decodeBase64(password.getBytes("UTF-8"));
                    byte[] cleartext = cipher.doFinal(ciphertext);
                    password = new String(cleartext, "UTF-8");
                    Tuple<String, String> key = new Tuple<String, String>(login, password);
                    keyring.putKey(gatewayName, key);
                }
                reader.close();
                ContinuousSaveManager.enableKeyring();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Updating keyring file failed", ex);
            }
        }
        if (Config.compareProgramVersions(version, "0.21") <= 0) {
            Field configFileField = PersistenceManager.class.getDeclaredField("configFile");
            configFileField.setAccessible(true);
            File configFile = (File)configFileField.get(null);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            Document doc = db.parse(configFile);
            String senderNumber = xpath.evaluate("//void[@property='senderNumber']/string", doc);
            String senderName = xpath.evaluate("//void[@property='senderName']/string", doc);
            Signature defaultSig = Signatures.getInstance().get(Signature.DEFAULT.getProfileName());
            if (StringUtils.isNotEmpty(senderName)) {
                defaultSig.setUserName(senderName);
            }
            if (StringUtils.isNotEmpty(senderNumber)) {
                defaultSig.setUserNumber(senderNumber);
            }
        }
        if (Config.compareProgramVersions(version, "1.4") < 0) {
            logger.fine("Updating queue to add message IDs...");
            try {
                queueFileField = PersistenceManager.class.getDeclaredField("queueFile");
                queueFileField.setAccessible(true);
                queueFile = (File)queueFileField.get(null);
                lines = FileUtils.readLines((File)queueFile, "UTF-8");
                newLines = new ArrayList<String>();
                for (String line : lines) {
                    newLines.add(line + ",");
                }
                FileUtils.writeLines((File)queueFile, "UTF-8", newLines);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Updating queue file failed", ex);
            }
        }
        if (Config.compareProgramVersions(version, "1.6") <= 0) {
            logger.fine("Updating signature suffix to prefix...");
            Context.persistenceManager.loadGateways();
            Context.persistenceManager.loadGatewayProperties();
            ArrayList<Signature> sigList = new ArrayList<Signature>();
            sigList.addAll(Signatures.getInstance().getAll());
            sigList.addAll(Signatures.getInstance().getSpecial());
            for (Signature signature : sigList) {
                String userName = signature.getUserName();
                if (!StringUtils.isNotEmpty(userName)) continue;
                signature.setUserName(userName + ":");
            }
            Context.persistenceManager.saveGatewayProperties();
        }
        if (Config.compareProgramVersions(version, "1.6.99") <= 0) {
            logger.fine("Updating history to add sms IDs...");
            try {
                queueFileField = PersistenceManager.class.getDeclaredField("historyFile");
                queueFileField.setAccessible(true);
                queueFile = (File)queueFileField.get(null);
                lines = FileUtils.readLines((File)queueFile, "UTF-8");
                newLines = new ArrayList();
                for (String line : lines) {
                    newLines.add(line + ",");
                }
                FileUtils.writeLines((File)queueFile, "UTF-8", newLines);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Updating history file failed", ex);
            }
        }
    }
}

