/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.ManifestAnalyzer;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathJar
extends ClasspathLocation {
    protected File file;
    protected ZipFile zipFile;
    protected ZipFile annotationZipFile;
    protected boolean closeZipFileAtEnd;
    protected Hashtable packageCache;
    protected List<String> annotationPaths;

    public ClasspathJar(File file, boolean bl, AccessRuleSet accessRuleSet, String string) {
        super(accessRuleSet, string);
        this.file = file;
        this.closeZipFileAtEnd = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        InputStream inputStream = null;
        try {
            Object object;
            this.initialize();
            ArrayList<ClasspathJar> arrayList = new ArrayList<ClasspathJar>();
            ZipEntry zipEntry = this.zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry != null) {
                inputStream = this.zipFile.getInputStream(zipEntry);
                object = new ManifestAnalyzer();
                boolean bl = ((ManifestAnalyzer)object).analyzeManifestContents(inputStream);
                List list = ((ManifestAnalyzer)object).getCalledFileNames();
                if (classpathSectionProblemReporter != null) {
                    if (!bl || ((ManifestAnalyzer)object).getClasspathSectionsCount() == 1 && list == null) {
                        classpathSectionProblemReporter.invalidClasspathSection(this.getPath());
                    } else if (((ManifestAnalyzer)object).getClasspathSectionsCount() > 1) {
                        classpathSectionProblemReporter.multipleClasspathSections(this.getPath());
                    }
                }
                if (list != null) {
                    Iterator iterator = list.iterator();
                    String string = this.getPath();
                    int n = string.lastIndexOf(File.separatorChar);
                    string = string.substring(0, n + 1);
                    while (iterator.hasNext()) {
                        arrayList.add(new ClasspathJar(new File(string + (String)iterator.next()), this.closeZipFileAtEnd, this.accessRuleSet, this.destinationPath));
                    }
                }
            }
            object = arrayList;
            return object;
        }
        catch (IOException iOException) {
            List list = null;
            return list;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        return this.findClass(cArray, string, string2, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, boolean bl) {
        if (!this.isPackage(string)) {
            return null;
        }
        try {
            ClassFileReader classFileReader = ClassFileReader.read(this.zipFile, string2);
            if (classFileReader != null) {
                if (this.annotationPaths != null) {
                    String string3 = string2.substring(0, string2.length() - "CLASS".length() - 1);
                    for (String string4 : this.annotationPaths) {
                        try {
                            this.annotationZipFile = classFileReader.setExternalAnnotationProvider(string4, string3, this.annotationZipFile, null);
                            if (!classFileReader.hasAnnotationProvider()) continue;
                            break;
                        }
                        catch (IOException iOException) {
                        }
                    }
                }
                return new NameEnvironmentAnswer(classFileReader, this.fetchAccessRestriction(string2));
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean hasAnnotationFileFor(String string) {
        return this.zipFile.getEntry(string + ".eea") != null;
    }

    @Override
    public char[][][] findTypeNames(String string) {
        Object object;
        if (!this.isPackage(string)) {
            return null;
        }
        ArrayList<char[][]> arrayList = new ArrayList<char[][]>();
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2;
            object = enumeration.nextElement().getName();
            int n = ((String)object).lastIndexOf(47);
            while (n > 0 && string.equals(string2 = ((String)object).substring(0, n))) {
                int n2 = ((String)object).lastIndexOf(46);
                if (n2 == -1) continue;
                String string3 = ((String)object).substring(n + 1, n2);
                char[] cArray = string2.toCharArray();
                arrayList.add(CharOperation.arrayConcat(CharOperation.splitOn('/', cArray), string3.toCharArray()));
            }
        }
        int n = arrayList.size();
        if (n != 0) {
            object = new char[n][][];
            arrayList.toArray((T[])object);
            return null;
        }
        return null;
    }

    @Override
    public void initialize() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
    }

    @Override
    public boolean isPackage(String string) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(string);
        }
        this.packageCache = new Hashtable(41);
        this.packageCache.put(Util.EMPTY_STRING, Util.EMPTY_STRING);
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement().getName();
            int n = string3.lastIndexOf(47);
            while (n > 0 && !this.packageCache.containsKey(string2 = string3.substring(0, n))) {
                this.packageCache.put(string2, string2);
                n = string2.lastIndexOf(47);
            }
        }
        return this.packageCache.containsKey(string);
    }

    @Override
    public void reset() {
        if (this.closeZipFileAtEnd) {
            if (this.zipFile != null) {
                try {
                    this.zipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.zipFile = null;
            }
            if (this.annotationZipFile != null) {
                try {
                    this.annotationZipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.annotationZipFile = null;
            }
        }
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            String string = this.getPath();
            char[] cArray = string.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(cArray, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(cArray, 0, CharOperation.lastIndexOf('.', cArray));
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            try {
                this.path = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.path = this.file.getAbsolutePath();
            }
        }
        return this.path;
    }

    @Override
    public int getMode() {
        return 2;
    }
}

