/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Size;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.X;
import java.nio.ByteBuffer;

public class X11Cursor
extends NativeCursor {
    private static final int CURSOR_WIDTH = 16;
    private static final int CURSOR_HEIGHT = 16;
    protected long xdisplay;
    protected long xwindow;
    private ByteBuffer transparentCursorBuffer;
    private long transparentCursor;
    private long pixmap;
    private static X xLib = X.getX();

    X11Cursor() {
        this.xdisplay = NativePlatformFactory.getNativePlatform().accScreen.platformGetNativeDisplay();
        this.xwindow = NativePlatformFactory.getNativePlatform().accScreen.platformGetNativeWindow();
        this.transparentCursorBuffer = ByteBuffer.allocateDirect(4);
        this.pixmap = xLib.XCreateBitmapFromData(this.xdisplay, this.xwindow, this.transparentCursorBuffer, 1, 1);
        X.XColor xColor = new X.XColor();
        xColor.setRed(xColor.p, 0);
        xColor.setGreen(xColor.p, 0);
        xColor.setBlue(xColor.p, 0);
        this.transparentCursor = xLib.XCreatePixmapCursor(this.xdisplay, this.pixmap, this.pixmap, xColor.p, xColor.p, 0, 0);
        xLib.XFreePixmap(this.xdisplay, this.pixmap);
    }

    @Override
    Size getBestSize() {
        return new Size(16, 16);
    }

    @Override
    void setVisibility(boolean bl) {
        if (this.isVisible && !bl) {
            xLib.XDefineCursor(this.xdisplay, this.xwindow, this.transparentCursor);
            MonocleWindowManager.getInstance().repaintAll();
        } else if (!this.isVisible && bl) {
            xLib.XUndefineCursor(this.xdisplay, this.xwindow);
            MonocleWindowManager.getInstance().repaintAll();
        }
        this.isVisible = bl;
    }

    @Override
    void setImage(byte[] byArray) {
    }

    @Override
    void setLocation(int n, int n2) {
    }

    @Override
    void setHotSpot(int n, int n2) {
    }

    @Override
    void shutdown() {
    }
}

