/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import java.sql.Timestamp;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.catalina.tribes.transport.SenderState;
import org.apache.catalina.tribes.transport.nio.NioReceiver;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.Logs;
import org.apache.catalina.tribes.util.StringManager;

public class ChannelCoordinator
extends ChannelInterceptorBase
implements MessageListener {
    protected static final StringManager sm = StringManager.getManager(ChannelCoordinator.class);
    private ChannelReceiver clusterReceiver;
    private ChannelSender clusterSender;
    private MembershipService membershipService;
    private int startLevel = 0;

    public ChannelCoordinator() {
        this(new NioReceiver(), new ReplicationTransmitter(), new McastService());
    }

    public ChannelCoordinator(ChannelReceiver channelReceiver, ChannelSender channelSender, MembershipService membershipService) {
        this.optionFlag = 7;
        this.setClusterReceiver(channelReceiver);
        this.setClusterSender(channelSender);
        this.setMembershipService(membershipService);
    }

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        if (memberArray == null) {
            memberArray = this.membershipService.getMembers();
        }
        if ((channelMessage.getOptions() & 0x40) == 64) {
            this.membershipService.broadcast(channelMessage);
        } else {
            this.clusterSender.sendMessage(channelMessage, memberArray);
        }
        if (Logs.MESSAGES.isTraceEnabled()) {
            Logs.MESSAGES.trace((Object)("ChannelCoordinator - Sent msg:" + new UniqueId(channelMessage.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " to " + Arrays.toNameString(memberArray)));
        }
    }

    @Override
    public void start(int n) throws ChannelException {
        this.internalStart(n);
    }

    @Override
    public void stop(int n) throws ChannelException {
        this.internalStop(n);
    }

    protected synchronized void internalStart(int n) throws ChannelException {
        try {
            boolean bl = false;
            n &= 0xF;
            if (this.startLevel == 15) {
                return;
            }
            if (n == 0) {
                return;
            }
            if (n == (n & this.startLevel)) {
                throw new ChannelException(sm.getString("channelCoordinator.alreadyStarted", Integer.toString(n)));
            }
            if (1 == (n & 1)) {
                this.clusterReceiver.setMessageListener(this);
                this.clusterReceiver.setChannel(this.getChannel());
                this.clusterReceiver.start();
                Member member = this.getChannel().getLocalMember(false);
                if (member instanceof StaticMember) {
                    StaticMember staticMember = (StaticMember)member;
                    staticMember.setHost(this.getClusterReceiver().getHost());
                    staticMember.setPort(this.getClusterReceiver().getPort());
                    staticMember.setSecurePort(this.getClusterReceiver().getSecurePort());
                } else {
                    this.membershipService.setLocalMemberProperties(this.getClusterReceiver().getHost(), this.getClusterReceiver().getPort(), this.getClusterReceiver().getSecurePort(), this.getClusterReceiver().getUdpPort());
                }
                bl = true;
            }
            if (2 == (n & 2)) {
                this.clusterSender.setChannel(this.getChannel());
                this.clusterSender.start();
                bl = true;
            }
            if (4 == (n & 4)) {
                this.membershipService.setMembershipListener(this);
                this.membershipService.setChannel(this.getChannel());
                if (this.membershipService instanceof McastService) {
                    ((McastService)this.membershipService).setMessageListener(this);
                }
                this.membershipService.start(4);
                bl = true;
            }
            if (8 == (n & 8)) {
                this.membershipService.setChannel(this.getChannel());
                this.membershipService.start(8);
                bl = true;
            }
            if (!bl) {
                throw new IllegalArgumentException(sm.getString("channelCoordinator.invalid.startLevel"));
            }
            this.startLevel |= n;
        }
        catch (ChannelException channelException) {
            throw channelException;
        }
        catch (Exception exception) {
            throw new ChannelException(exception);
        }
    }

    protected synchronized void internalStop(int n) throws ChannelException {
        try {
            n &= 0xF;
            if (this.startLevel == 0) {
                return;
            }
            if (n == 0) {
                return;
            }
            boolean bl = false;
            if (8 == (n & 8)) {
                this.membershipService.stop(8);
                bl = true;
            }
            if (4 == (n & 4)) {
                this.membershipService.stop(4);
                this.membershipService.setMembershipListener(null);
                bl = true;
            }
            if (2 == (n & 2)) {
                this.clusterSender.stop();
                bl = true;
            }
            if (1 == (n & 1)) {
                this.clusterReceiver.stop();
                this.clusterReceiver.setMessageListener(null);
                bl = true;
            }
            if (!bl) {
                throw new IllegalArgumentException(sm.getString("channelCoordinator.invalid.startLevel"));
            }
            this.startLevel &= ~n;
            this.setChannel(null);
        }
        catch (Exception exception) {
            throw new ChannelException(exception);
        }
    }

    @Override
    public void memberAdded(Member member) {
        SenderState.getSenderState(member);
        super.memberAdded(member);
    }

    @Override
    public void memberDisappeared(Member member) {
        SenderState.removeSenderState(member);
        super.memberDisappeared(member);
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (Logs.MESSAGES.isTraceEnabled()) {
            Logs.MESSAGES.trace((Object)("ChannelCoordinator - Received msg:" + new UniqueId(channelMessage.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " from " + channelMessage.getAddress().getName()));
        }
        super.messageReceived(channelMessage);
    }

    @Override
    public boolean accept(ChannelMessage channelMessage) {
        return true;
    }

    public ChannelReceiver getClusterReceiver() {
        return this.clusterReceiver;
    }

    public ChannelSender getClusterSender() {
        return this.clusterSender;
    }

    public MembershipService getMembershipService() {
        return this.membershipService;
    }

    public void setClusterReceiver(ChannelReceiver channelReceiver) {
        if (channelReceiver != null) {
            this.clusterReceiver = channelReceiver;
            this.clusterReceiver.setMessageListener(this);
        } else {
            if (this.clusterReceiver != null) {
                this.clusterReceiver.setMessageListener(null);
            }
            this.clusterReceiver = null;
        }
    }

    public void setClusterSender(ChannelSender channelSender) {
        this.clusterSender = channelSender;
    }

    public void setMembershipService(MembershipService membershipService) {
        this.membershipService = membershipService;
        this.membershipService.setMembershipListener(this);
    }

    @Override
    public void heartbeat() {
        if (this.clusterSender != null) {
            this.clusterSender.heartbeat();
        }
        super.heartbeat();
    }

    @Override
    public boolean hasMembers() {
        return this.getMembershipService().hasMembers();
    }

    @Override
    public Member[] getMembers() {
        return this.getMembershipService().getMembers();
    }

    @Override
    public Member getMember(Member member) {
        return this.getMembershipService().getMember(member);
    }

    @Override
    public Member getLocalMember(boolean bl) {
        return this.getMembershipService().getLocalMember(bl);
    }
}

