/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.AbstractGroup;
import org.apache.catalina.users.MemoryUserDatabase;

public class MemoryGroup
extends AbstractGroup {
    protected MemoryUserDatabase database = null;
    protected ArrayList<Role> roles = new ArrayList();

    MemoryGroup(MemoryUserDatabase memoryUserDatabase, String string, String string2) {
        this.database = memoryUserDatabase;
        this.setGroupname(string);
        this.setDescription(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.iterator();
        }
    }

    @Override
    public UserDatabase getUserDatabase() {
        return this.database;
    }

    @Override
    public Iterator<User> getUsers() {
        ArrayList<User> arrayList = new ArrayList<User>();
        Iterator<User> iterator = this.database.getUsers();
        while (iterator.hasNext()) {
            User user = iterator.next();
            if (!user.isInGroup(this)) continue;
            arrayList.add(user);
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            if (!this.roles.contains(role)) {
                this.roles.add(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.contains(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.remove(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoles() {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<group groupname=\"");
        stringBuilder.append(this.groupname);
        stringBuilder.append("\"");
        if (this.description != null) {
            stringBuilder.append(" description=\"");
            stringBuilder.append(this.description);
            stringBuilder.append("\"");
        }
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            if (this.roles.size() > 0) {
                stringBuilder.append(" roles=\"");
                int n = 0;
                Iterator<Role> iterator = this.roles.iterator();
                while (iterator.hasNext()) {
                    if (n > 0) {
                        stringBuilder.append(',');
                    }
                    ++n;
                    stringBuilder.append(iterator.next().getRolename());
                }
                stringBuilder.append("\"");
            }
        }
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }
}

