/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.apache.tomcat.websocket.server.WsWriteTimeout;

public class WsRemoteEndpointImplServer
extends WsRemoteEndpointImplBase {
    private static final StringManager sm = StringManager.getManager(WsRemoteEndpointImplServer.class);
    private final Log log = LogFactory.getLog(WsRemoteEndpointImplServer.class);
    private static final Queue<OnResultRunnable> onResultRunnables = new ConcurrentLinkedQueue<OnResultRunnable>();
    private final AbstractServletOutputStream sos;
    private final WsWriteTimeout wsWriteTimeout;
    private final ExecutorService executorService;
    private volatile SendHandler handler = null;
    private volatile ByteBuffer[] buffers = null;
    private volatile long timeoutExpiry = -1L;

    public WsRemoteEndpointImplServer(AbstractServletOutputStream abstractServletOutputStream, WsServerContainer wsServerContainer) {
        this.sos = abstractServletOutputStream;
        this.wsWriteTimeout = wsServerContainer.getTimeout();
        this.executorService = wsServerContainer.getExecutorService();
    }

    @Override
    protected final boolean isMasked() {
        return false;
    }

    @Override
    protected void doWrite(SendHandler sendHandler, ByteBuffer ... byteBufferArray) {
        this.handler = sendHandler;
        this.buffers = byteBufferArray;
        this.onWritePossible(true);
    }

    public void onWritePossible(boolean bl) {
        long l;
        boolean bl2 = true;
        try {
            while (this.sos.isReady()) {
                bl2 = true;
                for (ByteBuffer byteBuffer : this.buffers) {
                    if (!byteBuffer.hasRemaining()) continue;
                    bl2 = false;
                    this.sos.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
                    byteBuffer.position(byteBuffer.limit());
                    break;
                }
                if (!bl2) continue;
                this.wsWriteTimeout.unregister(this);
                this.clearHandler(null, bl);
                break;
            }
        }
        catch (IOException iOException) {
            this.wsWriteTimeout.unregister(this);
            this.clearHandler(iOException, bl);
            this.close();
        }
        if (!bl2 && (l = this.getSendTimeout()) > 0L) {
            this.timeoutExpiry = l + System.currentTimeMillis();
            this.wsWriteTimeout.register(this);
        }
    }

    @Override
    protected void doClose() {
        block3: {
            if (this.handler != null) {
                this.clearHandler(new EOFException(), true);
            }
            try {
                this.sos.close();
            }
            catch (Exception exception) {
                if (!this.log.isInfoEnabled()) break block3;
                this.log.info((Object)sm.getString("wsRemoteEndpointServer.closeFailed"), (Throwable)exception);
            }
        }
        this.wsWriteTimeout.unregister(this);
    }

    protected long getTimeoutExpiry() {
        return this.timeoutExpiry;
    }

    protected void onTimeout(boolean bl) {
        if (this.handler != null) {
            this.clearHandler(new SocketTimeoutException(), bl);
        }
        this.close();
    }

    @Override
    protected void setTransformation(Transformation transformation) {
        super.setTransformation(transformation);
    }

    private void clearHandler(Throwable throwable, boolean bl) {
        SendHandler sendHandler = this.handler;
        this.handler = null;
        this.buffers = null;
        if (sendHandler != null) {
            if (bl) {
                OnResultRunnable onResultRunnable = onResultRunnables.poll();
                if (onResultRunnable == null) {
                    onResultRunnable = new OnResultRunnable(onResultRunnables);
                }
                onResultRunnable.init(sendHandler, throwable);
                if (this.executorService == null || this.executorService.isShutdown()) {
                    onResultRunnable.run();
                } else {
                    this.executorService.execute(onResultRunnable);
                }
            } else if (throwable == null) {
                sendHandler.onResult(new SendResult());
            } else {
                sendHandler.onResult(new SendResult(throwable));
            }
        }
    }

    private static class OnResultRunnable
    implements Runnable {
        private final Queue<OnResultRunnable> queue;
        private volatile SendHandler sh;
        private volatile Throwable t;

        private OnResultRunnable(Queue<OnResultRunnable> queue) {
            this.queue = queue;
        }

        private void init(SendHandler sendHandler, Throwable throwable) {
            this.sh = sendHandler;
            this.t = throwable;
        }

        @Override
        public void run() {
            if (this.t == null) {
                this.sh.onResult(new SendResult());
            } else {
                this.sh.onResult(new SendResult(this.t));
            }
            this.t = null;
            this.sh = null;
            this.queue.add(this);
        }
    }
}

