/**
 * Created by kor on 05/05/15.
 */
import yaml = require("yaml-ast-parser");
import highlevel = require("./highLevelAST");
import { IParseResult } from "../index";
import resolversApi = require("./jsyaml/resolversApi");
export interface ICompilationUnit {
    contents(): string;
    path(): string;
    absolutePath(): string;
    isTopLevel(): boolean;
    ast(): ILowLevelASTNode;
    clone(): ICompilationUnit;
    isDirty(): boolean;
    isRAMLUnit(): boolean;
    project(): IProject;
    lexerErrors(): Error[];
    resolve(p: string): ICompilationUnit;
    resolveAsync(p: string): Promise<ICompilationUnit>;
    /**
     * gathers includes over ast without actual resolving of units;
     */
    getIncludeNodes(): {
        includePath(): string;
    }[];
    updateContent(newContent: string): any;
    lineMapper(): LineMapper;
    highLevel(): IParseResult;
    expandedHighLevel(): highlevel.IParseResult;
    /**
     * Returns true if this unit is overlay or extension, false otherwise.
     */
    isOverlayOrExtension(): boolean;
    /**
     * Returns master reference if presents, null otherwise.
     */
    getMasterReferenceNode(): ILowLevelASTNode;
}
export interface IProject {
    units(): ICompilationUnit[];
    unit(path: string, absolute?: boolean): ICompilationUnit;
    unitAsync(path: string, absolute?: boolean): Promise<ICompilationUnit>;
    lexerErrors(): Error[];
    deleteUnit(n: string): any;
    cloneWithResolver(r: any): IProject;
    cloneWithResolver(newResolver: resolversApi.FSResolver, httpResolver?: resolversApi.HTTPResolver): IProject;
    getRootPath(): string;
    execute(cmd: CompositeCommand): any;
    executeTextChange(textCommand: TextChangeCommand): any;
    addListener(listener: IASTListener): any;
    removeListener(listener: IASTListener): any;
    addTextChangeListener(listener: ITextChangeCommandListener): any;
    removeTextChangeListener(listener: ITextChangeCommandListener): any;
    setCachedUnitContent(path: string, content?: string): any;
    fsEnabled(): boolean;
    getMainUnit(): ICompilationUnit;
}
export interface IASTListener {
    (delta: ASTDelta): any;
}
export interface ITextChangeCommandListener {
    (delta: TextChangeCommand): any;
}
export declare class ASTDelta {
    commands: ASTChangeCommand[];
}
export interface ASTVisitor {
    (node: ILowLevelASTNode): boolean;
}
export interface IncludeReference {
    getFragments(): string[];
    getIncludePath(): string;
    asString(): string;
    encodedName(): string;
}
export interface ILowLevelASTNode {
    start(): number;
    end(): number;
    value(toString?: boolean): any;
    hasInnerIncludeError(): boolean;
    includeErrors(): string[];
    includePath(): string;
    includeReference(): IncludeReference;
    key(): string;
    optional(): boolean;
    actual(): any;
    children(): ILowLevelASTNode[];
    parent(): ILowLevelASTNode;
    unit(): ICompilationUnit;
    /**
     * Returns a unit, which is a base for include reference.
     * This method should be called when a node may potentially hbe defined in several units
     * at once (in case of expansion) and caller needs a unit, which is a base for this node's
     * include statement.
     *
     * If this node has no include statement, return value of the method should be equal to the result of
     * unit() method call.
     */
    includeBaseUnit(): ICompilationUnit;
    anchorId(): string;
    errors(): Error[];
    anchoredFrom(): ILowLevelASTNode;
    includedFrom(): ILowLevelASTNode;
    visit(v: ASTVisitor): any;
    addChild(n: ILowLevelASTNode, pos?: number): any;
    execute(cmd: CompositeCommand): any;
    isAnnotatedScalar(): boolean;
    dump(): string;
    dumpToObject(full?: boolean): any;
    keyStart(): number;
    keyEnd(): number;
    valueStart(): number;
    valueEnd(): number;
    isValueLocal(): boolean;
    /**
     * Returns kind of the underlying YAML node
     */
    kind(): yaml.Kind;
    /**
     * Returns kind of the value YAML node
     */
    valueKind(): yaml.Kind;
    /**
     * Returns value kind for AST with resolved includes and anchors
     */
    resolvedValueKind(): yaml.Kind;
    /**
     * For anchor returns kind of anchored node.
     * For the rest of the nodes returns null.
     */
    anchorValueKind(): yaml.Kind;
    /**
     * Returns kind of the key YAML node
     */
    keyKind(): yaml.Kind;
    show(msg: string, lev?: number, text?: string): any;
    markup(json?: boolean): string;
    highLevelParseResult(): highlevel.IParseResult;
    setHighLevelParseResult(highLevel: highlevel.IParseResult): any;
    highLevelNode(): highlevel.IHighLevelNode;
    setHighLevelNode(highLevelParseResult: highlevel.IHighLevelNode): any;
    text(unitText: string): string;
    copy(): ILowLevelASTNode;
    nodeDefinition(): highlevel.INodeDefinition;
    /**
     * Indicates that contents of this node are !included
     */
    includesContents(): boolean;
    containingUnit(): ICompilationUnit;
}
export declare enum CommandKind {
    ADD_CHILD = 0,
    REMOVE_CHILD = 1,
    MOVE_CHILD = 2,
    CHANGE_KEY = 3,
    CHANGE_VALUE = 4,
    INIT_RAML_FILE = 5
}
export declare class TextChangeCommand {
    offset: number;
    constructor(offset: number, replacementLength: number, text: string, unit: ICompilationUnit, target?: ILowLevelASTNode);
    replacementLength: number;
    text: string;
    unit: ICompilationUnit;
    target: ILowLevelASTNode;
    isUndefined: boolean;
}
export declare class CompositeCommand {
    source: any;
    timestamp: number;
    commands: ASTChangeCommand[];
}
export declare enum InsertionPointType {
    NONE = 0,
    START = 1,
    END = 2,
    POINT = 3
}
export interface InsertionPoint {
    type: InsertionPointType;
    point: ILowLevelASTNode;
}
export declare class ASTChangeCommand {
    constructor(kind: CommandKind, target: ILowLevelASTNode, value: string | ILowLevelASTNode, position: number);
    toSeq: boolean;
    insertionPoint: ILowLevelASTNode | InsertionPoint;
    kind: CommandKind;
    target: ILowLevelASTNode;
    value: string | ILowLevelASTNode;
    position: number;
}
export declare function setAttr(t: ILowLevelASTNode, value: string): ASTChangeCommand;
export declare function setAttrStructured(t: ILowLevelASTNode, value: highlevel.IStructuredValue): ASTChangeCommand;
export declare function setKey(t: ILowLevelASTNode, value: string): ASTChangeCommand;
export declare function removeNode(t: ILowLevelASTNode, child: ILowLevelASTNode): ASTChangeCommand;
export declare function insertNode(t: ILowLevelASTNode, child: ILowLevelASTNode, insertAfter?: ILowLevelASTNode | InsertionPoint, toSeq?: boolean): ASTChangeCommand;
export declare function initRamlFile(root: ILowLevelASTNode, newroot: ILowLevelASTNode): ASTChangeCommand;
export interface ILowLevelEnvironment {
    createProject(path: string): IProject;
}
export interface TextPosition {
    /**
     * Line number, starting from one
     */
    line: number;
    /**
     * Column number, starting from one
     */
    column: number;
    /**
     * Character index in whole text, starting from zero
     */
    position: number;
}
export interface LineMapper {
    position(pos: number): TextPosition;
    toPosition(line: number, column: number): TextPosition;
}
export declare class LineMapperImpl implements LineMapper {
    private content;
    private absPath;
    constructor(content: string, absPath: string);
    private mapping;
    position(_pos: number): TextPosition;
    initMapping(): void;
    toPosition(line: number, _column: number): TextPosition;
}
/**
 * Canonic way of resolving references in RAML specs:
 * * relative reference is regarded as relative to containing unit
 * * absolute local path (starting with slash) is regarderd as relative to root RAML
 * * absolute web paths are regarded as such
 *
 * @param reference reference to be resolved
 * @param unitPath path of unit containing the reference, absolute or relative to root
 * @param rootPath path to root RAML
 * @returns resolved path
 */
export declare function buildPath(reference: any, unitPath: any, rootPath: any): any;
/**
 * Resolving reference against context
 * * absolute local and web references are regarded as such
 * * relative references are regarded as relative to the context
 * @param context absolute local or web path
 * @param reference
 * @returns resolved reference
 */
export declare function toAbsolutePath(context: string, reference: string): string;
/**
 * Check if reference points to web resource
 * @param reference
 * @returns {boolean}
 */
export declare function isWebPath(reference: any): boolean;
export declare function isLowLevelNode(object: any): object is ILowLevelASTNode;
