/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.gui.jobs.IBackgroundTask;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.ProgressPanel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundExecutor.class);
    private final MainWindow mainWindow;
    private final ProgressPanel progressPane;
    private ThreadPoolExecutor taskQueueExecutor;

    public BackgroundExecutor(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.progressPane = mainWindow.getProgressPane();
        this.taskQueueExecutor = this.makeTaskQueueExecutor();
    }

    public Future<Boolean> execute(IBackgroundTask task) {
        TaskWorker taskWorker = new TaskWorker(task);
        this.taskQueueExecutor.execute(() -> {
            taskWorker.init();
            taskWorker.run();
        });
        return taskWorker;
    }

    public void cancelAll() {
        try {
            this.taskQueueExecutor.shutdownNow();
            this.taskQueueExecutor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("Error terminating task executor", (Throwable)e);
        }
        finally {
            this.taskQueueExecutor = this.makeTaskQueueExecutor();
        }
    }

    public void execute(String title, List<Runnable> backgroundJobs, Runnable onFinishUiRunnable) {
        this.execute(new SimpleTask(title, backgroundJobs, onFinishUiRunnable));
    }

    public void execute(String title, List<Runnable> backgroundJobs) {
        this.execute(new SimpleTask(title, backgroundJobs, null));
    }

    public void execute(String title, Runnable backgroundRunnable, Runnable onFinishUiRunnable) {
        this.execute(new SimpleTask(title, backgroundRunnable, onFinishUiRunnable));
    }

    public void execute(String title, Runnable backgroundRunnable) {
        this.execute(new SimpleTask(title, backgroundRunnable, null));
    }

    private ThreadPoolExecutor makeTaskQueueExecutor() {
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    }

    private static final class SimpleTask
    implements IBackgroundTask {
        private final String title;
        private final List<Runnable> jobs;
        private final Runnable onFinish;

        public SimpleTask(String title, List<Runnable> jobs, @Nullable Runnable onFinish) {
            this.title = title;
            this.jobs = jobs;
            this.onFinish = onFinish;
        }

        public SimpleTask(String title, Runnable job, @Nullable Runnable onFinish) {
            this(title, Collections.singletonList(job), onFinish);
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public List<Runnable> scheduleJobs() {
            return this.jobs;
        }

        @Override
        public boolean canBeCanceled() {
            return false;
        }

        @Override
        public void onFinish() {
            if (this.onFinish != null) {
                this.onFinish.run();
            }
        }
    }

    private final class TaskWorker
    extends SwingWorker<Boolean, Void> {
        private final IBackgroundTask task;
        private long jobsCount;

        public TaskWorker(IBackgroundTask task) {
            this.task = task;
        }

        public void init() {
            this.addPropertyChangeListener(BackgroundExecutor.this.progressPane);
            BackgroundExecutor.this.progressPane.reset();
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            BackgroundExecutor.this.progressPane.changeLabel(this, this.task.getTitle() + "\u2026 ");
            BackgroundExecutor.this.progressPane.changeCancelBtnVisible(this, this.task.canBeCanceled());
            BackgroundExecutor.this.progressPane.changeVisibility(this, true);
            List<Runnable> jobs = this.task.scheduleJobs();
            this.jobsCount = jobs.size();
            LOG.debug("Starting background task '{}', jobs count: {}", (Object)this.task.getTitle(), (Object)this.jobsCount);
            if (this.jobsCount == 1L) {
                jobs.get(0).run();
                return true;
            }
            int threadsCount = BackgroundExecutor.this.mainWindow.getSettings().getThreadsCount();
            if (threadsCount == 1) {
                return this.runInCurrentThread(jobs);
            }
            return this.runInExecutor(jobs, threadsCount);
        }

        private boolean runInCurrentThread(List<Runnable> jobs) {
            int k = 0;
            for (Runnable job : jobs) {
                job.run();
                this.setProgress(this.calcProgress(++k));
                if (!this.isCancelled()) continue;
                return false;
            }
            return true;
        }

        private boolean runInExecutor(List<Runnable> jobs, int threadsCount) throws InterruptedException {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadsCount);
            for (Runnable job : jobs) {
                executor.execute(job);
            }
            executor.shutdown();
            return this.waitTermination(executor);
        }

        private boolean waitTermination(ThreadPoolExecutor executor) throws InterruptedException {
            while (!executor.isTerminated()) {
                if (this.isCancelled()) {
                    executor.shutdownNow();
                    BackgroundExecutor.this.progressPane.changeLabel(this, this.task.getTitle() + " (Canceling)\u2026 ");
                    BackgroundExecutor.this.progressPane.changeIndeterminate(this, true);
                    executor.awaitTermination(5L, TimeUnit.SECONDS);
                    return false;
                }
                this.setProgress(this.calcProgress(executor.getCompletedTaskCount()));
                Thread.sleep(500L);
            }
            return true;
        }

        private int calcProgress(long done) {
            return Math.round((float)(done * 100L) / (float)this.jobsCount);
        }

        @Override
        protected void done() {
            BackgroundExecutor.this.progressPane.setVisible(false);
            this.task.onFinish();
        }
    }
}

