/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import javax.swing.text.StyleConstants;
import org.protege.editor.owl.ui.renderer.styledstring.CSSConstants;
import org.protege.editor.owl.ui.renderer.styledstring.StyleAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.Underline;

public class UnderlineAttribute
extends StyleAttribute {
    private static final UnderlineAttribute NONE = new UnderlineAttribute(Underline.NONE);
    private static final UnderlineAttribute SINGLE = new UnderlineAttribute(Underline.SINGLE);
    private Underline underline;

    public UnderlineAttribute(Underline underline) {
        this.underline = underline;
    }

    public Underline getUnderline() {
        return this.underline;
    }

    public static UnderlineAttribute getNone() {
        return NONE;
    }

    public static UnderlineAttribute getSingle() {
        return SINGLE;
    }

    @Override
    public String getCSSPropertyName() {
        return CSSConstants.TEXT_DECORATION.getName();
    }

    @Override
    public String getCSSValue() {
        return this.underline == Underline.SINGLE ? CSSConstants.UNDERLINE.getName() : CSSConstants.NONE.getName();
    }

    @Override
    public AttributedCharacterIterator.Attribute getAttributedStringAttribute() {
        return TextAttribute.UNDERLINE;
    }

    @Override
    public Object getAttributesStringValue() {
        return TextAttribute.UNDERLINE_LOW_ONE_PIXEL;
    }

    @Override
    public StyleConstants getTextAttribute() {
        return (StyleConstants.CharacterConstants)StyleConstants.Underline;
    }

    @Override
    public Object getTextValue() {
        return this.underline == Underline.SINGLE;
    }

    public int hashCode() {
        return UnderlineAttribute.class.getSimpleName().hashCode() + this.underline.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnderlineAttribute)) {
            return false;
        }
        UnderlineAttribute other = (UnderlineAttribute)obj;
        return this.underline.equals((Object)other.underline);
    }
}

