/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public class XmlPlistReader
implements PlistReader {
    @Override
    public Plist read(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            XmlPlistReader.$$$reportNull$$$0(0);
        }
        try {
            return XmlPlistReader.internalRead(JDOMUtil.load((InputStream)inputStream));
        }
        catch (JDOMException e) {
            throw new IOException("Error while parsing plist", e);
        }
    }

    @Override
    public Plist read(@NotNull File file) throws IOException {
        if (file == null) {
            XmlPlistReader.$$$reportNull$$$0(1);
        }
        try {
            return XmlPlistReader.internalRead(JDOMUtil.load((File)file));
        }
        catch (JDOMException e) {
            throw new IOException("Error while parsing plist", e);
        }
    }

    private static Plist internalRead(@NotNull Element root) throws IOException {
        if (root == null) {
            XmlPlistReader.$$$reportNull$$$0(2);
        }
        if (JDOMUtil.isEmpty((Element)root)) {
            return Plist.EMPTY_PLIST;
        }
        if (!"plist".equals(root.getName())) {
            throw new IOException("Unknown xml format. Root element is '" + root.getName() + "'");
        }
        Element dictElement = root.getChild("dict");
        return dictElement != null ? (Plist)XmlPlistReader.readDict(dictElement).getValue() : Plist.EMPTY_PLIST;
    }

    private static PListValue readDict(@NotNull Element dictElement) throws IOException {
        if (dictElement == null) {
            XmlPlistReader.$$$reportNull$$$0(3);
        }
        Plist dict = new Plist();
        List children = dictElement.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            String attributeKey;
            PListValue value;
            Element keyElement = (Element)children.get(i);
            if (!"key".equals(keyElement.getName()) || (value = XmlPlistReader.readValue(attributeKey = keyElement.getValue(), (Element)children.get(++i))) == null) continue;
            dict.setEntry(attributeKey, value);
        }
        return PListValue.value(dict, PlistValueType.DICT);
    }

    @Nullable
    private static PListValue readValue(@NotNull String key, @NotNull Element valueElement) throws IOException {
        String type;
        if (key == null) {
            XmlPlistReader.$$$reportNull$$$0(4);
        }
        if (valueElement == null) {
            XmlPlistReader.$$$reportNull$$$0(5);
        }
        if ("dict".equals(type = valueElement.getName())) {
            return XmlPlistReader.readDict(valueElement);
        }
        if ("array".equals(type)) {
            return XmlPlistReader.readArray(key, valueElement);
        }
        return XmlPlistReader.readBasicValue(type, valueElement);
    }

    private static PListValue readArray(String key, Element element) throws IOException {
        ArrayList<PListValue> result = new ArrayList<PListValue>();
        for (Element child : element.getChildren()) {
            PListValue val = XmlPlistReader.readValue(key, child);
            if (val == null) continue;
            result.add(val);
        }
        return PListValue.value(result, PlistValueType.ARRAY);
    }

    @Nullable
    private static PListValue readBasicValue(@NotNull String type, @NotNull Element valueElement) throws IOException {
        if (type == null) {
            XmlPlistReader.$$$reportNull$$$0(6);
        }
        if (valueElement == null) {
            XmlPlistReader.$$$reportNull$$$0(7);
        }
        if ("string".equals(type)) {
            return PListValue.value(StringUtil.unescapeXmlEntities((String)valueElement.getValue()), PlistValueType.STRING);
        }
        if ("true".equals(type)) {
            return PListValue.value(Boolean.TRUE, PlistValueType.BOOLEAN);
        }
        if ("false".equals(type)) {
            return PListValue.value(Boolean.FALSE, PlistValueType.BOOLEAN);
        }
        if ("integer".equals(type)) {
            return PListValue.value(Long.parseLong(valueElement.getValue()), PlistValueType.INTEGER);
        }
        if ("real".equals(type)) {
            return PListValue.value(Double.parseDouble(valueElement.getValue()), PlistValueType.REAL);
        }
        if ("date".equals(type)) {
            try {
                return PListValue.value(Plist.dateFormatter().parse(valueElement.getValue()), PlistValueType.DATE);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/plist/XmlPlistReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "internalRead";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readDict";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "readValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "readBasicValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

