/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameArgumentQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyArgumentListInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyArgumentListInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    public static void inspectPyArgumentList(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull PyResolveContext resolveContext, int implicitOffset) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(3);
        }
        if (resolveContext == null) {
            PyArgumentListInspection.$$$reportNull$$$0(4);
        }
        if (node.getParent() instanceof PyClass) {
            return;
        }
        PyCallExpression call = node.getCallExpression();
        if (call == null) {
            return;
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        List<PyCallExpression.PyArgumentsMapping> mappings = call.multiMapArguments(resolveContext, implicitOffset);
        for (PyCallExpression.PyArgumentsMapping mapping : mappings) {
            PyCallable callable;
            PyCallableType callableType = mapping.getCallableType();
            if (callableType == null || !((callable = callableType.getCallable()) instanceof PyFunction)) continue;
            PyFunction function = (PyFunction)callable;
            if (PyKnownDecoratorUtil.hasUnknownOrChangingSignatureDecorator(function, context) || PyArgumentListInspection.decoratedClassInitCall(call.getCallee(), function, resolveContext)) {
                return;
            }
            if (!PyArgumentListInspection.objectMethodCallViaSuper(call, function)) continue;
            return;
        }
        PyArgumentListInspection.highlightUnexpectedArguments(node, holder, mappings, context);
        PyArgumentListInspection.highlightUnfilledParameters(node, holder, mappings, context);
        PyArgumentListInspection.highlightStarArgumentTypeMismatch(node, holder, context);
    }

    public static void inspectPyArgumentList(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull PyResolveContext resolveContext) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(6);
        }
        if (resolveContext == null) {
            PyArgumentListInspection.$$$reportNull$$$0(7);
        }
        PyArgumentListInspection.inspectPyArgumentList(node, holder, resolveContext, 0);
    }

    private static boolean decoratedClassInitCall(@Nullable PyExpression callee, @NotNull PyFunction function, @NotNull PyResolveContext resolveContext) {
        if (function == null) {
            PyArgumentListInspection.$$$reportNull$$$0(8);
        }
        if (resolveContext == null) {
            PyArgumentListInspection.$$$reportNull$$$0(9);
        }
        if (callee instanceof PyReferenceExpression && PyUtil.isInitMethod(function)) {
            PsiPolyVariantReference classReference = ((PyReferenceExpression)callee).getReference(resolveContext);
            return Arrays.stream(classReference.multiResolve(false)).map(ResolveResult::getElement).anyMatch(element -> element instanceof PyClass && PyKnownDecoratorUtil.hasUnknownOrChangingReturnTypeDecorator((PyClass)element, resolveContext.getTypeEvalContext()));
        }
        return false;
    }

    private static boolean objectMethodCallViaSuper(@NotNull PyCallExpression call, @NotNull PyFunction function) {
        PyExpression receiverExpression;
        PyClass receiverClass;
        if (call == null) {
            PyArgumentListInspection.$$$reportNull$$$0(10);
        }
        if (function == null) {
            PyArgumentListInspection.$$$reportNull$$$0(11);
        }
        return (receiverClass = function.getContainingClass()) != null && PyUtil.isObjectClass(receiverClass) && (receiverExpression = call.getReceiver(null)) instanceof PyCallExpression && PyUtil.isSuperCall((PyCallExpression)receiverExpression);
    }

    private static void highlightStarArgumentTypeMismatch(PyArgumentList node, ProblemsHolder holder, TypeEvalContext context) {
        for (PyExpression arg : node.getArguments()) {
            PyType inside_type;
            PyExpression content2;
            if (!(arg instanceof PyStarArgument) || (content2 = PyUtil.peelArgument((PyExpression)PsiTreeUtil.findChildOfType((PsiElement)arg, PyExpression.class))) == null || (inside_type = context.getType(content2)) == null || PyTypeChecker.isUnknown(inside_type, context)) continue;
            if (((PyStarArgument)arg).isKeyword()) {
                if (PyABCUtil.isSubtype(inside_type, "Mapping", context)) continue;
                holder.registerProblem((PsiElement)arg, PyPsiBundle.message("INSP.expected.dict.got.$0", inside_type.getName()), new LocalQuickFix[0]);
                continue;
            }
            if (PyABCUtil.isSubtype(inside_type, "Iterable", context)) continue;
            holder.registerProblem((PsiElement)arg, PyPsiBundle.message("INSP.expected.iter.got.$0", inside_type.getName()), new LocalQuickFix[0]);
        }
    }

    private static Set<String> getDuplicateKeywordArguments(@NotNull PyArgumentList node) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(12);
        }
        HashSet<String> keywordArgumentNames = new HashSet<String>();
        HashSet<String> results = new HashSet<String>();
        for (PyExpression argument : node.getArguments()) {
            if (!(argument instanceof PyKeywordArgument)) continue;
            String keyword = ((PyKeywordArgument)argument).getKeyword();
            if (keywordArgumentNames.contains(keyword)) {
                results.add(keyword);
            }
            keywordArgumentNames.add(keyword);
        }
        return results;
    }

    private static void highlightUnexpectedArguments(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(14);
        }
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(16);
        }
        if (mappings.isEmpty() || mappings.stream().anyMatch(mapping -> mapping.getUnmappedArguments().isEmpty())) {
            return;
        }
        if (mappings.size() == 1) {
            PyCallableType callableType;
            Set<String> duplicateKeywords = PyArgumentListInspection.getDuplicateKeywordArguments(node);
            PyCallExpression.PyArgumentsMapping mapping2 = mappings.get(0);
            if (holder.isOnTheFly() && !mapping2.getUnmappedArguments().isEmpty() && mapping2.getUnmappedParameters().isEmpty() && (callableType = mapping2.getCallableType()) != null) {
                PyCallable callable = callableType.getCallable();
                Project project = node.getProject();
                if (callable instanceof PyFunction && !PyPsiIndexUtil.isNotUnderSourceRoot(project, callable.getContainingFile())) {
                    String message = PyPsiBundle.message("INSP.unexpected.arg(s)", new Object[0]);
                    holder.registerProblem((PsiElement)node, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{PythonUiService.getInstance().createPyChangeSignatureQuickFixForMismatchedCall(mapping2)});
                }
            }
            for (PyExpression argument : mapping2.getUnmappedArguments()) {
                ArrayList quickFixes = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyRemoveArgumentQuickFix()});
                if (argument instanceof PyKeywordArgument) {
                    if (duplicateKeywords.contains(((PyKeywordArgument)argument).getKeyword())) continue;
                    quickFixes.add(new PyRenameArgumentQuickFix());
                }
                holder.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.unexpected.arg", new Object[0]), quickFixes.toArray(new LocalQuickFix[quickFixes.size() - 1]));
            }
        } else {
            holder.registerProblem((PsiElement)node, PyArgumentListInspection.addPossibleCalleesRepresentation(PyPsiBundle.message("INSP.unexpected.arg(s)", new Object[0]), mappings, context, holder.isOnTheFly()), new LocalQuickFix[0]);
        }
    }

    private static void highlightUnfilledParameters(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(17);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(18);
        }
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(20);
        }
        if (mappings.isEmpty() || mappings.stream().anyMatch(mapping -> mapping.getUnmappedParameters().isEmpty())) {
            return;
        }
        Optional.ofNullable(node.getNode()).map(astNode -> astNode.findChildByType((IElementType)PyTokenTypes.RPAR)).map(ASTNode::getPsi).ifPresent(psi -> {
            if (mappings.size() != 1 || ContainerUtil.exists(((PyCallExpression.PyArgumentsMapping)mappings.get(0)).getUnmappedParameters(), parameter -> parameter.getName() == null)) {
                holder.registerProblem(psi, PyArgumentListInspection.addPossibleCalleesRepresentation(PyPsiBundle.message("INSP.parameter(s).unfilled", new Object[0]), mappings, context, holder.isOnTheFly()), new LocalQuickFix[0]);
            } else {
                ((StreamEx)StreamEx.of(((PyCallExpression.PyArgumentsMapping)mappings.get(0)).getUnmappedParameters()).map(PyCallableParameter::getName).filter(Objects::nonNull)).forEach(name -> holder.registerProblem(psi, PyPsiBundle.message("INSP.parameter.$0.unfilled", name), new LocalQuickFix[0]));
            }
        });
    }

    @NotNull
    private static String addPossibleCalleesRepresentation(@NotNull String prefix, @NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context, boolean isOnTheFly) {
        if (prefix == null) {
            PyArgumentListInspection.$$$reportNull$$$0(21);
        }
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(23);
        }
        String separator = isOnTheFly ? "<br>" : " ";
        String possibleCalleesRepresentation = PyArgumentListInspection.calculatePossibleCalleesRepresentation(mappings, context, isOnTheFly);
        if (isOnTheFly) {
            String string = XmlStringUtil.wrapInHtml((CharSequence)(prefix + separator + PyPsiBundle.message("INSP.possible.callees", new Object[0]) + ":" + separator + possibleCalleesRepresentation));
            if (string == null) {
                PyArgumentListInspection.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = prefix + "." + separator + PyPsiBundle.message("INSP.possible.callees", new Object[0]) + ":" + separator + possibleCalleesRepresentation;
        if (string == null) {
            PyArgumentListInspection.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String calculatePossibleCalleesRepresentation(@NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context, boolean isOnTheFly) {
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(27);
        }
        String string = (String)StreamEx.of(mappings).map(PyCallExpression.PyArgumentsMapping::getCallableType).nonNull().map(callableType -> XmlStringUtil.escapeString((String)PyArgumentListInspection.calculatePossibleCalleeRepresentation(callableType, context))).nonNull().collect(Collectors.joining(isOnTheFly ? "<br>" : " "));
        if (string == null) {
            PyArgumentListInspection.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    private static String calculatePossibleCalleeRepresentation(@NotNull PyCallableType callableType, @NotNull TypeEvalContext context) {
        if (callableType == null) {
            PyArgumentListInspection.$$$reportNull$$$0(29);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(30);
        }
        String name = callableType.getCallable() != null ? callableType.getCallable().getName() : "";
        List<PyCallableParameter> callableParameters = callableType.getParameters(context);
        if (callableParameters == null) {
            return null;
        }
        String parameters = ParamHelper.getPresentableText(callableParameters, true, context);
        String callableNameAndParameters = name + parameters;
        return Optional.ofNullable(PyUtil.as(callableType.getCallable(), PyFunction.class)).map(PyPossibleClassMember::getContainingClass).map(NavigationItem::getName).map(className -> "__init__".equals(name) ? className + parameters : className + "." + callableNameAndParameters).orElse(callableNameAndParameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 16: 
            case 20: 
            case 23: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyArgumentListInspection";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyArgumentListInspection";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addPossibleCalleesRepresentation";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleCalleesRepresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inspectPyArgumentList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "decoratedClassInitCall";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "objectMethodCallViaSuper";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateKeywordArguments";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "highlightUnexpectedArguments";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "highlightUnfilledParameters";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleCalleesRepresentation";
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleCalleesRepresentation";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleCalleeRepresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (session == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, session);
        }

        @Override
        @NotNull
        protected ProblemsHolder getHolder() {
            ProblemsHolder problemsHolder = super.getHolder();
            if (problemsHolder == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            return problemsHolder;
        }

        @Override
        public void visitPyArgumentList(PyArgumentList node) {
            PyArgumentListInspection.inspectPyArgumentList(node, this.getHolder(), this.getResolveContext());
        }

        @Override
        public void visitPyDecoratorList(PyDecoratorList node) {
            PyDecorator[] decorators;
            for (PyDecorator deco : decorators = node.getDecorators()) {
                PyCallableType callableType;
                if (deco.hasArgumentList() || (callableType = (PyCallableType)ContainerUtil.getFirstItem(deco.multiResolveCallee(this.getResolveContext()))) == null) continue;
                PyCallable callable = callableType.getCallable();
                if (callable == null) {
                    return;
                }
                int firstParamOffset = callableType.getImplicitOffset();
                List<PyCallableParameter> params = callableType.getParameters(this.myTypeEvalContext);
                if (params == null) {
                    return;
                }
                PyCallableParameter allegedFirstParam = (PyCallableParameter)ContainerUtil.getOrElse(params, (int)(firstParamOffset - 1), null);
                if (allegedFirstParam == null || allegedFirstParam.isKeywordContainer()) {
                    this.registerProblem((PsiElement)deco, PyPsiBundle.message("INSP.func.$0.lacks.first.arg", callable.getName()));
                    continue;
                }
                for (int i = firstParamOffset; i < params.size(); ++i) {
                    PyCallableParameter parameter = params.get(i);
                    if (parameter.getParameter() instanceof PySingleStarParameter || parameter.getParameter() instanceof PySlashParameter || parameter.isKeywordContainer() || parameter.isPositionalContainer() || parameter.hasDefaultValue()) continue;
                    String parameterName = parameter.getName();
                    this.registerProblem((PsiElement)deco, PyPsiBundle.message("INSP.parameter.$0.unfilled", parameterName == null ? "(...)" : parameterName));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyArgumentListInspection$Visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyArgumentListInspection$Visitor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

