/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInspection.HintAction;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptimizeImportsProcessor
extends AbstractLayoutCodeProcessor {
    @Deprecated
    public static final String COMMAND_NAME = "Optimize Imports";
    private final List<NotificationInfo> myOptimizerNotifications;

    public OptimizeImportsProcessor(@NotNull Project project) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(0);
        }
        super(project, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText(), false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, Module module) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(1);
        }
        super(project, module, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText(), false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, @NotNull PsiDirectory directory, boolean includeSubdirs) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(3);
        }
        super(project, directory, includeSubdirs, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, @NotNull PsiDirectory directory, boolean includeSubdirs, boolean processOnlyVcsChangedFiles) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(4);
        }
        if (directory == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(5);
        }
        super(project, directory, includeSubdirs, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), processOnlyVcsChangedFiles);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, @NotNull PsiFile file2) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(7);
        }
        super(project, file2, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, PsiFile @NotNull [] files2, Runnable postRunnable) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(8);
        }
        if (files2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(9);
        }
        this(project, files2, OptimizeImportsProcessor.getCommandName(), postRunnable);
    }

    public OptimizeImportsProcessor(@NotNull Project project, PsiFile @NotNull [] files2, @NotNull String commandName, Runnable postRunnable) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(10);
        }
        if (commandName == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(11);
        }
        if (files2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(12);
        }
        super(project, files2, OptimizeImportsProcessor.getProgressText(), commandName, postRunnable, false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull AbstractLayoutCodeProcessor processor2) {
        if (processor2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(13);
        }
        super(processor2, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText());
        this.myOptimizerNotifications = new SmartList();
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(14);
        }
        if (DumbService.isDumb((Project)file2.getProject())) {
            return OptimizeImportsProcessor.emptyTask();
        }
        List<Runnable> runnables = OptimizeImportsProcessor.collectOptimizers(file2);
        if (runnables.isEmpty()) {
            return OptimizeImportsProcessor.emptyTask();
        }
        List<HintAction> hints2 = ShowAutoImportPass.getImportHints(file2);
        return new FutureTask<Boolean>(() -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            CodeStyleManagerImpl.setSequentialProcessingAllowed(false);
            try {
                for (Runnable runnable1 : runnables) {
                    runnable1.run();
                    this.myOptimizerNotifications.add(OptimizeImportsProcessor.getNotificationInfo(runnable1));
                }
                this.putNotificationInfoIntoCollector();
                ShowAutoImportPass.fixAllImportsSilently(file2, hints2);
            }
            finally {
                CodeStyleManagerImpl.setSequentialProcessingAllowed(true);
            }
        }, true);
    }

    @NotNull
    private static FutureTask<Boolean> emptyTask() {
        return new FutureTask<Boolean>(EmptyRunnable.INSTANCE, true);
    }

    @NotNull
    static List<Runnable> collectOptimizers(@NotNull PsiFile file2) {
        if (file2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(15);
        }
        Set optimizers = LanguageImportStatements.INSTANCE.forFile(file2);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        List files2 = file2.getViewProvider().getAllFiles();
        for (ImportOptimizer optimizer : optimizers) {
            for (PsiFile psiFile : files2) {
                if (!optimizer.supports(psiFile)) continue;
                runnables.add(optimizer.processFile(psiFile));
            }
        }
        ArrayList<Runnable> arrayList = runnables;
        if (arrayList == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static NotificationInfo getNotificationInfo(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(17);
        }
        if (runnable2 instanceof ImportOptimizer.CollectingInfoRunnable) {
            String optimizerMessage = ((ImportOptimizer.CollectingInfoRunnable)runnable2).getUserNotificationInfo();
            return optimizerMessage == null ? NotificationInfo.NOTHING_CHANGED_NOTIFICATION : new NotificationInfo(optimizerMessage);
        }
        if (runnable2 == EmptyRunnable.getInstance()) {
            NotificationInfo notificationInfo = NotificationInfo.NOTHING_CHANGED_NOTIFICATION;
            if (notificationInfo == null) {
                OptimizeImportsProcessor.$$$reportNull$$$0(18);
            }
            return notificationInfo;
        }
        NotificationInfo notificationInfo = NotificationInfo.SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION;
        if (notificationInfo == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(19);
        }
        return notificationInfo;
    }

    private void putNotificationInfoIntoCollector() {
        LayoutCodeInfoCollector collector = this.getInfoCollector();
        if (collector == null) {
            return;
        }
        boolean atLeastOneOptimizerChangedSomething = false;
        for (NotificationInfo info : this.myOptimizerNotifications) {
            atLeastOneOptimizerChangedSomething |= info.isSomethingChanged();
            if (info.getMessage() == null) continue;
            collector.setOptimizeImportsNotification(info.getMessage());
            return;
        }
        collector.setOptimizeImportsNotification(atLeastOneOptimizerChangedSomething ? "imports optimized" : null);
    }

    @NotNull
    private static String getProgressText() {
        String string = CodeInsightBundle.message((String)"progress.text.optimizing.imports", (Object[])new Object[0]);
        if (string == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String getCommandName() {
        String string = CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]);
        if (string == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/OptimizeImportsProcessor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/OptimizeImportsProcessor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOptimizers";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationInfo";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareTask";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectOptimizers";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class NotificationInfo {
        static final NotificationInfo NOTHING_CHANGED_NOTIFICATION = new NotificationInfo(false, null);
        static final NotificationInfo SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION = new NotificationInfo(true, null);
        private final boolean mySomethingChanged;
        private final String myMessage;

        NotificationInfo(@NotNull String message) {
            if (message == null) {
                NotificationInfo.$$$reportNull$$$0(0);
            }
            this(true, message);
        }

        public boolean isSomethingChanged() {
            return this.mySomethingChanged;
        }

        public String getMessage() {
            return this.myMessage;
        }

        private NotificationInfo(boolean isSomethingChanged, @Nullable String message) {
            this.mySomethingChanged = isSomethingChanged;
            this.myMessage = message;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/actions/OptimizeImportsProcessor$NotificationInfo", "<init>"));
        }
    }
}

