/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.codeInsight.hints.presentation.TextInlayPresentation$WhenMappings;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.paint.EffectPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/hints/presentation/TextInlayPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "metricsStorage", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "isSmall", "", "text", "", "(Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;ZLjava/lang/String;)V", "height", "", "getHeight", "()I", "()Z", "getMetricsStorage", "()Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "width", "getWidth", "getMetrics", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "intellij.platform.lang.impl"})
public final class TextInlayPresentation
extends BasePresentation {
    @NotNull
    private final InlayTextMetricsStorage metricsStorage;
    private final boolean isSmall;
    @NotNull
    private String text;

    public int getWidth() {
        return this.getMetrics().getStringWidth(this.text);
    }

    public int getHeight() {
        return this.getMetrics().getFontHeight();
    }

    private final InlayTextMetrics getMetrics() {
        return this.metricsStorage.getFontMetrics(this.isSmall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Object savedHint = g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        try {
            Color foreground = attributes.getForegroundColor();
            if (foreground == null) return;
            InlayTextMetrics metrics = this.getMetrics();
            Font font = metrics.getFont();
            g.setFont(font);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
            g.setColor(foreground);
            g.drawString(this.text, 0, metrics.getFontBaseline());
            Color effectColor = attributes.getEffectColor();
            if (effectColor == null) return;
            g.setColor(effectColor);
            EffectType effectType = attributes.getEffectType();
            if (effectType == null) {
                return;
            }
            switch (TextInlayPresentation$WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
                case 1: {
                    EffectPainter.LINE_UNDERSCORE.paint(g, 0, metrics.getAscent(), this.getWidth(), metrics.getDescent(), (Object)font);
                    return;
                }
                case 2: {
                    EffectPainter.BOLD_LINE_UNDERSCORE.paint(g, 0, metrics.getAscent(), this.getWidth(), metrics.getDescent(), (Object)font);
                    return;
                }
                case 3: {
                    EffectPainter.STRIKE_THROUGH.paint(g, 0, metrics.getAscent(), this.getWidth(), this.getHeight(), (Object)font);
                    return;
                }
                case 4: {
                    EffectPainter.WAVE_UNDERSCORE.paint(g, 0, metrics.getAscent(), this.getWidth(), metrics.getDescent(), (Object)font);
                    return;
                }
                case 5: {
                    EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g, 0, metrics.getAscent(), this.getWidth(), metrics.getDescent(), (Object)font);
                    return;
                }
            }
            return;
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
        }
    }

    @NotNull
    public String toString() {
        return this.text;
    }

    @NotNull
    public final InlayTextMetricsStorage getMetricsStorage() {
        return this.metricsStorage;
    }

    public final boolean isSmall() {
        return this.isSmall;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.text = string;
    }

    public TextInlayPresentation(@NotNull InlayTextMetricsStorage metricsStorage, boolean isSmall, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)metricsStorage, (String)"metricsStorage");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.metricsStorage = metricsStorage;
        this.isSmall = isSmall;
        this.text = text;
    }
}

