/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffChangeUi {
    @NotNull
    protected final SimpleDiffViewer myViewer;
    @NotNull
    protected final SimpleDiffChange myChange;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters;
    @NotNull
    protected final List<DiffGutterOperation> myOperations;

    public SimpleDiffChangeUi(@NotNull SimpleDiffViewer viewer, @NotNull SimpleDiffChange change) {
        if (viewer == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(0);
        }
        if (change == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(1);
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<DiffGutterOperation>();
        this.myViewer = viewer;
        this.myChange = change;
    }

    public void installHighlighter(@Nullable SimpleDiffChange previousChange) {
        assert (this.myHighlighters.isEmpty() && this.myOperations.isEmpty());
        this.createHighlighter(Side.LEFT);
        this.createHighlighter(Side.RIGHT);
        List innerFragments = this.myChange.getFragment().getInnerFragments();
        for (DiffFragment fragment : ContainerUtil.notNullize((List)innerFragments)) {
            this.createInlineHighlighter(fragment, Side.LEFT);
            this.createInlineHighlighter(fragment, Side.RIGHT);
        }
        this.createNonSquashedChangesSeparator(previousChange, Side.LEFT);
        this.createNonSquashedChangesSeparator(previousChange, Side.RIGHT);
        this.doInstallActionHighlighters();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    protected void doInstallActionHighlighters() {
        if (this.myChange.isSkipped()) {
            return;
        }
        this.myOperations.add(this.createAcceptOperation(Side.LEFT));
        this.myOperations.add(this.createAcceptOperation(Side.RIGHT));
    }

    private void createHighlighter(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(2);
        }
        EditorEx editor = this.myViewer.getEditor(side);
        TextDiffType type = this.myChange.getDiffType();
        int startLine = this.myChange.getStartLine(side);
        int endLine = this.myChange.getEndLine(side);
        boolean ignored = this.myChange.getFragment().getInnerFragments() != null;
        this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(this.myChange.isExcluded()).done());
    }

    private void createInlineHighlighter(@NotNull DiffFragment innerFragment, @NotNull Side side) {
        if (innerFragment == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(3);
        }
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(4);
        }
        if (this.myChange.isSkipped()) {
            return;
        }
        int start2 = side.getStartOffset(innerFragment);
        int end = side.getEndOffset(innerFragment);
        TextDiffType type = DiffUtil.getDiffType(innerFragment);
        int startOffset = side.getStartOffset((DiffFragment)this.myChange.getFragment());
        EditorEx editor = this.myViewer.getEditor(side);
        this.myHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, start2 += startOffset, end += startOffset, type));
    }

    private void createNonSquashedChangesSeparator(@Nullable SimpleDiffChange previousChange, @NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(5);
        }
        if (previousChange == null) {
            return;
        }
        int startLine = this.myChange.getStartLine(side);
        int endLine = this.myChange.getEndLine(side);
        int prevStartLine = previousChange.getStartLine(side);
        int prevEndLine = previousChange.getEndLine(side);
        if (startLine == endLine) {
            return;
        }
        if (prevStartLine == prevEndLine) {
            return;
        }
        if (prevEndLine != startLine) {
            return;
        }
        this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(this.myViewer.getEditor(side), startLine, TextDiffType.MODIFIED));
    }

    public void updateGutterActions(boolean force) {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    public void invalidate() {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    @NotNull
    protected DiffGutterOperation createOperation(@NotNull Side side, @NotNull DiffGutterOperation.ModifiersRendererBuilder builder2) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(6);
        }
        if (builder2 == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(7);
        }
        int offset = side.getStartOffset((DiffFragment)this.myChange.getFragment());
        EditorEx editor = this.myViewer.getEditor(side);
        return new DiffGutterOperation.WithModifiers(editor, offset, this.myViewer.getModifierProvider(), builder2);
    }

    @NotNull
    private DiffGutterOperation createAcceptOperation(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(8);
        }
        DiffGutterOperation diffGutterOperation = this.createOperation(side, (ctrlPressed, shiftPressed, altPressed) -> {
            boolean isAppendable;
            boolean isOtherEditable = this.myViewer.isEditable(side.other());
            boolean bl = isAppendable = this.myChange.getDiffType() == TextDiffType.MODIFIED;
            if (isOtherEditable) {
                if (ctrlPressed && isAppendable) {
                    return this.createAppendRenderer(side);
                }
                return this.createApplyRenderer(side);
            }
            return null;
        });
        if (diffGutterOperation == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(9);
        }
        return diffGutterOperation;
    }

    private GutterIconRenderer createApplyRenderer(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(10);
        }
        Icon icon2 = DiffUtil.getArrowIcon(side);
        String text = side == Side.LEFT && this.myViewer.isDiffForLocalChanges() ? DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]) : DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
        String actionId = (String)side.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide");
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
        String shortcutsText = StringUtil.nullize((String)KeymapUtil.getShortcutsText((Shortcut[])shortcuts));
        String tooltipText = DiffUtil.createTooltipText(text, shortcutsText);
        return this.createIconRenderer(side, tooltipText, icon2, () -> this.myViewer.replaceChange(this.myChange, side));
    }

    private GutterIconRenderer createAppendRenderer(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(11);
        }
        return this.createIconRenderer(side, DiffBundle.message((String)"action.presentation.diff.append.text", (Object[])new Object[0]), DiffUtil.getArrowDownIcon(side), () -> this.myViewer.appendChange(this.myChange, side));
    }

    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull @Nls String tooltipText, @NotNull Icon icon2, final @NotNull Runnable perform2) {
        if (sourceSide == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(12);
        }
        if (tooltipText == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(13);
        }
        if (icon2 == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(14);
        }
        if (perform2 == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(15);
        }
        return new DiffGutterRenderer(icon2, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (!SimpleDiffChangeUi.this.myChange.isValid()) {
                    return;
                }
                Project project = SimpleDiffChangeUi.this.myViewer.getProject();
                DocumentEx document = SimpleDiffChangeUi.this.myViewer.getEditor(sourceSide.other()).getDocument();
                DiffUtil.executeWriteCommand(document, project, DiffBundle.message((String)"message.replace.change.command", (Object[])new Object[0]), perform2);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerFragment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffChangeUi";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffChangeUi";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAcceptOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInlineHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNonSquashedChangesSeparator";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAcceptOperation";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createApplyRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAppendRenderer";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

