/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.internal.statistic.collectors.fus.ui.persistence.ToolbarClicksCollector;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.TooltipLinkProvider;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionButton
extends JComponent
implements ActionButtonComponent,
AnActionHolder,
Accessible {
    public static final Key<Boolean> HIDE_DROPDOWN_ICON = Key.create((String)"HIDE_DROPDOWN_ICON");
    private JBDimension myMinimumButtonSize;
    private PropertyChangeListener myPresentationListener;
    private Icon myDisabledIcon;
    private Icon myIcon;
    protected final Presentation myPresentation;
    protected final AnAction myAction;
    protected final String myPlace;
    protected final PopupState myPopupState;
    private ActionButtonLook myLook;
    private boolean myMouseDown;
    private boolean myRollover;
    private static boolean ourGlobalMouseDown;
    private boolean myNoIconsInPopup;
    private Insets myInsets;
    private static final Set<String> WHITE_LIST;

    public ActionButton(@NotNull AnAction action2, Presentation presentation2, String place, @NotNull Dimension minimumSize) {
        if (action2 == null) {
            ActionButton.$$$reportNull$$$0(0);
        }
        if (minimumSize == null) {
            ActionButton.$$$reportNull$$$0(1);
        }
        this.myPopupState = new PopupState();
        this.myLook = ActionButtonLook.SYSTEM_LOOK;
        this.setMinimumButtonSize(minimumSize);
        this.setIconInsets(null);
        this.myRollover = false;
        this.myMouseDown = false;
        this.myAction = action2;
        this.myPresentation = presentation2;
        this.myPlace = place;
        this.setFocusable(ScreenReader.isActive());
        this.enableEvents(16L);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                    ActionButton.this.click();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ActionButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ActionButton.this.repaint();
            }
        });
        this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
    }

    public void setNoIconsInPopup(boolean noIconsInPopup) {
        this.myNoIconsInPopup = noIconsInPopup;
    }

    public void setMinimumButtonSize(@NotNull Dimension size) {
        if (size == null) {
            ActionButton.$$$reportNull$$$0(2);
        }
        this.myMinimumButtonSize = JBDimension.create((Dimension)size);
    }

    @Override
    public void paintChildren(Graphics g) {
    }

    public int getPopState() {
        return this.getPopState(this.isSelected());
    }

    protected final boolean isRollover() {
        return this.myRollover;
    }

    public final boolean isSelected() {
        return this.myAction instanceof Toggleable && Toggleable.isSelected((Presentation)this.myPresentation);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.myPresentation.isEnabled();
    }

    boolean isButtonEnabled() {
        return this.isEnabled();
    }

    private void onMousePresenceChanged(boolean setInfo) {
        ActionMenu.showDescriptionInStatusBar(setInfo, this, this.myPresentation.getDescription());
    }

    public void click() {
        this.performAction(new MouseEvent(this, 500, System.currentTimeMillis(), 0, 0, 0, 1, false));
    }

    private void performAction(MouseEvent e) {
        AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)e, (String)this.myPlace, (Presentation)this.myPresentation, (DataContext)this.getDataContext(), (boolean)false, (boolean)true);
        if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)this.myAction, (AnActionEvent)event, (boolean)false)) {
            return;
        }
        if (this.isButtonEnabled()) {
            ActionToolbar toolbar;
            ActionManagerEx manager = ActionManagerEx.getInstanceEx();
            DataContext dataContext = event.getDataContext();
            manager.fireBeforeActionPerformed(this.myAction, dataContext, event);
            Component component2 = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            if (component2 != null && !component2.isShowing()) {
                return;
            }
            this.actionPerformed(event);
            manager.queueActionPerformedEvent(this.myAction, dataContext, event);
            if (event.getInputEvent() instanceof MouseEvent) {
                ToolbarClicksCollector.record(this.myAction, this.myPlace, e, dataContext);
            }
            if ((toolbar = this.getActionToolbar()) != null) {
                toolbar.updateActionsImmediately();
            }
        }
    }

    protected DataContext getDataContext() {
        ActionToolbar actionToolbar = this.getActionToolbar();
        return actionToolbar != null ? actionToolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext();
    }

    private ActionToolbar getActionToolbar() {
        return (ActionToolbar)ComponentUtil.getParentOfType(ActionToolbar.class, (Component)this);
    }

    protected void actionPerformed(AnActionEvent event) {
        HelpTooltip.hide((Component)this);
        if (ActionButton.isPopupMenuAction(event, this.myAction)) {
            this.showPopupMenu(event, (ActionGroup)this.myAction);
        } else {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)this.myAction, (AnActionEvent)event, (DataContext)event.getDataContext());
        }
    }

    protected void showPopupMenu(AnActionEvent event, ActionGroup actionGroup) {
        if (this.myPopupState.isRecentlyHidden()) {
            return;
        }
        ActionManagerImpl am = (ActionManagerImpl)ActionManager.getInstance();
        String place = ActionPlaces.getActionGroupPopupPlace((String)event.getPlace());
        ActionPopupMenuImpl popupMenu = (ActionPopupMenuImpl)am.createActionPopupMenu(place, actionGroup, new MenuItemPresentationFactory(){

            @Override
            protected void processPresentation(Presentation presentation2) {
                super.processPresentation(presentation2);
                if (ActionButton.this.myNoIconsInPopup) {
                    presentation2.setIcon(null);
                    presentation2.setHoveredIcon(null);
                }
            }
        });
        popupMenu.setDataContextProvider((Getter<? extends DataContext>)((Getter)() -> this.getDataContext()));
        popupMenu.getComponent().addPopupMenuListener((PopupMenuListener)this.myPopupState);
        if (event.isFromActionToolbar()) {
            popupMenu.getComponent().show(this, 0, this.getHeight());
        } else {
            popupMenu.getComponent().show(this, this.getWidth(), 0);
        }
    }

    private static boolean isPopupMenuAction(AnActionEvent event, AnAction action2) {
        return action2 instanceof ActionGroup && !(action2 instanceof CustomComponentAction) && ((ActionGroup)action2).isPopup() && !((ActionGroup)action2).canBePerformed(event.getDataContext());
    }

    @Override
    public void removeNotify() {
        if (this.myRollover) {
            this.onMousePresenceChanged(false);
        }
        if (this.myPresentationListener != null) {
            this.myPresentation.removePropertyChangeListener(this.myPresentationListener);
            this.myPresentationListener = null;
        }
        this.myRollover = false;
        this.myMouseDown = false;
        HelpTooltip.dispose((Component)this);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.myPresentationListener == null) {
            this.myPresentationListener = this::presentationPropertyChanged;
            this.myPresentation.addPropertyChangeListener(this.myPresentationListener);
        }
        this.update();
    }

    public void update() {
        AnActionEvent e = AnActionEvent.createFromInputEvent(null, (String)this.myPlace, (Presentation)this.myPresentation, (DataContext)this.getDataContext(), (boolean)false, (boolean)true);
        ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)this.myAction, (AnActionEvent)e, (boolean)false);
        this.updateToolTipText();
        this.updateIcon();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        if (!Registry.is((String)"ide.helptooltip.enabled")) {
            while (StringUtil.endsWithChar((CharSequence)toolTipText, (char)'.')) {
                toolTipText = toolTipText.substring(0, toolTipText.length() - 1);
            }
            String shortcutsText = this.getShortcutText();
            if (StringUtil.isNotEmpty((String)shortcutsText)) {
                toolTipText = toolTipText + " (" + shortcutsText + ")";
            }
            super.setToolTipText(StringUtil.isNotEmpty((String)toolTipText) ? toolTipText : null);
        }
    }

    @Override
    public Insets getInsets() {
        ActionToolbarImpl owner = (ActionToolbarImpl)ComponentUtil.getParentOfType(ActionToolbarImpl.class, (Component)this);
        return owner != null && owner.getOrientation() == 1 ? JBInsets.create((int)2, (int)1) : JBInsets.create((int)1, (int)2);
    }

    @Override
    public void updateUI() {
        if (this.myLook != null) {
            this.myLook.updateUI();
        }
        this.updateToolTipText();
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon2;
        if (this.myMinimumButtonSize != null) {
            this.myMinimumButtonSize.update();
        }
        Dimension size = (icon2 = this.getIcon()).getIconWidth() < this.myMinimumButtonSize.width && icon2.getIconHeight() < this.myMinimumButtonSize.height ? new Dimension((Dimension)this.myMinimumButtonSize) : new Dimension(Math.max(this.myMinimumButtonSize.width, icon2.getIconWidth() + this.myInsets.left + this.myInsets.right), Math.max(this.myMinimumButtonSize.height, icon2.getIconHeight() + this.myInsets.top + this.myInsets.bottom));
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    public void setIconInsets(@Nullable Insets insets) {
        this.myInsets = insets != null ? JBUI.insets((Insets)insets) : JBUI.emptyInsets();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Icon getIcon() {
        Icon hoveredIcon;
        boolean enabled = this.isButtonEnabled();
        int popState = this.getPopState();
        Icon icon2 = hoveredIcon = popState == 1 || popState == -1 ? this.myPresentation.getHoveredIcon() : null;
        Icon icon3 = enabled ? (hoveredIcon != null ? hoveredIcon : this.myIcon) : this.myDisabledIcon;
        return icon3 == null ? this.getFallbackIcon(enabled) : icon3;
    }

    @NotNull
    protected Icon getFallbackIcon(boolean enabled) {
        Icon icon2 = EmptyIcon.ICON_18;
        if (icon2 == null) {
            ActionButton.$$$reportNull$$$0(3);
        }
        return icon2;
    }

    public void updateIcon() {
        this.myIcon = this.myPresentation.getIcon();
        if (this.myPresentation.getDisabledIcon() != null) {
            this.myDisabledIcon = this.myPresentation.getDisabledIcon();
        } else if (this.myIcon == null) {
            this.myDisabledIcon = null;
        } else if (IconLoader.isGoodSize((Icon)this.myIcon)) {
            this.myDisabledIcon = IconLoader.getDisabledIcon((Icon)this.myIcon);
        } else {
            this.myDisabledIcon = null;
            Logger.getInstance(ActionButton.class).error("invalid icon (" + this.myIcon + ") for action " + this.myAction.getClass());
        }
    }

    protected void updateToolTipText() {
        String text = this.myPresentation.getText();
        String description = this.myPresentation.getDescription();
        if (Registry.is((String)"ide.helptooltip.enabled")) {
            HelpTooltip.dispose((Component)this);
            if (StringUtil.isNotEmpty((String)text) || StringUtil.isNotEmpty((String)description)) {
                Pair link;
                HelpTooltip ht = new HelpTooltip().setTitle(text).setShortcut(this.getShortcutText());
                if (this.myAction instanceof TooltipLinkProvider && (link = ((TooltipLinkProvider)this.myAction).getTooltipLink((JComponent)this)) != null) {
                    ht.setLink((String)link.first, (Runnable)link.second);
                }
                String id2 = ActionManager.getInstance().getId(this.myAction);
                if (!StringUtil.equals((CharSequence)text, (CharSequence)description) && WHITE_LIST.contains(id2)) {
                    ht.setDescription(description);
                }
                ht.installOn((JComponent)this);
            }
        } else {
            this.setToolTipText(text == null ? description : text);
        }
    }

    @Nullable
    protected String getShortcutText() {
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)this.myAction);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.jComponentPaint(g);
        this.paintButtonLook(g);
        if (this.shallPaintDownArrow()) {
            this.paintDownArrow(g);
        }
    }

    protected void jComponentPaint(Graphics g) {
        super.paintComponent(g);
    }

    protected boolean shallPaintDownArrow() {
        if (!(this.myAction instanceof ActionGroup) || !((ActionGroup)this.myAction).isPopup()) {
            return false;
        }
        if (Boolean.TRUE == this.myAction.getTemplatePresentation().getClientProperty(HIDE_DROPDOWN_ICON)) {
            return false;
        }
        return Boolean.TRUE != this.myPresentation.getClientProperty(HIDE_DROPDOWN_ICON);
    }

    private void paintDownArrow(Graphics g) {
        Container parent = this.getParent();
        boolean horizontal = !(parent instanceof ActionToolbarImpl) || ((ActionToolbarImpl)parent).getOrientation() == 0;
        int x = horizontal ? JBUIScale.scale((int)6) : JBUIScale.scale((int)5);
        int y = horizontal ? JBUIScale.scale((int)5) : JBUIScale.scale((int)6);
        Icon arrowIcon = this.isButtonEnabled() ? AllIcons.General.Dropdown : IconLoader.getDisabledIcon((Icon)AllIcons.General.Dropdown);
        arrowIcon.paintIcon(this, g, x, y);
    }

    protected void paintButtonLook(Graphics g) {
        ActionButtonLook look = this.getButtonLook();
        if (this.isEnabled() || !StartupUiUtil.isUnderDarcula()) {
            look.paintBackground(g, this);
        }
        look.paintIcon(g, this, this.getIcon());
        look.paintBorder(g, this);
    }

    protected ActionButtonLook getButtonLook() {
        return this.myLook;
    }

    public void setLook(ActionButtonLook look) {
        this.myLook = look == null ? ActionButtonLook.SYSTEM_LOOK : look;
        this.repaint();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        IdeMouseEventDispatcher.requestFocusInNonFocusedWindow(e);
        super.processMouseEvent(e);
        if (e.isConsumed()) {
            return;
        }
        boolean skipPress = ActionButton.checkSkipPressForEvent(e);
        switch (e.getID()) {
            case 501: {
                if (skipPress || !this.isButtonEnabled()) {
                    return;
                }
                this.myMouseDown = true;
                this.onMousePressed(e);
                ourGlobalMouseDown = true;
                this.repaint();
                break;
            }
            case 502: {
                if (skipPress || !this.isButtonEnabled()) {
                    return;
                }
                this.myMouseDown = false;
                ourGlobalMouseDown = false;
                this.onMouseReleased(e);
                if (this.myRollover) {
                    this.performAction(e);
                }
                this.repaint();
                break;
            }
            case 504: {
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.myRollover = true;
                this.repaint();
                this.onMousePresenceChanged(true);
                break;
            }
            case 505: {
                this.myRollover = false;
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.repaint();
                this.onMousePresenceChanged(false);
            }
        }
    }

    protected void onMouseReleased(@NotNull MouseEvent e) {
        if (e == null) {
            ActionButton.$$$reportNull$$$0(4);
        }
    }

    protected void onMousePressed(@NotNull MouseEvent e) {
        if (e == null) {
            ActionButton.$$$reportNull$$$0(5);
        }
    }

    private static boolean checkSkipPressForEvent(@NotNull MouseEvent e) {
        if (e == null) {
            ActionButton.$$$reportNull$$$0(6);
        }
        return e.isMetaDown() || e.getButton() != 1;
    }

    private int getPopState(boolean isPushed) {
        if (isPushed || this.myRollover && this.myMouseDown && this.isButtonEnabled()) {
            return -1;
        }
        if (this.myRollover && this.isButtonEnabled()) {
            return 1;
        }
        if (this.isFocusOwner()) {
            return 2;
        }
        return 0;
    }

    public AnAction getAction() {
        return this.myAction;
    }

    protected void presentationPropertyChanged(@NotNull PropertyChangeEvent e) {
        String propertyName;
        if (e == null) {
            ActionButton.$$$reportNull$$$0(7);
        }
        if ("text".equals(propertyName = e.getPropertyName()) || "description".equals(propertyName)) {
            this.updateToolTipText();
        } else if ("enabled".equals(propertyName) || "icon".equals(propertyName)) {
            this.updateIcon();
            this.repaint();
        } else if ("disabledIcon".equals(propertyName)) {
            this.myDisabledIcon = this.myPresentation.getDisabledIcon();
            this.repaint();
        } else if ("selected".equals(propertyName)) {
            this.repaint();
        } else if (HIDE_DROPDOWN_ICON.toString().equals(propertyName)) {
            this.repaint();
        }
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        AccessibleContext context = this.accessibleContext;
        if (context == null) {
            this.accessibleContext = context = new AccessibleActionButton();
        }
        AccessibleContext accessibleContext = context;
        if (accessibleContext == null) {
            ActionButton.$$$reportNull$$$0(8);
        }
        return accessibleContext;
    }

    static {
        WHITE_LIST = ContainerUtil.immutableSet((Object[])new String[]{"ExternalSystem.ProjectRefreshAction", "LoadConfigurationAction"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumSize";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionButton";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFallbackIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setMinimumButtonSize";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onMouseReleased";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onMousePressed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkSkipPressForEvent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "presentationPropertyChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleActionButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        AccessibleActionButton() {
            super(ActionButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public String getAccessibleName() {
            String name = this.accessibleName;
            if (name == null && (name = (String)ActionButton.this.getClientProperty("AccessibleName")) == null && (name = ActionButton.this.getToolTipText()) == null && (name = ActionButton.this.myPresentation.getText()) == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public String getAccessibleDescription() {
            return AccessibleContextUtil.getUniqueDescription((AccessibleContext)this, (String)super.getAccessibleDescription());
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleContext context;
            Icon icon2 = ActionButton.this.getIcon();
            if (icon2 instanceof Accessible && (context = ((Accessible)((Object)icon2)).getAccessibleContext()) instanceof AccessibleIcon) {
                return new AccessibleIcon[]{(AccessibleIcon)((Object)context)};
            }
            return null;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet var1 = super.getAccessibleStateSet();
            int state = ActionButton.this.getPopState();
            if (state == -1) {
                var1.add(AccessibleState.PRESSED);
            }
            if (state == 2) {
                var1.add(AccessibleState.CHECKED);
            }
            if (ActionButton.this.isFocusOwner()) {
                var1.add(AccessibleState.FOCUSED);
            }
            return var1;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index) {
            return index == 0 ? UIManager.getString("AbstractButton.clickText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index) {
            if (index == 0) {
                ActionButton.this.click();
                return true;
            }
            return false;
        }
    }
}

