/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import javax.swing.Icon;

public class NewFileAction
extends FileChooserAction
implements LightEditCompatible {
    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        FileType fileType = (FileType)e.getData(FileChooserKeys.NEW_FILE_TYPE);
        if (fileType != null) {
            presentation2.setVisible(true);
            VirtualFile selectedFile = fileSystemTree.getNewFileParent();
            presentation2.setEnabled(selectedFile != null && selectedFile.isDirectory());
            presentation2.setIcon(LayeredIcon.create((Icon)fileType.getIcon(), (Icon)AllIcons.Actions.New));
        } else {
            presentation2.setVisible(false);
        }
    }

    @Override
    protected void actionPerformed(FileSystemTree fileSystemTree, AnActionEvent e) {
        FileType fileType = (FileType)e.getData(FileChooserKeys.NEW_FILE_TYPE);
        String initialContent = (String)e.getData(FileChooserKeys.NEW_FILE_TEMPLATE_TEXT);
        if (fileType != null && initialContent != null) {
            NewFileAction.createNewFile(fileSystemTree, fileType, initialContent);
        }
    }

    private static void createNewFile(FileSystemTree fileSystemTree, FileType fileType, String initialContent) {
        VirtualFile file2 = fileSystemTree.getNewFileParent();
        if (file2 == null || !file2.isDirectory()) {
            return;
        }
        while (true) {
            String newFileName;
            if ((newFileName = Messages.showInputDialog((String)UIBundle.message((String)"create.new.file.enter.new.file.name.prompt.text", (Object[])new Object[0]), (String)UIBundle.message((String)"new.file.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == null) {
                return;
            }
            if ("".equals(newFileName.trim())) {
                Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.file.name.cannot.be.empty.error.message", (Object[])new Object[0]), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                continue;
            }
            Exception failReason = ((FileSystemTreeImpl)fileSystemTree).createNewFile(file2, newFileName, fileType, initialContent);
            if (failReason == null) break;
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{newFileName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }
}

