/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeEP;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.UnknownModuleType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleTypeManagerImpl
extends ModuleTypeManager {
    private static final Logger LOG = Logger.getInstance(ModuleTypeManagerImpl.class);
    @ApiStatus.Internal
    public static final ExtensionPointName<ModuleTypeEP> EP_NAME = new ExtensionPointName("com.intellij.moduleType");
    private final LinkedHashMap<ModuleType<?>, Boolean> myModuleTypes = new LinkedHashMap();

    public ModuleTypeManagerImpl() {
        this.registerModuleType(this.getDefaultModuleType(), true);
        EP_NAME.processWithPluginDescriptor((ep2, pluginDescriptor) -> {
            if (ep2.id == null) {
                LOG.error((Throwable)new PluginException("'id' attribute isn't specified for <moduleType implementationClass='" + ep2.implementationClass + "'> extension", pluginDescriptor.getPluginId()));
            }
        });
    }

    public void registerModuleType(ModuleType type) {
        this.registerModuleType(type, false);
    }

    public void unregisterModuleType(ModuleType<?> type) {
        this.myModuleTypes.remove(type);
    }

    public void registerModuleType(ModuleType type, boolean classpathProvider) {
        for (ModuleType<?> oldType : this.myModuleTypes.keySet()) {
            if (!oldType.getId().equals(type.getId())) continue;
            PluginException.logPluginError((Logger)LOG, (String)("Trying to register a module type that clashes with existing one. Old=" + oldType + ", new = " + type), null, type.getClass());
            return;
        }
        this.myModuleTypes.put(type, classpathProvider);
    }

    public ModuleType<?>[] getRegisteredTypes() {
        ArrayList result2 = new ArrayList(this.myModuleTypes.keySet());
        for (ModuleTypeEP moduleTypeEP : EP_NAME.getExtensionList()) {
            ModuleType moduleType = moduleTypeEP.getModuleType();
            if (this.myModuleTypes.containsKey(moduleType)) continue;
            result2.add(moduleType);
        }
        return result2.toArray(new ModuleType[0]);
    }

    public ModuleType<?> findByID(@Nullable String moduleTypeId) {
        if (moduleTypeId == null) {
            return this.getDefaultModuleType();
        }
        for (ModuleType<?> type : this.myModuleTypes.keySet()) {
            if (!type.getId().equals(moduleTypeId)) continue;
            return type;
        }
        ModuleTypeEP result2 = (ModuleTypeEP)EP_NAME.getByKey((Object)moduleTypeId, ModuleTypeManagerImpl.class, it -> it.id);
        if (result2 != null) {
            return result2.getModuleType();
        }
        return new UnknownModuleType(moduleTypeId, this.getDefaultModuleType());
    }

    public boolean isClasspathProvider(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            ModuleTypeManagerImpl.$$$reportNull$$$0(0);
        }
        for (ModuleTypeEP ep2 : EP_NAME.getExtensionList()) {
            if (!moduleType.getId().equals(ep2.id)) continue;
            return ep2.classpathProvider;
        }
        Boolean provider = this.myModuleTypes.get(moduleType);
        return provider != null && provider != false;
    }

    public ModuleType<?> getDefaultModuleType() {
        return EmptyModuleType.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/openapi/module/impl/ModuleTypeManagerImpl", "isClasspathProvider"));
    }
}

