/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.options.ex.Weighted;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableWrapper
implements SearchableConfigurable,
Weighted {
    static final Logger LOG = Logger.getInstance(ConfigurableWrapper.class);
    private final ConfigurableEP<?> myEp;
    int myWeight;
    @Nullable
    private UnnamedConfigurable myConfigurable;

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(@NotNull ConfigurableEP<T> ep2) {
        if (ep2 == null) {
            ConfigurableWrapper.$$$reportNull$$$0(0);
        }
        return ConfigurableWrapper.wrapConfigurable(ep2, false);
    }

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(@NotNull ConfigurableEP<T> ep2, boolean settings) {
        if (ep2 == null) {
            ConfigurableWrapper.$$$reportNull$$$0(1);
        }
        if (!ep2.canCreateConfigurable()) {
            return null;
        }
        if (settings || ep2.displayName != null || ep2.key != null || ep2.parentId != null || ep2.groupId != null) {
            return (T)(!ep2.dynamic && ep2.children == null && ep2.childrenEPName == null ? new ConfigurableWrapper(ep2) : new CompositeWrapper((ConfigurableEP)ep2, new Configurable[0]));
        }
        return ConfigurableWrapper.createConfigurable(ep2, LOG.isDebugEnabled());
    }

    @Nullable
    private static <T extends UnnamedConfigurable> T createConfigurable(@NotNull ConfigurableEP<T> ep2, boolean log) {
        if (ep2 == null) {
            ConfigurableWrapper.$$$reportNull$$$0(2);
        }
        long time = System.currentTimeMillis();
        UnnamedConfigurable configurable2 = ep2.createConfigurable();
        if (configurable2 instanceof Configurable) {
            ConfigurableCardPanel.warn((Configurable)configurable2, "init", time);
            if (log) {
                LOG.debug("cannot create configurable wrapper for " + configurable2.getClass());
            }
        }
        return (T)configurable2;
    }

    public static <T extends UnnamedConfigurable> List<T> createConfigurables(@NotNull ExtensionPointName<? extends ConfigurableEP<T>> name) {
        List collection;
        if (name == null) {
            ConfigurableWrapper.$$$reportNull$$$0(3);
        }
        if ((collection = name.getExtensionList()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result2 = new ArrayList(collection.size());
        for (ConfigurableEP item : collection) {
            T o = ConfigurableWrapper.wrapConfigurable(item, false);
            if (o == null) continue;
            result2.add(o);
        }
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    public static boolean hasOwnContent(UnnamedConfigurable configurable2) {
        SearchableConfigurable.Parent parent = ConfigurableWrapper.cast(SearchableConfigurable.Parent.class, configurable2);
        return parent != null && parent.hasOwnContent();
    }

    public static boolean isNonDefaultProject(Configurable configurable2) {
        return configurable2 instanceof NonDefaultProjectConfigurable || configurable2 instanceof ConfigurableWrapper && ((ConfigurableWrapper)configurable2).myEp.nonDefaultProject;
    }

    @Nullable
    public static <T> T cast(@NotNull Class<T> type, UnnamedConfigurable configurable2) {
        if (type == null) {
            ConfigurableWrapper.$$$reportNull$$$0(4);
        }
        if (configurable2 instanceof ConfigurableWrapper) {
            Class configurableType;
            ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable2;
            if (wrapper2.myConfigurable == null && (configurableType = wrapper2.getExtensionPoint().getConfigurableType()) != null && !type.isAssignableFrom(configurableType)) {
                return null;
            }
            configurable2 = wrapper2.getConfigurable();
        }
        return type.isInstance(configurable2) ? (T)type.cast(configurable2) : null;
    }

    private ConfigurableWrapper(@NotNull ConfigurableEP<?> ep2) {
        if (ep2 == null) {
            ConfigurableWrapper.$$$reportNull$$$0(5);
        }
        this.myEp = ep2;
        this.myWeight = ep2.groupWeight;
    }

    @Nullable
    public UnnamedConfigurable getRawConfigurable() {
        return this.myConfigurable;
    }

    public UnnamedConfigurable getConfigurable() {
        if (this.myConfigurable == null) {
            this.myConfigurable = ConfigurableWrapper.createConfigurable(this.myEp, false);
            if (this.myConfigurable == null) {
                LOG.error("Can't instantiate configurable for " + this.myEp);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("created configurable for " + this.myConfigurable.getClass());
            }
        }
        return this.myConfigurable;
    }

    @Override
    public int getWeight() {
        return this.myWeight;
    }

    @Nls
    public String getDisplayName() {
        if (this.myEp.displayName == null && this.myEp.key == null) {
            boolean loaded = this.myConfigurable != null;
            Configurable configurable2 = ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)this);
            if (configurable2 != null) {
                String name = configurable2.getDisplayName();
                if (!loaded && LOG.isDebugEnabled()) {
                    LOG.debug("XML does not provide displayName for " + configurable2.getClass());
                }
                return name;
            }
        }
        return this.myEp.getDisplayName();
    }

    public String getProviderClass() {
        return this.myEp.providerClass;
    }

    @Nullable
    public Project getProject() {
        return this.myEp.getProject();
    }

    @Nullable
    public String getHelpTopic() {
        UnnamedConfigurable configurable2 = this.getConfigurable();
        return configurable2 instanceof Configurable ? ((Configurable)configurable2).getHelpTopic() : null;
    }

    @Nullable
    public JComponent createComponent() {
        UnnamedConfigurable configurable2 = this.getConfigurable();
        return configurable2 == null ? null : configurable2.createComponent();
    }

    public boolean isModified() {
        return this.getConfigurable().isModified();
    }

    public void apply() throws ConfigurationException {
        this.getConfigurable().apply();
    }

    public void reset() {
        this.getConfigurable().reset();
    }

    public void disposeUIResources() {
        UnnamedConfigurable configurable2 = this.myConfigurable;
        if (configurable2 != null) {
            configurable2.disposeUIResources();
            this.myConfigurable = null;
        }
    }

    public void cancel() {
        UnnamedConfigurable configurable2 = this.myConfigurable;
        if (configurable2 != null) {
            configurable2.cancel();
        }
    }

    @NotNull
    public String getId() {
        if (this.myEp.id != null) {
            String string = this.myEp.id;
            if (string == null) {
                ConfigurableWrapper.$$$reportNull$$$0(6);
            }
            return string;
        }
        boolean loaded = this.myConfigurable != null;
        SearchableConfigurable configurable2 = ConfigurableWrapper.cast(SearchableConfigurable.class, (UnnamedConfigurable)this);
        if (configurable2 != null) {
            String id2 = configurable2.getId();
            if (!loaded) {
                LOG.debug("XML does not provide id for " + configurable2.getClass());
            }
            String string = id2;
            if (string == null) {
                ConfigurableWrapper.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = this.myEp.providerClass != null ? this.myEp.providerClass : (this.myEp.instanceClass != null ? this.myEp.instanceClass : this.myEp.implementationClass);
        if (string == null) {
            ConfigurableWrapper.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public ConfigurableEP<?> getExtensionPoint() {
        ConfigurableEP<?> configurableEP = this.myEp;
        if (configurableEP == null) {
            ConfigurableWrapper.$$$reportNull$$$0(9);
        }
        return configurableEP;
    }

    public String getParentId() {
        return this.myEp.parentId;
    }

    public ConfigurableWrapper addChild(Configurable configurable2) {
        return new CompositeWrapper((ConfigurableEP)this.myEp, new Configurable[]{configurable2});
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        UnnamedConfigurable configurable2 = this.getConfigurable();
        return configurable2 instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable2).enableSearch(option2) : null;
    }

    @NotNull
    public Class<?> getOriginalClass() {
        UnnamedConfigurable configurable2 = this.getConfigurable();
        Class<?> clazz = configurable2 instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable2).getOriginalClass() : (configurable2 != null ? configurable2.getClass() : this.getClass());
        if (clazz == null) {
            ConfigurableWrapper.$$$reportNull$$$0(10);
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableWrapper";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurables";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cast";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompositeWrapper
    extends ConfigurableWrapper
    implements Configurable.Composite {
        private Configurable[] myKids;
        private Comparator<Configurable> myComparator;
        private boolean isInitialized;

        private CompositeWrapper(@NotNull ConfigurableEP ep2, Configurable ... kids) {
            if (ep2 == null) {
                CompositeWrapper.$$$reportNull$$$0(0);
            }
            super(ep2);
            this.myKids = kids;
        }

        public Configurable @NotNull [] getConfigurables() {
            Object composite;
            if (this.isInitialized) {
                if (this.myKids == null) {
                    CompositeWrapper.$$$reportNull$$$0(1);
                }
                return this.myKids;
            }
            long time = System.currentTimeMillis();
            ArrayList<Configurable> list2 = new ArrayList<Configurable>();
            if (((ConfigurableWrapper)this).myEp.dynamic && (composite = CompositeWrapper.cast(Configurable.Composite.class, (UnnamedConfigurable)this)) != null) {
                Collections.addAll(list2, composite.getConfigurables());
            }
            if (((ConfigurableWrapper)this).myEp.children != null) {
                for (ConfigurableEP ep2 : ((ConfigurableWrapper)this).myEp.getChildren()) {
                    if (!ep2.isAvailable()) continue;
                    list2.add((Configurable)CompositeWrapper.wrapConfigurable(ep2));
                }
            }
            if (((ConfigurableWrapper)this).myEp.childrenEPName != null) {
                List extensions2;
                Project project = ((ConfigurableWrapper)this).myEp.getProject();
                ExtensionsArea area = project == null ? ApplicationManager.getApplication().getExtensionArea() : project.getExtensionArea();
                ExtensionPoint point = area.getExtensionPointIfRegistered(((ConfigurableWrapper)this).myEp.childrenEPName);
                if (point == null) {
                    LOG.warn("Cannot find extension point " + ((ConfigurableWrapper)this).myEp.childrenEPName + " in " + area);
                    List extensions3 = Collections.emptyList();
                } else {
                    extensions2 = point.getExtensionList();
                }
                if (!extensions2.isEmpty()) {
                    Configurable.Composite composite2;
                    if (extensions2.get(0) instanceof ConfigurableEP) {
                        for (Object object : extensions2) {
                            list2.add((Configurable)CompositeWrapper.wrapConfigurable((ConfigurableEP)object));
                        }
                    } else if (!((ConfigurableWrapper)this).myEp.dynamic && (composite2 = CompositeWrapper.cast(Configurable.Composite.class, (UnnamedConfigurable)this)) != null) {
                        Collections.addAll(list2, composite2.getConfigurables());
                    }
                }
            }
            Collections.addAll(list2, this.myKids);
            for (Configurable configurable2 : list2) {
                if (!(configurable2 instanceof Weighted) || ((Weighted)configurable2).getWeight() == 0) continue;
                this.myComparator = COMPARATOR;
                list2.sort(this.myComparator);
                break;
            }
            this.myKids = list2.toArray(new Configurable[0]);
            this.isInitialized = true;
            ConfigurableCardPanel.warn((Configurable)this, "children", time);
            if (this.myKids == null) {
                CompositeWrapper.$$$reportNull$$$0(2);
            }
            return this.myKids;
        }

        @Override
        public ConfigurableWrapper addChild(Configurable configurable2) {
            if (this.myComparator != null) {
                int index = Arrays.binarySearch(this.myKids, configurable2, this.myComparator);
                LOG.assertTrue(index < 0, (Object)"similar configurable is already exist");
                this.myKids = (Configurable[])ArrayUtil.insert((Object[])this.myKids, (int)(-1 - index), (Object)configurable2);
            } else {
                this.myKids = (Configurable[])ArrayUtil.append((Object[])this.myKids, (Object)configurable2);
            }
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ep";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableWrapper$CompositeWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableWrapper$CompositeWrapper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

