/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.execution.CommandLineUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.WhatsNewAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.impl.HTMLEditorProvider;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInfoPanelUI;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UpdateInfoDialog
extends AbstractUpdateDialog {
    private final UpdateChannel myUpdatedChannel;
    private final Collection<PluginDownloader> myUpdatedPlugins;
    private final BuildInfo myNewBuild;
    private final UpdateChain myPatches;
    private final boolean myWriteProtected;
    private final Pair<String, Color> myLicenseInfo;
    private final File myTestPatch;
    private AbstractAction myWhatsNewAction;

    UpdateInfoDialog(@NotNull UpdateChannel channel, @NotNull BuildInfo newBuild, @Nullable UpdateChain patches2, boolean enableLink, @Nullable Collection<PluginDownloader> updatedPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> incompatiblePlugins) {
        if (channel == null) {
            UpdateInfoDialog.$$$reportNull$$$0(0);
        }
        if (newBuild == null) {
            UpdateInfoDialog.$$$reportNull$$$0(1);
        }
        super(enableLink);
        this.myUpdatedChannel = channel;
        this.myUpdatedPlugins = updatedPlugins;
        this.myNewBuild = newBuild;
        this.myPatches = patches2;
        this.myWriteProtected = this.myPatches != null && !SystemInfo.isWindows && !Files.isWritable(Paths.get(PathManager.getHomePath(), new String[0]));
        this.myLicenseInfo = UpdateInfoDialog.initLicensingInfo(this.myUpdatedChannel, this.myNewBuild);
        this.myTestPatch = null;
        this.init();
        if (!ContainerUtil.isEmpty(incompatiblePlugins)) {
            String list2 = StringUtil.join(incompatiblePlugins, PluginDescriptor::getName, (String)"<br/>");
            this.setErrorText(IdeBundle.message((String)"updates.incompatible.plugins.found", (Object[])new Object[]{incompatiblePlugins.size(), list2}));
        }
        IdeUpdateUsageTriggerCollector.triggerUpdateDialog(this.myPatches, ApplicationManager.getApplication().isRestartCapable());
    }

    UpdateInfoDialog(final @Nullable Project project, UpdateChannel channel, BuildInfo newBuild, UpdateChain patches2, @Nullable File patchFile) {
        super(true);
        this.myUpdatedChannel = channel;
        this.myUpdatedPlugins = null;
        this.myNewBuild = newBuild;
        this.myPatches = patches2;
        this.myWriteProtected = false;
        this.myLicenseInfo = UpdateInfoDialog.initLicensingInfo(this.myUpdatedChannel, this.myNewBuild);
        this.myTestPatch = patchFile;
        if (project != null) {
            this.myWhatsNewAction = new AbstractAction(IdeBundle.message((String)"button.what.s.new", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String title = IdeBundle.message((String)"update.whats.new.file.name", (Object[])new Object[]{ApplicationInfo.getInstance().getFullVersion()});
                    HTMLEditorProvider.Companion.openEditor(project, title, UpdateInfoDialog.this.myNewBuild.getBlogPost() + WhatsNewAction.getEmbeddedSuffix(), null, UpdateInfoDialog.this.myNewBuild.getMessage());
                    UpdateInfoDialog.this.close(0);
                }
            };
        }
        this.init();
        this.setTitle("[TEST] " + this.getTitle());
    }

    private static Pair<String, Color> initLicensingInfo(UpdateChannel channel, BuildInfo build2) {
        LicensingFacade la = LicensingFacade.getInstance();
        if (la == null) {
            return null;
        }
        if (channel.getLicensing().equals("eap")) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.channel.bundled.key", (Object[])new Object[0]), null);
        }
        Date releaseDate = build2.getReleaseDate();
        if (releaseDate == null) {
            return null;
        }
        if (!la.isApplicableForProduct(releaseDate)) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.paid.upgrade", (Object[])new Object[]{channel.getEvalDays()}), (Object)JBColor.RED);
        }
        if (la.isPerpetualForProduct(releaseDate)) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.fallback.build", (Object[])new Object[0]), null);
        }
        Date expiration = la.getLicenseExpirationDate();
        if (expiration != null) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.interim.build", (Object[])new Object[]{DateFormatUtil.formatAboutDialogDate((Date)expiration)}), null);
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return UpdateInfoPanelUI.INSTANCE.createPanel(this.myNewBuild, this.myPatches, this.myTestPatch, this.myWriteProtected, this.myLicenseInfo, this.myEnableLink, this.myUpdatedChannel);
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            UpdateInfoDialog.$$$reportNull$$$0(2);
        }
        return dialogStyle;
    }

    protected JComponent createSouthPanel() {
        JComponent component2 = super.createSouthPanel();
        component2.setBorder(JBUI.Borders.empty((int)8));
        return component2;
    }

    protected Action @NotNull [] createLeftSideActions() {
        Action[] actionArray = (Action[])ContainerUtil.ar((Object[])new 2[]{new AbstractAction(IdeBundle.message((String)"updates.ignore.update.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                String build2 = UpdateInfoDialog.this.myNewBuild.getNumber().asStringWithoutProductCode();
                UpdateSettings.getInstance().getIgnoredBuildNumbers().add(build2);
                UpdateInfoDialog.this.doCancelAction();
            }
        }});
        if (actionArray == null) {
            UpdateInfoDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    protected Action @NotNull [] createActions() {
        boolean canRestart;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getCancelAction());
        AbstractAction updateButton = this.myPatches != null || this.myTestPatch != null ? new AbstractAction(IdeBundle.message((String)((canRestart = ApplicationManager.getApplication().isRestartCapable()) ? "updates.download.and.restart.button" : "updates.apply.manually.button"), (Object[])new Object[0])){
            {
                this.setEnabled(!UpdateInfoDialog.this.myWriteProtected);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateInfoDialog.this.close(0);
                UpdateInfoDialog.this.downloadPatchAndRestart();
            }
        } : (AbstractAction)this.myNewBuild.getButtons().stream().filter(info -> info.isDownload()).findAny().map(info -> new AbstractAction(info.getName(), (ButtonInfo)info){
            final /* synthetic */ ButtonInfo val$info;
            {
                this.val$info = buttonInfo;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateInfoDialog.this.close(0);
                BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl(this.val$info.getUrl()));
            }
        }).orElse(null);
        if (updateButton != null) {
            updateButton.putValue("DefaultAction", Boolean.TRUE);
            actions.add(updateButton);
        }
        if (this.myWhatsNewAction != null) {
            actions.add(this.myWhatsNewAction);
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            UpdateInfoDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    @Override
    protected String getCancelButtonText() {
        return IdeBundle.message((String)"updates.remind.later.button", (Object[])new Object[0]);
    }

    private void downloadPatchAndRestart() {
        boolean updatePlugins;
        boolean bl = updatePlugins = !ContainerUtil.isEmpty(this.myUpdatedPlugins);
        if (updatePlugins && !new PluginUpdateInfoDialog(this.myUpdatedPlugins).showAndGet()) {
            return;
        }
        new Task.Backgroundable(null, IdeBundle.message((String)"update.preparing", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                String[] command;
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    if (UpdateInfoDialog.this.myTestPatch != null) {
                        command = UpdateInstaller.preparePatchCommand(UpdateInfoDialog.this.myTestPatch, indicator);
                    } else {
                        List<File> files2 = UpdateInstaller.downloadPatchChain(UpdateInfoDialog.this.myPatches.getChain(), indicator);
                        command = UpdateInstaller.preparePatchCommand(files2, indicator);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logger.getInstance(UpdateInstaller.class).warn((Throwable)e);
                    String title = IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]);
                    String message = IdeBundle.message((String)"update.downloading.patch.error", (Object[])new Object[]{e.getMessage(), UpdateInfoDialog.this.downloadUrl()});
                    UpdateChecker.getNotificationGroup().createNotification(title, message, NotificationType.ERROR, NotificationListener.URL_OPENING_LISTENER, "ide.patch.download.failed").notify(null);
                    return;
                }
                if (updatePlugins) {
                    UpdateInstaller.installPluginUpdates(UpdateInfoDialog.this.myUpdatedPlugins, indicator);
                }
                if (ApplicationManager.getApplication().isRestartCapable()) {
                    if (indicator.isShowing()) {
                        UpdateInfoDialog.restartLaterAndRunCommand(command);
                    } else {
                        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
                        String message = IdeBundle.message((String)"update.ready.message", (Object[])new Object[0]);
                        UpdateChecker.getNotificationGroup().createNotification(title, message, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                                if (notification == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (e == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                UpdateInfoDialog.restartLaterAndRunCommand(command);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "notification";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "e";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog$5$1";
                                objectArray[2] = "hyperlinkActivated";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }, "ide.update.suggest.restart").notify(null);
                    }
                } else {
                    UpdateInfoDialog.showPatchInstructions(command);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog$5", "run"));
            }
        }.queue();
    }

    private static void restartLaterAndRunCommand(String[] command) {
        IdeUpdateUsageTriggerCollector.trigger("dialog.update.started");
        PropertiesComponent.getInstance().setValue("ide.self.update.started.for.build", ApplicationInfo.getInstance().getBuild().asString());
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        application.invokeLater(() -> application.restart(6, command));
    }

    private String downloadUrl() {
        String url = this.myNewBuild.getDownloadUrl();
        if (url == null) {
            url = this.myNewBuild.getBlogPost();
        }
        if (url == null) {
            url = this.myUpdatedChannel.getUrl();
        }
        if (url == null) {
            url = "https://www.jetbrains.com";
        }
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(url);
    }

    private static void showPatchInstructions(String[] command) {
        String product = StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getFullProductName().replace(' ', '-'));
        String version2 = ApplicationInfo.getInstance().getFullVersion();
        File file2 = new File(SystemProperties.getUserHome(), product + "-" + version2 + "-patch." + (SystemInfo.isWindows ? "cmd" : "sh"));
        try {
            String text = (SystemInfo.isWindows ? "@echo off\n\n" : "#!/bin/sh\n\n") + StringUtil.join((Collection)CommandLineUtil.toCommandLine(Arrays.asList(command)), (String)" ");
            FileUtil.writeToFile((File)file2, (String)text);
            FileUtil.setExecutable((File)file2);
        }
        catch (Exception e) {
            Logger.getInstance(UpdateInstaller.class).error((Throwable)e);
            return;
        }
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        String message = IdeBundle.message((String)"update.apply.manually.message", (Object[])new Object[]{file2});
        IdeUpdateUsageTriggerCollector.trigger("dialog.manual.patch.prepared");
        ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)message, (String)title));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBuild";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

