/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public interface StatusBarWidgetWrapper {
    @NotNull
    public static JComponent wrap(@NotNull StatusBarWidget.WidgetPresentation presentation2) {
        if (presentation2 == null) {
            StatusBarWidgetWrapper.$$$reportNull$$$0(0);
        }
        if (presentation2 instanceof StatusBarWidget.IconPresentation) {
            return new Icon((StatusBarWidget.IconPresentation)presentation2);
        }
        if (presentation2 instanceof StatusBarWidget.TextPresentation) {
            return new Text((StatusBarWidget.TextPresentation)presentation2);
        }
        if (presentation2 instanceof StatusBarWidget.MultipleTextValuesPresentation) {
            return new MultipleTextValues((StatusBarWidget.MultipleTextValuesPresentation)presentation2);
        }
        throw new IllegalArgumentException("Unable to find a wrapper for presentation: " + presentation2.getClass().getSimpleName());
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation();

    public void beforeUpdate();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetWrapper", "wrap"));
    }

    public static class StatusBarWidgetClickListener
    extends ClickListener {
        private final Consumer<? super MouseEvent> myClickConsumer;

        public StatusBarWidgetClickListener(@NotNull Consumer<? super MouseEvent> consumer) {
            if (consumer == null) {
                StatusBarWidgetClickListener.$$$reportNull$$$0(0);
            }
            this.myClickConsumer = consumer;
        }

        public boolean onClick(@NotNull MouseEvent e, int clickCount) {
            if (e == null) {
                StatusBarWidgetClickListener.$$$reportNull$$$0(1);
            }
            if (!e.isPopupTrigger() && 1 == e.getButton()) {
                this.myClickConsumer.consume((Object)e);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetWrapper$StatusBarWidgetClickListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onClick";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Icon
    extends TextPanel.WithIconAndArrows
    implements StatusBarWidgetWrapper {
        private final StatusBarWidget.IconPresentation myPresentation;

        public Icon(@NotNull StatusBarWidget.IconPresentation presentation2) {
            if (presentation2 == null) {
                Icon.$$$reportNull$$$0(0);
            }
            this.myPresentation = presentation2;
            this.setTextAlignment(0.5f);
            this.setIcon(this.myPresentation.getIcon());
            this.setVisible(this.hasIcon());
            this.setBorder(StatusBarWidget.WidgetBorder.ICON);
            Consumer clickConsumer = this.myPresentation.getClickConsumer();
            if (clickConsumer != null) {
                new StatusBarWidgetClickListener((Consumer<? super MouseEvent>)clickConsumer).installOn((Component)((Object)this), true);
            }
        }

        @Override
        @NotNull
        public StatusBarWidget.WidgetPresentation getPresentation() {
            StatusBarWidget.IconPresentation iconPresentation = this.myPresentation;
            if (iconPresentation == null) {
                Icon.$$$reportNull$$$0(1);
            }
            return iconPresentation;
        }

        @Override
        public void beforeUpdate() {
            this.setIcon(this.myPresentation.getIcon());
            this.setVisible(this.hasIcon());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetWrapper$Icon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetWrapper$Icon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Text
    extends TextPanel
    implements StatusBarWidgetWrapper {
        private final StatusBarWidget.TextPresentation myPresentation;

        public Text(@NotNull StatusBarWidget.TextPresentation presentation2) {
            if (presentation2 == null) {
                Text.$$$reportNull$$$0(0);
            }
            this.myPresentation = presentation2;
            this.setTextAlignment(presentation2.getAlignment());
            this.setVisible(!this.myPresentation.getText().isEmpty());
            this.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
            Consumer clickConsumer = this.myPresentation.getClickConsumer();
            if (clickConsumer != null) {
                new StatusBarWidgetClickListener((Consumer<? super MouseEvent>)clickConsumer).installOn((Component)((Object)this), true);
            }
        }

        @Override
        @NotNull
        public StatusBarWidget.WidgetPresentation getPresentation() {
            StatusBarWidget.TextPresentation textPresentation = this.myPresentation;
            if (textPresentation == null) {
                Text.$$$reportNull$$$0(1);
            }
            return textPresentation;
        }

        @Override
        public void beforeUpdate() {
            String text = this.myPresentation.getText();
            this.setText(text);
            this.setVisible(!text.isEmpty());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetWrapper$Text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetWrapper$Text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class MultipleTextValues
    extends TextPanel.WithIconAndArrows
    implements StatusBarWidgetWrapper {
        private final StatusBarWidget.MultipleTextValuesPresentation myPresentation;

        public MultipleTextValues(@NotNull StatusBarWidget.MultipleTextValuesPresentation presentation2) {
            if (presentation2 == null) {
                MultipleTextValues.$$$reportNull$$$0(0);
            }
            this.myPresentation = presentation2;
            this.setVisible(StringUtil.isNotEmpty((String)this.myPresentation.getSelectedValue()));
            this.setTextAlignment(0.5f);
            this.setBorder(StatusBarWidget.WidgetBorder.WIDE);
            new ClickListener(){
                private final PopupState myPopupState = new PopupState();

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.myPopupState.isRecentlyHidden()) {
                        return false;
                    }
                    ListPopup popup2 = myPresentation.getPopupStep();
                    if (popup2 == null) {
                        return false;
                    }
                    Dimension dimension = popup2.getContent().getPreferredSize();
                    Point at = new Point(0, -dimension.height);
                    popup2.addListener((JBPopupListener)this.myPopupState);
                    popup2.show(new RelativePoint(e.getComponent(), at));
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetWrapper$MultipleTextValues$1", "onClick"));
                }
            }.installOn((Component)((Object)this), true);
        }

        @Override
        public Font getFont() {
            return SystemInfo.isMac ? JBUI.Fonts.label((float)11.0f) : JBFont.label();
        }

        @Override
        public void beforeUpdate() {
            String value2 = this.myPresentation.getSelectedValue();
            this.setText(value2);
            this.setIcon(this.myPresentation.getIcon());
            this.setVisible(StringUtil.isNotEmpty((String)value2));
        }

        @Override
        @NotNull
        public StatusBarWidget.WidgetPresentation getPresentation() {
            StatusBarWidget.MultipleTextValuesPresentation multipleTextValuesPresentation = this.myPresentation;
            if (multipleTextValuesPresentation == null) {
                MultipleTextValues.$$$reportNull$$$0(1);
            }
            return multipleTextValuesPresentation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetWrapper$MultipleTextValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetWrapper$MultipleTextValues";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

