/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterAST;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.roots.impl.PushedFilePropertiesRetriever;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubBuilderType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.PsiDependentFileContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubTreeBuilder {
    private static final Key<Stub> stubElementKey = Key.create((String)"stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    static boolean requiresContentToFindBuilder(@NotNull FileType fileType) {
        if (fileType == null) {
            StubTreeBuilder.$$$reportNull$$$0(0);
        }
        BinaryFileStubBuilder builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
        return builder2 instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder;
    }

    static StubBuilderType getStubBuilderType(@NotNull IndexedFile file2, boolean toBuild) {
        FileType fileType;
        BinaryFileStubBuilder builder2;
        if (file2 == null) {
            StubTreeBuilder.$$$reportNull$$$0(1);
        }
        if ((builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType = file2.getFileType())) != null) {
            if (builder2 instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder) {
                Object subBuilder = ((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2).getSubBuilder((FileContent)file2);
                return new StubBuilderType((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2, subBuilder);
            }
            return new StubBuilderType(builder2);
        }
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return null;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (!(elementType instanceof IStubFileElementType)) {
                return null;
            }
            VirtualFile vFile = file2.getFile();
            boolean shouldBuildStubFor = ((IStubFileElementType)elementType).shouldBuildStubFor(vFile);
            if (toBuild && !shouldBuildStubFor) {
                return null;
            }
            @NotNull List properties = PushedFilePropertiesRetriever.getInstance().dumpSortedPushedProperties(vFile);
            return new StubBuilderType((IStubFileElementType)elementType, properties);
        }
        return null;
    }

    @Nullable
    public static Stub buildStubTree(@NotNull FileContent inputData) {
        StubBuilderType type;
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(2);
        }
        if ((type = StubTreeBuilder.getStubBuilderType((IndexedFile)inputData, false)) == null) {
            return null;
        }
        return StubTreeBuilder.buildStubTree(inputData, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Stub buildStubTree(@NotNull FileContent inputData, @NotNull StubBuilderType stubBuilderType) {
        Stub data2;
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(3);
        }
        if (stubBuilderType == null) {
            StubTreeBuilder.$$$reportNull$$$0(4);
        }
        if ((data2 = (Stub)inputData.getUserData(stubElementKey)) != null) {
            return data2;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data2 = (Stub)inputData.getUserData(stubElementKey);
            if (data2 != null) {
                return data2;
            }
            BinaryFileStubBuilder builder2 = stubBuilderType.getBinaryFileStubBuilder();
            if (builder2 != null) {
                data2 = builder2.buildStubTree(inputData);
                if (data2 instanceof PsiFileStubImpl && !((PsiFileStubImpl)data2).rootsAreSet()) {
                    ((PsiFileStubImpl)data2).setStubRoots(new PsiFileStub[]{(PsiFileStubImpl)data2});
                }
            } else {
                CharSequence contentAsText = inputData.getContentAsText();
                PsiDependentFileContent fileContent2 = (PsiDependentFileContent)inputData;
                PsiFile psi = fileContent2.getPsiFile();
                FileViewProvider viewProvider = psi.getViewProvider();
                psi = viewProvider.getStubBindingRoot();
                psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, (Object)contentAsText);
                psi.getManager().startBatchFilesProcessingMode();
                try {
                    IStubFileElementType stubFileElementType = ((PsiFileImpl)psi).getElementTypeForStubBuilder();
                    if (stubFileElementType != null) {
                        PsiFileStub[] stubsArray;
                        StubBuilder stubBuilder = stubFileElementType.getBuilder();
                        if (stubBuilder instanceof LightStubBuilder) {
                            LightStubBuilder.FORCED_AST.set(fileContent2.getLighterAST());
                        }
                        data2 = stubBuilder.buildStubTree(psi);
                        List<Pair<IStubFileElementType, PsiFile>> stubbedRoots = StubTreeBuilder.getStubbedRoots(viewProvider);
                        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubbedRoots.size());
                        stubs.add((PsiFileStub)data2);
                        for (Pair<IStubFileElementType, PsiFile> stubbedRoot : stubbedRoots) {
                            StubElement element2;
                            PsiFile secondaryPsi = (PsiFile)stubbedRoot.second;
                            if (psi == secondaryPsi) continue;
                            StubBuilder stubbedRootBuilder = ((IStubFileElementType)((Object)stubbedRoot.first)).getBuilder();
                            if (stubbedRootBuilder instanceof LightStubBuilder) {
                                LightStubBuilder.FORCED_AST.set((LighterAST)new TreeBackedLighterAST(secondaryPsi.getNode()));
                            }
                            if ((element2 = stubbedRootBuilder.buildStubTree(secondaryPsi)) instanceof PsiFileStub) {
                                stubs.add((PsiFileStub)element2);
                            }
                            StubTreeBuilder.ensureNormalizedOrder((Stub)element2);
                        }
                        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
                            if (!(stub instanceof PsiFileStubImpl)) continue;
                            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
                        }
                    }
                }
                finally {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                    psi.getManager().finishBatchFilesProcessingMode();
                }
            }
            StubTreeBuilder.ensureNormalizedOrder(data2);
            inputData.putUserData(stubElementKey, (Object)data2);
            return data2;
        }
    }

    private static void ensureNormalizedOrder(Stub element2) {
        if (element2 instanceof StubBase) {
            ((StubBase)element2).myStubList.finalizeLoadingStage();
        }
    }

    @NotNull
    public static List<Pair<IStubFileElementType, PsiFile>> getStubbedRoots(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            StubTreeBuilder.$$$reportNull$$$0(5);
        }
        SmartList roots = new SmartList();
        PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        for (Language language : viewProvider.getLanguages()) {
            IStubFileElementType type;
            PsiFile file2 = viewProvider.getPsi(language);
            if (!(file2 instanceof PsiFileImpl) || (type = ((PsiFileImpl)file2).getElementTypeForStubBuilder()) == null) continue;
            roots.add(Trinity.create((Object)language, (Object)((Object)type), (Object)file2));
        }
        ContainerUtil.sort((List)roots, (o1, o2) -> {
            if (o1.third == stubBindingRoot) {
                return o2.third == stubBindingRoot ? 0 : -1;
            }
            if (o2.third == stubBindingRoot) {
                return 1;
            }
            return StringUtil.compare((String)((Language)o1.first).getID(), (String)((Language)o2.first).getID(), (boolean)false);
        });
        List list2 = ContainerUtil.map((Collection)roots, trinity -> Pair.create((Object)((Object)((IStubFileElementType)((Object)((Object)trinity.second)))), (Object)((PsiFile)trinity.third)));
        if (list2 == null) {
            StubTreeBuilder.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubBuilderType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requiresContentToFindBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStubBuilderType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStubbedRoots";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

