/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.invertBoolean.InvertBooleanHandler;
import com.intellij.refactoring.invertBoolean.InvertBooleanUsageViewDescriptor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvertBooleanProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(InvertBooleanProcessor.class);
    private final InvertBooleanDelegate myDelegate;
    private PsiElement myElement;
    private final String myNewName;
    private final RenameProcessor myRenameProcessor;
    private final Map<UsageInfo, SmartPsiElementPointer> myToInvert = new HashMap<UsageInfo, SmartPsiElementPointer>();
    private final SmartPointerManager mySmartPointerManager;

    public InvertBooleanProcessor(PsiElement namedElement, String newName) {
        super(namedElement.getProject());
        this.myElement = namedElement;
        this.myNewName = newName;
        Project project = namedElement.getProject();
        boolean canRename = namedElement instanceof PsiNamedElement && !Objects.equals(((PsiNamedElement)namedElement).getName(), this.myNewName);
        this.myRenameProcessor = canRename ? new RenameProcessor(project, namedElement, newName, false, false){

            @Override
            @NotNull
            protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
                if (conflicts == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new ConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> InvertBooleanProcessor.this.execute(usages), false, true);
            }

            @Override
            protected void prepareSuccessful() {
                InvertBooleanProcessor.this.prepareSuccessful();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor$1", "createConflictsDialog"));
            }
        } : null;
        this.mySmartPointerManager = SmartPointerManager.getInstance((Project)project);
        this.myDelegate = InvertBooleanDelegate.findInvertBooleanDelegate(this.myElement);
        LOG.assertTrue(this.myDelegate != null);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(0);
        }
        return new InvertBooleanUsageViewDescriptor(this.myElement);
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(1);
        }
        MultiMap conflicts = new MultiMap();
        UsageInfo[] usageInfos = (UsageInfo[])refUsages.get();
        this.myDelegate.findConflicts(usageInfos, (MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty()) {
            return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usageInfos);
        }
        if (this.myRenameProcessor == null || this.myRenameProcessor.preprocessUsages(refUsages)) {
            this.prepareSuccessful();
            return true;
        }
        return false;
    }

    @Override
    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<SmartPsiElementPointer> toInvert = new ArrayList<SmartPsiElementPointer>();
        LinkedHashSet<PsiElement> elementsToInvert = new LinkedHashSet<PsiElement>();
        this.myDelegate.collectRefElements(this.myElement, this.myRenameProcessor, this.myNewName, elementsToInvert);
        for (PsiElement element2 : elementsToInvert) {
            toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer(element2));
        }
        UsageInfo[] renameUsages = this.myRenameProcessor != null ? this.myRenameProcessor.findUsages() : UsageInfo.EMPTY_ARRAY;
        SmartPsiElementPointer[] usagesToInvert = toInvert.toArray(new SmartPsiElementPointer[0]);
        HashMap<PsiElement, UsageInfo> expressionsToUsages = new HashMap<PsiElement, UsageInfo>();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (UsageInfo usageInfo : renameUsages) {
            expressionsToUsages.put(usageInfo.getElement(), usageInfo);
            result2.add(usageInfo);
        }
        for (UsageInfo usageInfo : usagesToInvert) {
            PsiElement expression = usageInfo.getElement();
            if (!expressionsToUsages.containsKey(expression)) {
                UsageInfo usageInfo2 = new UsageInfo(expression);
                expressionsToUsages.put(expression, usageInfo2);
                result2.add(usageInfo2);
                this.myToInvert.put(usageInfo2, (SmartPsiElementPointer)usageInfo);
                continue;
            }
            this.myToInvert.put((UsageInfo)expressionsToUsages.get(expression), (SmartPsiElementPointer)usageInfo);
        }
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(3);
        }
        this.myElement = elements2[0];
    }

    private static UsageInfo[] extractUsagesForElement(PsiElement element2, UsageInfo[] usages) {
        ArrayList<MoveRenameUsageInfo> extractedUsages = new ArrayList<MoveRenameUsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            MoveRenameUsageInfo usageInfo;
            if (!(usage instanceof MoveRenameUsageInfo) || !element2.equals((usageInfo = (MoveRenameUsageInfo)usage).getReferencedElement())) continue;
            extractedUsages.add(usageInfo);
        }
        return extractedUsages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    @Override
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(4);
        }
        if (this.myRenameProcessor != null) {
            for (PsiElement element2 : this.myRenameProcessor.getElements()) {
                try {
                    RenameUtil.doRename(element2, this.myRenameProcessor.getNewName(element2), InvertBooleanProcessor.extractUsagesForElement(element2, usages), this.myProject, null);
                }
                catch (IncorrectOperationException e) {
                    RenameUtil.showErrorMessage(e, element2, this.myProject);
                    return;
                }
            }
        }
        for (UsageInfo usage : usages) {
            SmartPsiElementPointer pointerToInvert = this.myToInvert.get(usage);
            if (pointerToInvert == null) continue;
            PsiElement element3 = pointerToInvert.getElement();
            LOG.assertTrue(element3 != null);
            InvertBooleanDelegate delegate = InvertBooleanDelegate.findInvertBooleanDelegate(element3);
            try {
                (delegate != null ? delegate : this.myDelegate).replaceWithNegatedExpression(element3);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myDelegate.invertElementInitializer(this.myElement);
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = InvertBooleanHandler.getRefactoringName();
        if (string == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

