/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CardLayoutPanel<K, UI, V extends Component>
extends JComponent
implements Accessible,
Disposable {
    private final IdentityHashMap<K, V> myContent = new IdentityHashMap();
    private volatile boolean myDisposed;
    private K myKey;

    protected abstract UI prepare(K var1);

    protected abstract V create(UI var1);

    @Deprecated
    protected void dispose(K key) {
    }

    protected void dispose(K key, V value2) {
        this.dispose(key);
    }

    public void dispose() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            this.removeAll();
        }
    }

    public K getKey() {
        return this.myKey;
    }

    public V getValue(K key, boolean create2) {
        Component value2 = (Component)this.myContent.get(key);
        return (V)(create2 && value2 == null && !this.myContent.containsKey(key) ? this.createValue(key, this.prepare(key)) : value2);
    }

    private V createValue(K key, UI ui) {
        V value2 = this.create(ui);
        this.myContent.put(key, value2);
        if (value2 != null) {
            ((Component)value2).setVisible(false);
            this.add((Component)value2);
        }
        return value2;
    }

    public ActionCallback select(K key, boolean now) {
        this.myKey = key;
        ActionCallback callback2 = new ActionCallback();
        if (now) {
            this.select(callback2, key, this.prepare(key));
        } else {
            this.selectLater(callback2, key);
        }
        return callback2;
    }

    private void select(ActionCallback callback2, K key, UI ui) {
        if (this.myKey != key) {
            callback2.setRejected();
        } else {
            Component value2 = (Component)this.myContent.get(key);
            if (value2 == null && !this.myContent.containsKey(key)) {
                value2 = this.createValue(key, ui);
            }
            for (Component component2 : this.getComponents()) {
                component2.setVisible(component2 == value2);
            }
            callback2.setDone();
        }
    }

    private void selectLater(ActionCallback callback2, K key) {
        ModalityState modality = ModalityState.stateForComponent((Component)this);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!this.myDisposed) {
                UI ui1 = this.prepare(key);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!this.myDisposed) {
                        this.select(callback2, key, ui1);
                    } else {
                        callback2.setRejected();
                    }
                }, modality);
            } else {
                callback2.setRejected();
            }
        });
    }

    @Override
    public void doLayout() {
        Rectangle bounds2 = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds2, (Insets)this.getInsets());
        for (Component component2 : this.getComponents()) {
            component2.setBounds(bounds2);
        }
    }

    @Nullable
    private Component getVisibleComponent() {
        for (Component component2 : this.getComponents()) {
            if (!component2.isVisible()) continue;
            return component2;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        Component component2;
        Component component3 = component2 = this.isPreferredSizeSet() ? null : this.getVisibleComponent();
        if (component2 == null) {
            return super.getPreferredSize();
        }
        Dimension size = component2.getPreferredSize();
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Component component2;
        Component component3 = component2 = this.isMinimumSizeSet() ? null : this.getVisibleComponent();
        if (component2 == null) {
            return super.getMinimumSize();
        }
        Dimension size = component2.getMinimumSize();
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @Override
    public void remove(int index) {
        super.remove(index);
        IdentityHashMap<Object, Component> map2 = new IdentityHashMap<Object, Component>();
        Iterator<Map.Entry<K, V>> it = this.myContent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            Component value2 = (Component)entry.getValue();
            if (value2 == null || this == value2.getParent()) continue;
            map2.put(entry.getKey(), value2);
            it.remove();
        }
        map2.forEach(this::dispose);
    }

    @Nullable
    protected final V resetValue(@NotNull K key) {
        Component content2;
        if (key == null) {
            CardLayoutPanel.$$$reportNull$$$0(0);
        }
        if ((content2 = (Component)this.myContent.remove(key)) != null) {
            for (Component component2 : this.getComponents()) {
                if (component2 != content2) continue;
                this.remove(component2);
            }
            if (this.myKey == key) {
                this.myKey = null;
                this.select(key, true);
            }
        }
        return (V)content2;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        IdentityHashMap<Object, Component> map2 = new IdentityHashMap<Object, Component>(this.myContent);
        this.myContent.clear();
        map2.forEach(this::dispose);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCardLayoutPanel();
        }
        return this.accessibleContext;
    }

    protected final boolean isDisposed() {
        return this.myDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ui/CardLayoutPanel", "resetValue"));
    }

    protected class AccessibleCardLayoutPanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleCardLayoutPanel() {
            super(CardLayoutPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

