/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import javax.swing.Icon;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownRecursiveElementVisitor;
import org.intellij.plugins.markdown.lang.stubs.MarkdownStubBasedPsiElementBase;
import org.intellij.plugins.markdown.lang.stubs.MarkdownStubElement;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElement;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElementType;
import org.intellij.plugins.markdown.structureView.MarkdownStructureColors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownHeaderImpl
extends MarkdownStubBasedPsiElementBase<MarkdownStubElement> {
    public MarkdownHeaderImpl(@NotNull ASTNode node) {
        if (node == null) {
            MarkdownHeaderImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public MarkdownHeaderImpl(MarkdownHeaderStubElement stub, MarkdownHeaderStubElementType type) {
        super(stub, type);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            MarkdownHeaderImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof MarkdownRecursiveElementVisitor) {
            ((MarkdownRecursiveElementVisitor)visitor).visitHeader(this);
            return;
        }
        super.accept(visitor);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        String headerText = this.getHeaderText();
        final String text = headerText == null ? "Invalid header: " + this.getText() : headerText;
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return text;
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return null;
            }

            public TextAttributesKey getTextAttributesKey() {
                return MarkdownHeaderImpl.this.getHeaderNumber() == 1 ? MarkdownStructureColors.MARKDOWN_HEADER_BOLD : MarkdownStructureColors.MARKDOWN_HEADER;
            }
        };
    }

    @Nullable
    private String getHeaderText() {
        if (!this.isValid()) {
            return null;
        }
        PsiElement contentHolder = this.findChildByType(MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES);
        if (contentHolder == null) {
            return null;
        }
        return StringUtil.trim((String)contentHolder.getText());
    }

    public int getHeaderNumber() {
        IElementType type = this.getNode().getElementType();
        if (MarkdownTokenTypeSets.HEADER_LEVEL_1_SET.contains(type)) {
            return 1;
        }
        if (MarkdownTokenTypeSets.HEADER_LEVEL_2_SET.contains(type)) {
            return 2;
        }
        if (type == MarkdownElementTypes.ATX_3) {
            return 3;
        }
        if (type == MarkdownElementTypes.ATX_4) {
            return 4;
        }
        if (type == MarkdownElementTypes.ATX_5) {
            return 5;
        }
        if (type == MarkdownElementTypes.ATX_6) {
            return 6;
        }
        throw new IllegalStateException("Type should be one of header types");
    }

    public String getName() {
        return this.getHeaderText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

