/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;

@Service
final class SvnCompatibilityChecker
implements Disposable {
    private final Project myProject;
    private static final long ourFrequency = 10L;
    private static final long ourInvocationMax = 10L;
    private static final long ourInitCounter = 3L;
    private long myCounter;
    private long myDownStartCounter;
    private long myInvocationCounter;
    private final Object myLock;

    SvnCompatibilityChecker(@NotNull Project project) {
        if (project == null) {
            SvnCompatibilityChecker.$$$reportNull$$$0(0);
        }
        this.myCounter = 0L;
        this.myDownStartCounter = 3L;
        this.myInvocationCounter = 0L;
        this.myLock = new Object();
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndNotify(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            SvnCompatibilityChecker.$$$reportNull$$$0(1);
        }
        if (roots.isEmpty()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInvocationCounter >= 10L) {
                return;
            }
            ++this.myCounter;
            --this.myDownStartCounter;
            if (this.myCounter <= 10L && this.myDownStartCounter < 0L) {
                return;
            }
            this.myCounter = 0L;
            ++this.myInvocationCounter;
        }
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this, () -> {
            List incompatible = ContainerUtil.filter((Collection)roots, SvnCompatibilityChecker::seemsVersioned);
            if (!incompatible.isEmpty()) {
                this.notify(incompatible);
            }
        });
    }

    public void dispose() {
    }

    private void notify(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            SvnCompatibilityChecker.$$$reportNull$$$0(2);
        }
        String message = roots.size() == 1 ? "Root '" + roots.get(0).getPresentableName() + "' is likely to be of unsupported Subversion format" : "Some roots are likely to be of unsupported Subversion format";
        ApplicationManager.getApplication().invokeLater(() -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            new VcsBalloonProblemNotifier(this.myProject, message, MessageType.WARNING).run();
        }, ModalityState.NON_MODAL);
    }

    private static boolean seemsVersioned(@NotNull VirtualFile root) {
        if (root == null) {
            SvnCompatibilityChecker.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        return SvnUtil.seemsLikeVersionedDir(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/SvnCompatibilityChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndNotify";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notify";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "seemsVersioned";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

