/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class StatisticsEventEscaper {
    @NotNull
    public static String escape(@NotNull String str) {
        if (str == null) {
            StatisticsEventEscaper.$$$reportNull$$$0(0);
        }
        return StatisticsEventEscaper.escapeInternal(str, false);
    }

    @NotNull
    public static String escapeFieldName(@NotNull String str) {
        if (str == null) {
            StatisticsEventEscaper.$$$reportNull$$$0(1);
        }
        return StatisticsEventEscaper.escapeInternal(str, true);
    }

    @NotNull
    private static String escapeInternal(@NotNull String str, boolean replaceDot) {
        if (str == null) {
            StatisticsEventEscaper.$$$reportNull$$$0(2);
        }
        if (StatisticsEventEscaper.containsSystemSymbols(str, replaceDot)) {
            return StatisticsEventEscaper.replace(str, replaceDot);
        }
        String string = str;
        if (string == null) {
            StatisticsEventEscaper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String replace(@NotNull String value, boolean replaceDot) {
        if (value == null) {
            StatisticsEventEscaper.$$$reportNull$$$0(4);
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!StatisticsEventEscaper.isAscii(c)) {
                out.append("?");
                continue;
            }
            if (StatisticsEventEscaper.isSymbolToReplace(c, replaceDot)) {
                out.append("_");
                continue;
            }
            if (StatisticsEventEscaper.isProhibitedSymbol(c)) continue;
            out.append(c);
        }
        String string = out.toString();
        if (string == null) {
            StatisticsEventEscaper.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean containsSystemSymbols(@NotNull String value, boolean replaceDot) {
        if (value == null) {
            StatisticsEventEscaper.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!StatisticsEventEscaper.isAscii(c)) {
                return true;
            }
            if (StatisticsEventEscaper.isSymbolToReplace(c, replaceDot)) {
                return true;
            }
            if (!StatisticsEventEscaper.isProhibitedSymbol(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private static boolean isSymbolToReplace(char c, boolean withDot) {
        if (withDot && c == '.') {
            return true;
        }
        return StatisticsEventEscaper.isAsciiControl(c) || StatisticsEventEscaper.isWhiteSpace(c) || c == ':' || c == ';' || c == ',';
    }

    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    private static boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    private static boolean isProhibitedSymbol(char c) {
        return c == '\'' || c == '\"';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/StatisticsEventEscaper";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/StatisticsEventEscaper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeInternal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "escapeFieldName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "escapeInternal";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsSystemSymbols";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

