/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentHintManager;
import com.intellij.execution.ui.FragmentedSettingsBuilder;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CommandLinePanel
extends JPanel {
    private final List<JComponent> myComponents;
    private final JLabel myHintLabel;
    private int myLastWidth;

    public CommandLinePanel(Collection<? extends SettingsEditorFragment<?, ?>> fragments) {
        this.myComponents = ContainerUtil.map(fragments, fragment -> fragment.createEditor());
        this.myHintLabel = ComponentPanelBuilder.createNonWrappingCommentComponent("");
        FragmentHintManager manager = new FragmentHintManager((Consumer<? super String>)((Consumer)s -> this.myHintLabel.setText((String)s)), null);
        manager.registerFragments(fragments);
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumSize((Dimension)new JBDimension(500, 30));
        this.buildRows();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CommandLinePanel.this.buildRows();
            }
        });
    }

    public void rebuildRows() {
        this.myLastWidth = -1;
        this.buildRows();
    }

    private void buildRows() {
        int parentWidth = Math.max(this.getWidth(), this.getMinimumSize().width);
        if (this.myLastWidth == parentWidth) {
            return;
        }
        this.myLastWidth = parentWidth;
        this.removeAll();
        JPanel row = new JPanel(new GridBagLayout());
        int rowWidth = 0;
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0);
        for (JComponent component : this.myComponents) {
            if (!component.isVisible()) continue;
            int minWidth = component.getMinimumSize().width;
            if (rowWidth + minWidth > parentWidth) {
                this.add(row);
                this.add(Box.createVerticalStrut(5));
                row = new JPanel(new GridBagLayout());
                rowWidth = 0;
                c.gridx = 0;
            }
            row.add((Component)component, c.clone());
            ++c.gridx;
            rowWidth += minWidth;
        }
        this.add(row);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myHintLabel, "West");
        JBDimension size = new JBDimension(100, 20);
        panel2.setMinimumSize((Dimension)size);
        panel2.setPreferredSize((Dimension)size);
        panel2.setBorder((Border)JBUI.Borders.emptyLeft((int)this.getLeftInset()));
        this.add(panel2);
    }

    public int getLeftInset() {
        return Arrays.stream(this.getComponents()).map(component -> FragmentedSettingsBuilder.getLeftInset((JComponent)component)).max(Comparator.comparingInt(o -> o)).orElse(0);
    }

    public static void setMinimumWidth(Component component, int width) {
        Dimension size = new Dimension(width, component.getMinimumSize().height);
        component.setMinimumSize(size);
        component.setPreferredSize(size);
    }
}

