/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemSettings<SS extends AbstractExternalSystemSettings<SS, PS, L>, PS extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<PS>>
implements Disposable {
    @NotNull
    private final AtomicNullableLazyValue<ExternalSystemManager<?, ?, ?, ?, ?>> myManager;
    @NotNull
    private final Topic<L> myChangesTopic;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettings;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettingsView;

    protected AbstractExternalSystemSettings(@NotNull Topic<L> topic, @NotNull Project project) {
        if (topic == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(1);
        }
        this.myLinkedProjectsSettings = new HashMap<String, PS>();
        this.myLinkedProjectsSettingsView = Collections.unmodifiableMap(this.myLinkedProjectsSettings);
        this.myChangesTopic = topic;
        this.myProject = project;
        this.myManager = AtomicNullableLazyValue.createValue(this::deduceManager);
    }

    public void dispose() {
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Nullable
    private ExternalSystemManager<?, ?, ?, ?, ?> deduceManager() {
        return ExternalSystemApiUtil.getAllManagers().stream().filter(it -> this.equals(it.getSettingsProvider().fun((Object)this.myProject))).findFirst().orElse(null);
    }

    public boolean showSelectiveImportDialogOnInitialImport() {
        return SystemProperties.is((String)"external.system.show.selective.import.dialog");
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<PS> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(4);
        }
        this.subscribe(listener2);
    }

    @Deprecated
    public abstract void subscribe(@NotNull ExternalSystemSettingsListener<PS> var1);

    protected void doSubscribe(@NotNull L listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(6);
        }
        MessageBus messageBus = this.myProject.getMessageBus();
        MessageBusConnection connection = messageBus.connect(parentDisposable);
        connection.subscribe(this.getChangesTopic(), listener2);
    }

    public void copyFrom(@NotNull SS settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(7);
        }
        for (ExternalProjectSettings projectSettings : ((AbstractExternalSystemSettings)settings).getLinkedProjectsSettings()) {
            this.myLinkedProjectsSettings.put(projectSettings.getExternalProjectPath(), projectSettings);
        }
        this.copyExtraSettingsFrom(settings);
    }

    protected abstract void copyExtraSettingsFrom(@NotNull SS var1);

    @NotNull
    public Collection<PS> getLinkedProjectsSettings() {
        Collection<PS> collection = this.myLinkedProjectsSettingsView.values();
        if (collection == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Nullable
    public PS getLinkedProjectSettings(@NotNull String linkedProjectPath) {
        ExternalProjectSettings ps;
        if (linkedProjectPath == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(9);
        }
        if ((ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(linkedProjectPath)) == null) {
            for (ExternalProjectSettings ps1 : this.myLinkedProjectsSettings.values()) {
                for (String modulePath : ps1.getModules()) {
                    if (!linkedProjectPath.equals(modulePath)) continue;
                    return (PS)ps1;
                }
            }
        }
        return (PS)ps;
    }

    public void linkProject(@NotNull PS settings) throws IllegalArgumentException {
        PS existing;
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(10);
        }
        if ((existing = this.getLinkedProjectSettings(((ExternalProjectSettings)settings).getExternalProjectPath())) != null) {
            throw new IllegalArgumentException(String.format("Can't link project '%s'. Reason: it's already linked to the IDE project", ((ExternalProjectSettings)settings).getExternalProjectPath()));
        }
        this.myLinkedProjectsSettings.put(((ExternalProjectSettings)settings).getExternalProjectPath(), settings);
        this.onProjectsLinked(Collections.singleton(settings));
    }

    public boolean unlinkExternalProject(@NotNull String linkedProjectPath) {
        ExternalProjectSettings removed;
        if (linkedProjectPath == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(11);
        }
        if ((removed = (ExternalProjectSettings)this.myLinkedProjectsSettings.remove(linkedProjectPath)) == null) {
            return false;
        }
        this.onProjectsUnlinked(Collections.singleton(linkedProjectPath));
        return true;
    }

    public void setLinkedProjectsSettings(@NotNull Collection<? extends PS> settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(12);
        }
        this.setLinkedProjectsSettings(settings, new ExternalSystemSettingsListenerAdapter<PS>(){

            @Override
            public void onProjectsLinked(@NotNull Collection<PS> settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractExternalSystemSettings.this.onProjectsLinked(settings);
            }

            @Override
            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                if (linkedProjectPaths == null) {
                    1.$$$reportNull$$$0(1);
                }
                AbstractExternalSystemSettings.this.onProjectsUnlinked(linkedProjectPaths);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "linkedProjectPaths";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onProjectsLinked";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onProjectsUnlinked";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setLinkedProjectsSettings(@NotNull Collection<? extends PS> settings, @NotNull ExternalSystemSettingsListener<PS> listener2) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(13);
        }
        if (listener2 == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(14);
        }
        settings = ContainerUtil.filter(settings, ps -> ps.getExternalProjectPath() != null);
        ArrayList<ExternalProjectSettings> added = new ArrayList<ExternalProjectSettings>();
        HashMap<String, PS> removed = new HashMap<String, PS>(this.myLinkedProjectsSettings);
        this.myLinkedProjectsSettings.clear();
        for (ExternalProjectSettings current : settings) {
            this.myLinkedProjectsSettings.put(current.getExternalProjectPath(), current);
        }
        for (ExternalProjectSettings current : settings) {
            ExternalProjectSettings old = (ExternalProjectSettings)removed.remove(current.getExternalProjectPath());
            if (old == null) {
                added.add(current);
                continue;
            }
            this.checkSettings(old, current);
        }
        if (!added.isEmpty()) {
            listener2.onProjectsLinked(added);
        }
        if (!removed.isEmpty()) {
            listener2.onProjectsUnlinked(removed.keySet());
        }
    }

    protected abstract void checkSettings(@NotNull PS var1, @NotNull PS var2);

    @NotNull
    public Topic<L> getChangesTopic() {
        Topic<L> topic = this.myChangesTopic;
        if (topic == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(15);
        }
        return topic;
    }

    @NotNull
    public L getPublisher() {
        ExternalSystemSettingsListener externalSystemSettingsListener = (ExternalSystemSettingsListener)this.myProject.getMessageBus().syncPublisher(this.myChangesTopic);
        if (externalSystemSettingsListener == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(16);
        }
        return (L)externalSystemSettingsListener;
    }

    protected void fillState(@NotNull State<PS> state) {
        if (state == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(17);
        }
        state.setLinkedExternalProjectsSettings(new TreeSet<PS>(this.myLinkedProjectsSettings.values()));
    }

    protected void loadState(@NotNull State<PS> state) {
        Set<PS> settings;
        if (state == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(18);
        }
        if ((settings = state.getLinkedExternalProjectsSettings()) != null) {
            this.setLinkedProjectsSettings(settings, new ExternalSystemSettingsListenerAdapter<PS>(){

                @Override
                public void onProjectsLinked(@NotNull Collection<PS> settings) {
                    if (settings == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        AbstractExternalSystemSettings.this.onProjectsLinked(settings);
                        AbstractExternalSystemSettings.this.onProjectsLoaded(settings);
                    }, AbstractExternalSystemSettings.this.myProject.getDisposed());
                }

                @Override
                public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                    if (linkedProjectPaths == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> AbstractExternalSystemSettings.this.onProjectsUnlinked(linkedProjectPaths), AbstractExternalSystemSettings.this.myProject.getDisposed());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "settings";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "linkedProjectPaths";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onProjectsLinked";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onProjectsUnlinked";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private void onProjectsLoaded(@NotNull Collection<PS> settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(19);
        }
        this.getPublisher().onProjectsLoaded(settings);
        ExternalSystemManager manager = (ExternalSystemManager)this.myManager.getValue();
        if (manager != null) {
            ExternalSystemSettingsListenerEx.Companion.onProjectsLoaded(this.myProject, manager, settings);
        }
    }

    private void onProjectsLinked(@NotNull Collection<PS> settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(20);
        }
        this.getPublisher().onProjectsLinked(settings);
        ExternalSystemManager manager = (ExternalSystemManager)this.myManager.getValue();
        if (manager != null) {
            ExternalSystemSettingsListenerEx.Companion.onProjectsLinked(this.myProject, manager, settings);
        }
    }

    private void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
        if (linkedProjectPaths == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(21);
        }
        this.getPublisher().onProjectsUnlinked(linkedProjectPaths);
        ExternalSystemManager manager = (ExternalSystemManager)this.myManager.getValue();
        if (manager != null) {
            ExternalSystemSettingsListenerEx.Companion.onProjectsUnlinked(this.myProject, manager, linkedProjectPaths);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings";
                break;
            }
            case 3: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedProjectsSettings";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesTopic";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSubscribe";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProjectSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "linkProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unlinkExternalProject";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setLinkedProjectsSettings";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onProjectsLoaded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onProjectsLinked";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onProjectsUnlinked";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface State<S> {
        public Set<S> getLinkedExternalProjectsSettings();

        public void setLinkedExternalProjectsSettings(Set<S> var1);
    }
}

