/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.VirtualFileFilteringListener;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewVirtualFileSystem
extends VirtualFileSystem
implements FileSystemInterface,
CachingVirtualFileSystem {
    private final Map<VirtualFileListener, VirtualFileListener> myListenerWrappers = new ConcurrentHashMap<VirtualFileListener, VirtualFileListener>();

    @ApiStatus.OverrideOnly
    @Nullable
    protected String normalize(@NotNull String path2) {
        if (path2 == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(0);
        }
        return path2;
    }

    @ApiStatus.OverrideOnly
    @NotNull
    protected abstract String extractRootPath(@NotNull String var1);

    @Nullable
    public abstract VirtualFile findFileByPathIfCached(@NotNull String var1);

    @Override
    public void refreshWithoutFileWatcher(boolean asynchronous) {
        this.refresh(asynchronous);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    public String resolveSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(3);
        }
        VirtualFileFilteringListener wrapper = new VirtualFileFilteringListener(listener2, this);
        VirtualFileManager.getInstance().addVirtualFileListener(wrapper);
        this.myListenerWrappers.put(listener2, wrapper);
    }

    @Override
    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        VirtualFileListener wrapper;
        if (listener2 == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(4);
        }
        if ((wrapper = this.myListenerWrappers.remove(listener2)) != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener(wrapper);
        }
    }

    public abstract int getRank();

    @Override
    @NotNull
    public abstract VirtualFile copyFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3, @NotNull String var4) throws IOException;

    @Override
    @NotNull
    public abstract VirtualFile createChildDirectory(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @Override
    @NotNull
    public abstract VirtualFile createChildFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @Override
    public abstract void deleteFile(Object var1, @NotNull VirtualFile var2) throws IOException;

    @Override
    public abstract void moveFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3) throws IOException;

    @Override
    public abstract void renameFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    public boolean markNewFilesAsDirty() {
        return false;
    }

    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file) {
        if (file == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(5);
        }
        String string = file.getName();
        if (string == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public abstract FileAttributes getAttributes(@NotNull VirtualFile var1);

    public boolean hasChildren(@NotNull VirtualFile file) {
        if (file == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(7);
        }
        return this.list(file).length != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicallyCasedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFileListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeVirtualFileListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicallyCasedName";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

